/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.block;

import java.util.List;
import java.util.Set;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.block.BlockBasic;
import muramasa.antimatter.client.AntimatterModelManager;
import muramasa.antimatter.datagen.builder.AntimatterBlockModelBuilder;
import muramasa.antimatter.datagen.providers.AntimatterBlockStateProvider;
import muramasa.antimatter.registration.IRegistryEntryProvider;
import muramasa.antimatter.registration.RegistryType;
import muramasa.antimatter.tile.TileEntityFakeBlock;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.HitResult;
import org.jetbrains.annotations.Nullable;

public class BlockProxy
extends BlockBasic
implements IRegistryEntryProvider,
EntityBlock {
    public BlockEntityType<TileEntityFakeBlock> TYPE;

    public BlockProxy(String domain, String id, BlockBehaviour.Properties properties) {
        super(domain, id, properties);
        AntimatterAPI.register(IRegistryEntryProvider.class, this);
    }

    public BlockProxy(String domain, String id) {
        super(domain, id);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{BlockStateProperties.f_61372_});
    }

    @Override
    public void onBlockModelBuild(Block block, AntimatterBlockStateProvider prov) {
        AntimatterBlockModelBuilder builder = prov.getBuilder(block);
        builder.loader(AntimatterModelManager.LOADER_PROXY);
        prov.state(block, builder);
    }

    public ItemStack getCloneItemStack(BlockState state, HitResult target, BlockGetter world, BlockPos pos, Player player) {
        TileEntityFakeBlock tile = (TileEntityFakeBlock)world.m_7702_(pos);
        return tile != null && tile.getState() != null ? tile.getState().m_60734_().m_5456_().m_7968_() : ItemStack.f_41583_;
    }

    @Override
    public void onRegistryBuild(RegistryType registry) {
        if (registry == RegistryType.BLOCK_ENTITIES) {
            this.TYPE = new BlockEntityType((a, b) -> new TileEntityFakeBlock(this, a, b), Set.of(this), null);
            AntimatterAPI.register(BlockEntityType.class, this.getId(), this.getDomain(), this.TYPE);
        }
    }

    public void m_6810_(BlockState state, Level worldIn, BlockPos pos, BlockState newState, boolean isMoving) {
        super.m_6810_(state, worldIn, pos, newState, isMoving);
    }

    public List<ItemStack> m_7381_(BlockState state, LootContext.Builder builder) {
        BlockEntity tileentity = (BlockEntity)builder.m_78982_(LootContextParams.f_81462_);
        if (tileentity instanceof TileEntityFakeBlock) {
            TileEntityFakeBlock fake = (TileEntityFakeBlock)tileentity;
            AntimatterPlatformUtils.getAllItems().parallelStream().filter(t -> t.m_8096_(fake.getState())).findFirst().ifPresent(item -> builder.m_78972_(LootContextParams.f_81463_, (Object)new ItemStack((ItemLike)item)));
            return fake.getState().m_60724_(builder);
        }
        return super.m_7381_(state, builder);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TileEntityFakeBlock(this, pos, state);
    }
}

