/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter.block;

import javax.annotation.Nullable;
import muramasa.antimatter.block.BlockBasic;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.registration.IColorHandler;
import muramasa.antimatter.texture.Texture;
import net.minecraft.core.BlockPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class BlockMaterialType
extends BlockBasic
implements IColorHandler {
    protected Material material;
    protected MaterialType<?> type;
    protected String textureFolder = "";

    public BlockMaterialType(String domain, Material material, MaterialType<?> type, BlockBehaviour.Properties properties) {
        super(domain, type.getId() + "_" + material.getId(), properties);
        this.material = material;
        this.type = type;
    }

    public BlockMaterialType instancedTextures(String folder) {
        this.textureFolder = folder;
        return this;
    }

    public Material getMaterial() {
        return this.material;
    }

    public MaterialType<?> getType() {
        return this.type;
    }

    @Override
    public int getBlockColor(BlockState state, @Nullable BlockGetter world, @Nullable BlockPos pos, int i) {
        return i == 0 ? this.material.getRGB() : -1;
    }

    @Override
    public int getItemColor(ItemStack stack, @Nullable Block block, int i) {
        return i == 0 ? this.material.getRGB() : -1;
    }

    @Override
    public Texture[] getTextures() {
        Texture[] textureArray;
        if (!this.textureFolder.isEmpty()) {
            Texture[] textureArray2 = new Texture[1];
            textureArray = textureArray2;
            textureArray2[0] = new Texture(this.domain, "block/" + this.textureFolder + "/" + this.material.getId());
        } else {
            textureArray = this.material.getSet().getTextures(this.type);
        }
        return textureArray;
    }
}

