/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter;

import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Map;
import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.datagen.AntimatterDynamics;
import muramasa.antimatter.registration.IAntimatterRegistrar;
import muramasa.antimatter.registration.Side;
import net.minecraft.data.DataGenerator;
import tesseract.TesseractPlatformUtils;

public abstract class AntimatterMod
implements IAntimatterRegistrar {
    private static final Map<String, DataEvent> DATA_EVENTS = new Object2ObjectOpenHashMap();

    public AntimatterMod() {
        if (TesseractPlatformUtils.isForge()) {
            this.onRegistrarInit();
        }
    }

    @Override
    public void onRegistrarInit() {
        DATA_EVENTS.put(this.getDomain(), this::onGatherData);
        AntimatterAPI.addRegistrar(this);
    }

    public void onGatherData(DataGenerator gen, String namespace, boolean includeClient, boolean includeServer) {
        if (includeClient) {
            AntimatterDynamics.onProviderInit(namespace, gen, Side.CLIENT);
        }
        if (includeServer) {
            AntimatterDynamics.onProviderInit(namespace, gen, Side.SERVER);
        }
    }

    public static void onGatherData(DataGenerator gen, boolean includeClient, boolean includeServer) {
        DATA_EVENTS.forEach((s, d) -> d.onGatherData(gen, (String)s, includeClient, includeServer));
    }

    @FunctionalInterface
    public static interface DataEvent {
        public void onGatherData(DataGenerator var1, String var2, boolean var3, boolean var4);
    }
}

