/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter;

import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class AntimatterConfig {
    public static final Client CLIENT = new Client();
    public static final Data DATA = new Data();
    public static final Gameplay GAMEPLAY = new Gameplay();
    public static final World WORLD = new World();
    public static final ModCompatibility MOD_COMPAT = new ModCompatibility();
    public static final ClientConfig CLIENT_CONFIG;
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final CommonConfig COMMON_CONFIG;
    public static final ForgeConfigSpec COMMON_SPEC;

    public static void onModConfigEvent(ModConfig e) {
        if (e.getModId().equals("antimatter")) {
            if (e.getSpec() == CLIENT_SPEC) {
                AntimatterConfig.bakeClientConfig();
            } else if (e.getSpec() == COMMON_SPEC) {
                AntimatterConfig.bakeCommonConfig();
            }
        }
    }

    private static void bakeClientConfig() {
        AntimatterConfig.CLIENT.BASIC_MACHINE_MODELS = (Boolean)AntimatterConfig.CLIENT_CONFIG.BASIC_MACHINE_MODELS.get();
        AntimatterConfig.CLIENT.SHOW_ALL_MATERIAL_ITEMS = (Boolean)AntimatterConfig.CLIENT_CONFIG.SHOW_ALL_MATERIAL_ITEMS.get();
        AntimatterConfig.CLIENT.SHOW_ALL_FLUID_CELLS = (Boolean)AntimatterConfig.CLIENT_CONFIG.SHOW_ALL_FLUID_CELLS.get();
        AntimatterConfig.CLIENT.ADD_REI_GROUPS = (Boolean)AntimatterConfig.CLIENT_CONFIG.ADD_REI_GROUPS.get();
        AntimatterConfig.CLIENT.GROUP_ORES_ONLY = (Boolean)AntimatterConfig.CLIENT_CONFIG.GROUP_ORES_ONLY.get();
        AntimatterConfig.CLIENT.SHOW_ALL_ORES = (Boolean)AntimatterConfig.CLIENT_CONFIG.SHOW_ALL_ORES.get();
        AntimatterConfig.CLIENT.SHOW_ROCKS = (Boolean)AntimatterConfig.CLIENT_CONFIG.SHOW_ROCKS.get();
    }

    private static void bakeCommonConfig() {
        AntimatterConfig.WORLD.VANILLA_ORE_GEN = (Boolean)AntimatterConfig.COMMON_CONFIG.VANILLA_ORE_GEN.get();
        AntimatterConfig.WORLD.VANILLA_STONE_GEN = (Boolean)AntimatterConfig.COMMON_CONFIG.VANILLA_STONE_GEN.get();
        AntimatterConfig.WORLD.SMALL_ORES = (Boolean)AntimatterConfig.COMMON_CONFIG.SMALL_ORES.get();
        AntimatterConfig.WORLD.SURFACE_ROCKS = (Boolean)AntimatterConfig.COMMON_CONFIG.SURFACE_ROCKS.get();
        AntimatterConfig.WORLD.REGENERATE_DEFAULT_WORLDGEN_JSONS = (Boolean)AntimatterConfig.COMMON_CONFIG.REGENERATE_DEFAULT_WORLDGEN_JSONS.get();
        AntimatterConfig.WORLD.ORE_VEINS = (Boolean)AntimatterConfig.COMMON_CONFIG.ORE_VEINS.get();
        AntimatterConfig.WORLD.ORE_VEIN_MAX_SIZE = (Integer)AntimatterConfig.COMMON_CONFIG.ORE_VEIN_MAX_SIZE.get();
        AntimatterConfig.WORLD.ORE_VEIN_CHANCE = (Integer)AntimatterConfig.COMMON_CONFIG.ORE_VEIN_CHANCE.get();
        AntimatterConfig.WORLD.ORE_VEIN_ROCK_CHANCE = (Integer)AntimatterConfig.COMMON_CONFIG.ORE_VEIN_ROCK_CHANCE.get();
        AntimatterConfig.WORLD.ORE_VEIN_FIND_ATTEMPTS = (Integer)AntimatterConfig.COMMON_CONFIG.ORE_VEIN_FIND_ATTEMPTS.get();
        AntimatterConfig.WORLD.ORE_VEIN_PLACE_ATTEMPTS = (Integer)AntimatterConfig.COMMON_CONFIG.ORE_VEIN_PLACE_ATTEMPTS.get();
        AntimatterConfig.WORLD.ORE_VEIN_SMALL_ORE_MARKERS = (Boolean)AntimatterConfig.COMMON_CONFIG.ORE_VEIN_SMALL_ORE_MARKERS.get();
        AntimatterConfig.WORLD.ORE_VEIN_SMALL_ORE_MARKERS_MULTI = (Integer)AntimatterConfig.COMMON_CONFIG.ORE_VEIN_SMALL_ORE_MARKERS_MULTI.get();
        AntimatterConfig.WORLD.STONE_LAYERS = (Boolean)AntimatterConfig.COMMON_CONFIG.STONE_LAYERS.get();
        AntimatterConfig.WORLD.STONE_LAYER_ORES = (Boolean)AntimatterConfig.COMMON_CONFIG.STONE_LAYER_ORES.get();
        AntimatterConfig.WORLD.STONE_LAYER_ROCK_CHANCE = (Integer)AntimatterConfig.COMMON_CONFIG.STONE_LAYER_ROCK_CHANCE.get();
        AntimatterConfig.WORLD.ORE_VEIN_SPECTATOR_DEBUG = (Boolean)AntimatterConfig.COMMON_CONFIG.ORE_VEIN_SPECTATOR_DEBUG.get();
        AntimatterConfig.GAMEPLAY.PIPE_LEAK = (Double)AntimatterConfig.COMMON_CONFIG.PIPE_LEAK.get();
        AntimatterConfig.GAMEPLAY.HARDCORE_CABLES = (Boolean)AntimatterConfig.COMMON_CONFIG.HARDCORE_CABLES.get();
        AntimatterConfig.GAMEPLAY.HARDCORE_PIPES = (Boolean)AntimatterConfig.COMMON_CONFIG.HARDCORE_PIPES.get();
        AntimatterConfig.GAMEPLAY.SMARTER_TREE_DETECTION = (Boolean)AntimatterConfig.COMMON_CONFIG.SMARTER_TREE_DETECTION.get();
        AntimatterConfig.GAMEPLAY.AXE_TIMBER = (Boolean)AntimatterConfig.COMMON_CONFIG.AXE_TIMBER.get();
        AntimatterConfig.GAMEPLAY.AXE_TIMBER_MAX = (Integer)AntimatterConfig.COMMON_CONFIG.AXE_TIMBER_MAX.get();
        AntimatterConfig.GAMEPLAY.LOSSY_PART_CRAFTING = (Boolean)AntimatterConfig.COMMON_CONFIG.LOSSY_PART_CRAFTING.get();
        AntimatterConfig.GAMEPLAY.PLAY_CRAFTING_SOUNDS = (Boolean)AntimatterConfig.COMMON_CONFIG.PLAY_CRAFTING_SOUNDS.get();
        AntimatterConfig.GAMEPLAY.MACHINES_EXPLODE = (Boolean)AntimatterConfig.COMMON_CONFIG.MACHINES_EXPLODE.get();
        AntimatterConfig.GAMEPLAY.EXPORT_DEFAULT_RECIPES = (Boolean)AntimatterConfig.COMMON_CONFIG.EXPORT_DEFAULT_RECIPES.get();
        AntimatterConfig.MOD_COMPAT.ENABLE_ALL_REGISTRARS = (Boolean)AntimatterConfig.COMMON_CONFIG.ENABLE_ALL_REGISTRARS.get();
    }

    static {
        Pair COMMON_PAIR = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        Pair CLIENT_PAIR = new ForgeConfigSpec.Builder().configure(ClientConfig::new);
        CLIENT_CONFIG = (ClientConfig)CLIENT_PAIR.getLeft();
        CLIENT_SPEC = (ForgeConfigSpec)CLIENT_PAIR.getRight();
        COMMON_CONFIG = (CommonConfig)COMMON_PAIR.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)COMMON_PAIR.getRight();
    }

    public static class Client {
        public boolean BASIC_MACHINE_MODELS;
        public boolean SHOW_ALL_MATERIAL_ITEMS;
        public boolean SHOW_ALL_FLUID_CELLS;
        public boolean ADD_REI_GROUPS;
        public boolean GROUP_ORES_ONLY;
        public boolean SHOW_ALL_ORES;
        public boolean SHOW_ROCKS;
    }

    public static class ClientConfig {
        public final ForgeConfigSpec.BooleanValue BASIC_MACHINE_MODELS;
        public final ForgeConfigSpec.BooleanValue SHOW_ALL_MATERIAL_ITEMS;
        public final ForgeConfigSpec.BooleanValue SHOW_ALL_FLUID_CELLS;
        public final ForgeConfigSpec.BooleanValue ADD_REI_GROUPS;
        public final ForgeConfigSpec.BooleanValue GROUP_ORES_ONLY;
        public final ForgeConfigSpec.BooleanValue SHOW_ALL_ORES;
        public final ForgeConfigSpec.BooleanValue SHOW_ROCKS;

        public ClientConfig(ForgeConfigSpec.Builder builder) {
            this.BASIC_MACHINE_MODELS = builder.comment("Enable flat machine related models (5U Style) - Default: false").translation("antimatter.config.basic_machine_models").define("BASIC_MACHINE_MODELS", false);
            this.SHOW_ALL_MATERIAL_ITEMS = builder.comment("Show all items in JEI, even ones that are unobtainable - Default: false").translation("antimatter.config.show_all_material_items").define("SHOW_ALL_MATERIAL_ITEMS", false);
            this.SHOW_ALL_FLUID_CELLS = builder.comment("Show all fluid cells in JEI - Default: false").translation("antimatter.config.show_all_fluid_cells").define("SHOW_ALL_FLUID_CELLS", false);
            this.ADD_REI_GROUPS = builder.comment("Add collapsable groups for various antimatter material items to rei - Default: false").translation("antimatter.config.add_rei_groups").define("ADD_REI_GROUPS", false);
            this.GROUP_ORES_ONLY = builder.comment("Only adds collapsable groups for ores and rocks, requires ADD_REI_GROUPS to be true - Default: true").translation("antimatter.config.group_ores_only").define("GROUP_ORES_ONLY", true);
            this.SHOW_ALL_ORES = builder.comment("Show all ore variants in jei/rei, not just stone variants - Default: false").translation("antimatter.config.show_all_ores").define("SHOW_ALL_ORES", false);
            this.SHOW_ROCKS = builder.comment("Show all block versions of rocks in jei/rei - Default: false").translation("antimatter.config.show_rocks").define("SHOW_ROCKS", false);
        }
    }

    public static class World {
        public boolean VANILLA_ORE_GEN;
        public boolean VANILLA_STONE_GEN;
        public boolean SMALL_ORES;
        public boolean SURFACE_ROCKS;
        public boolean ORE_VEINS;
        public boolean STONE_LAYERS;
        public boolean STONE_LAYER_ORES;
        public boolean ORE_VEIN_SMALL_ORE_MARKERS;
        public boolean ORE_VEIN_SPECTATOR_DEBUG;
        public boolean REGENERATE_DEFAULT_WORLDGEN_JSONS;
        public int ORE_VEIN_ROCK_CHANCE;
        public int STONE_LAYER_ROCK_CHANCE;
        public int ORE_VEIN_MAX_SIZE;
        public int ORE_VEIN_CHANCE;
        public int ORE_VEIN_FIND_ATTEMPTS;
        public int ORE_VEIN_PLACE_ATTEMPTS;
        public int ORE_VEIN_SMALL_ORE_MARKERS_MULTI;
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.DoubleValue PIPE_LEAK;
        public final ForgeConfigSpec.IntValue AXE_TIMBER_MAX;
        public final ForgeConfigSpec.IntValue ORE_VEIN_ROCK_CHANCE;
        public final ForgeConfigSpec.IntValue STONE_LAYER_ROCK_CHANCE;
        public final ForgeConfigSpec.IntValue ORE_VEIN_MAX_SIZE;
        public final ForgeConfigSpec.IntValue ORE_VEIN_CHANCE;
        public final ForgeConfigSpec.IntValue ORE_VEIN_FIND_ATTEMPTS;
        public final ForgeConfigSpec.IntValue ORE_VEIN_PLACE_ATTEMPTS;
        public final ForgeConfigSpec.IntValue ORE_VEIN_SMALL_ORE_MARKERS_MULTI;
        public final ForgeConfigSpec.BooleanValue ALL_MATERIAL_ITEMS;
        public final ForgeConfigSpec.BooleanValue VANILLA_ORE_GEN;
        public final ForgeConfigSpec.BooleanValue VANILLA_STONE_GEN;
        public final ForgeConfigSpec.BooleanValue SMALL_ORES;
        public final ForgeConfigSpec.BooleanValue SURFACE_ROCKS;
        public final ForgeConfigSpec.BooleanValue ORE_VEINS;
        public final ForgeConfigSpec.BooleanValue STONE_LAYERS;
        public final ForgeConfigSpec.BooleanValue STONE_LAYER_ORES;
        public final ForgeConfigSpec.BooleanValue ORE_VEIN_SMALL_ORE_MARKERS;
        public final ForgeConfigSpec.BooleanValue REGENERATE_DEFAULT_WORLDGEN_JSONS;
        public final ForgeConfigSpec.BooleanValue ORE_VEIN_SPECTATOR_DEBUG;
        public final ForgeConfigSpec.BooleanValue HARDCORE_CABLES;
        public final ForgeConfigSpec.BooleanValue INPUT_RESET_MULTIBLOCK;
        public final ForgeConfigSpec.BooleanValue HARDCORE_PIPES;
        public final ForgeConfigSpec.BooleanValue LOSSY_PART_CRAFTING;
        public final ForgeConfigSpec.BooleanValue MACHINES_EXPLODE;
        public final ForgeConfigSpec.BooleanValue AXE_TIMBER;
        public final ForgeConfigSpec.BooleanValue SMARTER_TREE_DETECTION;
        public final ForgeConfigSpec.BooleanValue EXPORT_DEFAULT_RECIPES;
        public final ForgeConfigSpec.BooleanValue PLAY_CRAFTING_SOUNDS;
        public final ForgeConfigSpec.BooleanValue ENABLE_ALL_REGISTRARS;

        public CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("Data");
            this.ALL_MATERIAL_ITEMS = builder.comment("Generate all the potential Material Items, even if they're unused - Default: false").translation("antimatter.config.all_material_items").define("ALL_MATERIAL_ITEMS", false);
            builder.pop();
            builder.push("World");
            this.VANILLA_ORE_GEN = builder.comment("Disable Vanilla ore generation (Iron Ore, Diamond Ore etc) - Default: true").translation("antimatter.config.vanilla_ore_gen").worldRestart().define("DISABLE_VANILLA_ORE_GEN", true);
            this.VANILLA_STONE_GEN = builder.comment("Disable vanilla stone generation (Granite, Diorite etc) - Default: true").translation("antimatter.config.vanilla_stone_gen").worldRestart().define("DISABLE_VANILLA_STONE_GEN", true);
            this.SMALL_ORES = builder.comment("Enable small ores - Default: true").translation("antimatter.config.small_ores").define("SMALL_ORES", true);
            this.SURFACE_ROCKS = builder.comment("Enable surface rocks - Default: true").translation("antimatter.config.surface_rocks").define("SURFACE_ROCKS", true);
            this.REGENERATE_DEFAULT_WORLDGEN_JSONS = builder.comment("Regenerates the default jsons for antimatter's ore generation systems. will self reset after generating configs - Default: false").translation("antimatter.config.regenerate_default_worldgen_jsons").define("REGENERATE_DEFAULT_WORLDGEN_JSONS", false);
            builder.push("Ore_Veins");
            this.ORE_VEINS = builder.comment("Enable ore veins - Default: true").translation("antimatter.config.ore_veins").define("ORE_VEINS", true);
            this.ORE_VEIN_MAX_SIZE = builder.comment("Maximum size of an ore vein - Default: 32").translation("antimatter.config.ore_vein_max_size").worldRestart().defineInRange("ORE_VEIN_MAX_SIZE", 32, 1, Integer.MAX_VALUE);
            this.ORE_VEIN_CHANCE = builder.comment("Control percentage of filled 3x3 chunks. Lower number means less ore veins would spawn - Default : 100").translation("antimatter.config.ore_vein_chance").worldRestart().defineInRange("ORE_VEIN_CHANCE", 100, 1, Integer.MAX_VALUE);
            this.ORE_VEIN_ROCK_CHANCE = builder.comment("Chance of ore veins having surface rocks. The lower the number, the higher the chance. - Default: 256").translation("antimatter.config.ore_vein_rock_chance").defineInRange("ORE_VEIN_ROCK_CHANCE", 16, 1, Integer.MAX_VALUE);
            this.ORE_VEIN_FIND_ATTEMPTS = builder.comment(new String[]{"Control number of attempts to find a valid ore vein,", "Generally this maximum limit isn't hit, as selecting a vein is performant - Default : 64"}).translation("antimatter.config.ore_vein_find_attempts").worldRestart().defineInRange("ORE_VEIN_FIND_ATTEMPTS", 64, 1, Integer.MAX_VALUE);
            this.ORE_VEIN_PLACE_ATTEMPTS = builder.comment(new String[]{"Control number of attempts to place a valid ore vein,", "If a vein wasn't placed due to height restrictions, completely in the water, or other criterion, another attempt is tried - Default : 8"}).translation("antimatter.config.ore_vein_place_attempts").worldRestart().defineInRange("ORE_VEIN_PLACE_ATTEMPTS", 8, 1, Integer.MAX_VALUE);
            this.ORE_VEIN_SMALL_ORE_MARKERS = builder.comment("Enable ore vein's having small ores as markers/indicators - Default: true").worldRestart().translation("antimatter.config.ore_vein_small_ore_markers").define("ORE_VEIN_SMALL_ORE_MARKERS", true);
            this.ORE_VEIN_SMALL_ORE_MARKERS_MULTI = builder.comment("Multiplier to control how many small ore markers get generated per vein - Default : 2").translation("antimatter.config.ore_vein_small_ore_markers_multi").worldRestart().defineInRange("ORE_VEIN_SMALL_ORE_MARKERS_MULTI", 2, 1, Integer.MAX_VALUE);
            builder.pop();
            builder.push("Stone_Layers");
            this.STONE_LAYERS = builder.comment("Enable stone layers - Default: true").translation("antimatter.config.stone_layers").define("STONE_LAYERS", true);
            this.STONE_LAYER_ORES = builder.comment("Enable stone layers having ores - Default: true").translation("antimatter.config.stone_layers_ores").define("STONE_LAYER_ORES", true);
            this.STONE_LAYER_ROCK_CHANCE = builder.comment("Chance of stone layers having surface rocks - Default: 128").translation("antimatter.config.stone_layer_rock_chance").defineInRange("STONE_LAYER_ROCK_CHANCE", 8, 1, Integer.MAX_VALUE);
            builder.pop();
            this.ORE_VEIN_SPECTATOR_DEBUG = builder.comment("Shows ore veins very clearly in spectator mode - Default: false").translation("antimatter.config.ore_vein_debug").define("ORE_VEIN_SPECTATOR_DEBUG", true);
            builder.pop();
            builder.push("Gameplay");
            this.INPUT_RESET_MULTIBLOCK = builder.comment("Whether or not to reconsume recipe inputs on multiblock failure - Default : false").translation("antimatter.config.input_reset").define("INPUT_RESET_MULTIBLOCK", false);
            this.PIPE_LEAK = builder.comment("Amount of gas retained passing through a leaky pipe - Default: 90%").translation("antimatter.config.pipe_leak").defineInRange("PIPE_LEAK", 0.9, 0.0, 1.0);
            this.HARDCORE_CABLES = builder.comment("Enable hardcore cable loss and voltage - Default: true").translation("antimatter.config.hardcore_cables").define("HARDCORE_CABLES", true);
            this.HARDCORE_PIPES = builder.comment("Enable pipe blowing on overpressure - Default: false").translation("antimatter.config.hardcore_pipes").define("HARDCORE_PIPES", false);
            this.LOSSY_PART_CRAFTING = builder.comment(new String[]{"Enable crating recipes for things like rods and plates being lossy - Default: true", "Note: make sure to run /reload after changing this."}).translation("antimatter.config.lossy_part_crafting").define("LOSSY_PART_CRAFTING", true);
            this.MACHINES_EXPLODE = builder.comment("Enable machines exploding on overvoltage - Default: true").translation("antimatter.config.machines_explode").define("MACHINES_EXPLODE", true);
            this.EXPORT_DEFAULT_RECIPES = builder.comment("Exports default crafting and machine recipes to exported in the root minecraft folder. - Default: false").translation("antimatter.config.export_default_recipes").define("EXPORT_DEFAULT_RECIPES", false);
            builder.push("Treefelling");
            this.SMARTER_TREE_DETECTION = builder.comment("Smart tree detection, instead of just going up in a column, it searches surrounding connected blocks too. Default: true").translation("antimatter.config.tree_detection").define("SMARTER_TREE_DETECTION", true);
            this.AXE_TIMBER = builder.comment("Allow Antimatter Axe types to fell trees - Default: true").translation("antimatter.config.axe_timber").define("AXE_TIMBER", true);
            this.AXE_TIMBER_MAX = builder.comment("Max height of a column of logs an Antimatter Axe type can fell - Default: 100").translation("antimatter.config.axe_timber_max").defineInRange("AXE_TIMBER_MAX", 100, 1, 2304);
            builder.pop();
            this.PLAY_CRAFTING_SOUNDS = builder.comment("Hear various crafting sounds when you craft with any of Antimatter's tools that has a custom SoundType. Default: true").translation("antimatter.config.play_crafting_sounds").define("PLAY_CRAFTING_SOUNDS", true);
            builder.pop();
            builder.push("Mod_Compatibility");
            this.ENABLE_ALL_REGISTRARS = builder.comment("Enable all mod support registrars - Default: true").translation("antimatter.config.enable_all_resgistrars").define("ENABLE_ALL_REGISTRARS", true);
            builder.pop();
        }
    }

    public static class Gameplay {
        public double PIPE_LEAK;
        public int AXE_TIMBER_MAX;
        public boolean HARDCORE_CABLES;
        public boolean HARDCORE_PIPES;
        public boolean AXE_TIMBER;
        public boolean SMARTER_TREE_DETECTION;
        public boolean PLAY_CRAFTING_SOUNDS;
        public boolean LOSSY_PART_CRAFTING;
        public boolean MACHINES_EXPLODE;
        public boolean EXPORT_DEFAULT_RECIPES;
    }

    public static class ModCompatibility {
        public boolean ENABLE_ALL_REGISTRARS;
    }

    public static class Data {
        public boolean ALL_MATERIAL_ITEMS;
        public boolean ITEM_REPLACEMENTS;
    }
}

