/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter;

import com.mojang.datafixers.util.Either;
import dev.architectury.injectables.annotations.ExpectPlatform;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.Arrays;
import java.util.Deque;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import muramasa.antimatter.Antimatter;
import muramasa.antimatter.AntimatterConfig;
import muramasa.antimatter.datagen.IAntimatterProvider;
import muramasa.antimatter.forge.AntimatterAPIImpl;
import muramasa.antimatter.gui.GuiData;
import muramasa.antimatter.integration.jeirei.AntimatterJEIREIPlugin;
import muramasa.antimatter.machine.Tier;
import muramasa.antimatter.machine.types.Machine;
import muramasa.antimatter.material.Material;
import muramasa.antimatter.material.MaterialType;
import muramasa.antimatter.ore.StoneType;
import muramasa.antimatter.recipe.map.IRecipeMap;
import muramasa.antimatter.registration.IAntimatterObject;
import muramasa.antimatter.registration.IAntimatterRegistrar;
import muramasa.antimatter.registration.IRegistryEntryProvider;
import muramasa.antimatter.registration.ISharedAntimatterObject;
import muramasa.antimatter.registration.RegistrationEvent;
import muramasa.antimatter.registration.Side;
import muramasa.antimatter.tile.TileEntityMachine;
import muramasa.antimatter.tile.pipe.TileEntityPipe;
import muramasa.antimatter.util.AntimatterPlatformUtils;
import muramasa.antimatter.util.AntimatterPreLaunchUtil;
import muramasa.antimatter.util.NonNullSupplier;
import muramasa.antimatter.util.TagUtils;
import muramasa.antimatter.util.Utils;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.util.TriConsumer;

public final class AntimatterAPI {
    private static final Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> OBJECTS = new Object2ObjectOpenHashMap();
    private static final EnumMap<RegistrationEvent, List<Runnable>> CALLBACKS = new EnumMap(RegistrationEvent.class);
    private static final EnumSet<RegistrationEvent> REGISTRATION_EVENTS_HANDLED = EnumSet.noneOf(RegistrationEvent.class);
    private static final ObjectList<IBlockUpdateEvent> BLOCK_UPDATE_HANDLERS = new ObjectArrayList();
    private static final Int2ObjectMap<Deque<Runnable>> DEFERRED_QUEUE = new Int2ObjectOpenHashMap();
    private static final Object2ObjectMap<ResourceLocation, Supplier<Object>> REPLACEMENTS = new Object2ObjectOpenHashMap();
    private static final Map<String, Map<String, Class<?>>> CLASS_LOOKUP = new Object2ObjectOpenHashMap();
    private static Side SIDE;
    private static RegistrationEvent PHASE;
    private static IAntimatterRegistrar INTERNAL_REGISTRAR;

    public static void init() {
    }

    private static void registerInternal(Class<?> c, String id, @Nullable String domain, Object o) {
        if (domain != null) {
            Object present = OBJECTS.computeIfAbsent(c, t -> new Object2ObjectLinkedOpenHashMap()).computeIfAbsent(domain, t -> Either.right((Object)new Object2ObjectLinkedOpenHashMap())).map(t -> null, t -> t.put(id, o));
            if (present != null) {
                throw new IllegalStateException(String.join((CharSequence)"", "Class ", c.getName(), "'s object: ", id, " has already been registered by: ", present.toString()));
            }
        } else {
            Map map = OBJECTS.computeIfAbsent(c, t -> new Object2ObjectLinkedOpenHashMap());
            Either present = map.put(id, Either.left((Object)((ISharedAntimatterObject)o)));
            if (present != null) {
                throw new IllegalStateException(String.join((CharSequence)"", "Class ", c.getName(), "'s object: ", id, " has already been registered by: ", present.toString()));
            }
        }
        String name = c.getSimpleName();
        CLASS_LOOKUP.computeIfAbsent(domain, k -> new Object2ObjectOpenHashMap()).putIfAbsent(name, c);
    }

    public static RegistrationEvent getPhase() {
        return PHASE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T register(Class<?> c, String id, String domain, Object o) {
        Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> map = OBJECTS;
        synchronized (map) {
            if (!AntimatterAPI.allowRegistration()) {
                throw new IllegalStateException("Registering after DataDone in AntimatterAPI - badbad!");
            }
            if (o instanceof IAntimatterObject && !((IAntimatterObject)o).shouldRegister()) {
                return (T)o;
            }
            if (o instanceof ISharedAntimatterObject && AntimatterAPI.getInternal(c, id) != null) {
                return (T)AntimatterAPI.getInternal(c, id);
            }
            AntimatterAPI.registerInternal(c, id, o instanceof ISharedAntimatterObject ? null : domain, o);
            if (o instanceof Block && AntimatterAPI.notRegistered(Block.class, id, domain)) {
                AntimatterAPI.registerInternal(Block.class, id, domain, o);
            } else if (o instanceof Item && AntimatterAPI.notRegistered(Item.class, id, domain)) {
                AntimatterAPI.registerInternal(Item.class, id, domain, o);
            } else if (o instanceof IRegistryEntryProvider) {
                String changedId;
                String string = o instanceof Material ? "material_" + id : (changedId = o instanceof StoneType ? "stone_" + id : id);
                if (AntimatterAPI.notRegistered(IRegistryEntryProvider.class, changedId, domain)) {
                    AntimatterAPI.registerInternal(IRegistryEntryProvider.class, changedId, domain, o);
                }
            }
            return (T)o;
        }
    }

    public static <T> T register(Class<T> c, IAntimatterObject o) {
        return AntimatterAPI.register(c, o.getId(), o.getDomain(), o);
    }

    private static boolean notRegistered(Class<?> c, String id, String domain) {
        return !AntimatterAPI.has(c, id, domain);
    }

    private static <T> T getInternal(Class<T> c, String id, String domain) {
        Either<ISharedAntimatterObject, Map<String, Object>> inner;
        Map<String, Either<ISharedAntimatterObject, Map<String, Object>>> map = OBJECTS.get(c);
        if (map != null && (inner = map.get(domain)) != null) {
            return (T)inner.map(t -> null, t -> {
                Object o = t.get(id);
                return o == null ? null : c.cast(o);
            });
        }
        return null;
    }

    @Nullable
    public static <T> T get(Class<T> c, String id, String domain) {
        T obj = AntimatterAPI.getInternal(c, id, domain);
        if (obj == null) {
            Class<T> clazz = c;
            if (domain.equals("antimatter_shared")) {
                T o = AntimatterAPI.get(clazz, id);
                return o == null ? null : (T)c.cast(o);
            }
        }
        return obj;
    }

    static boolean allowRegistration() {
        return PHASE == RegistrationEvent.DATA_INIT || PHASE == RegistrationEvent.CLIENT_DATA_INIT || PHASE == RegistrationEvent.WORLDGEN_INIT;
    }

    private static <T extends ISharedAntimatterObject> T getInternal(Class<? extends T> c, String id) {
        Map<String, Either<ISharedAntimatterObject, Map<String, Object>>> map = OBJECTS.get(c);
        if (map == null) {
            return null;
        }
        Either<ISharedAntimatterObject, Map<String, Object>> obj = map.get(id);
        return (T)(obj == null ? null : (ISharedAntimatterObject)c.cast(obj.map(t -> t, t -> null)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T extends ISharedAntimatterObject> T get(Class<? extends T> c, String id) {
        if (!AntimatterAPI.allowRegistration()) {
            Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                return AntimatterAPI.getInternal(c, id);
            }
        }
        return AntimatterAPI.getInternal(c, id);
    }

    @Nonnull
    public static <T> T getOrDefault(Class<T> c, String id, String domain, NonNullSupplier<? extends T> supplier) {
        T obj = AntimatterAPI.get(c, id, domain);
        return obj != null ? c.cast(obj) : supplier.get();
    }

    @Nonnull
    public static <T> T getOrThrow(Class<T> c, String id, String domain, Supplier<? extends RuntimeException> supplier) {
        T obj = AntimatterAPI.get(c, id, domain);
        if (obj != null) {
            return c.cast(obj);
        }
        throw supplier.get();
    }

    @Nonnull
    public static <T extends ISharedAntimatterObject> T getOrThrow(Class<T> c, String id, Supplier<? extends RuntimeException> supplier) {
        T obj = AntimatterAPI.get(c, id);
        if (obj != null) {
            return (T)((ISharedAntimatterObject)c.cast(obj));
        }
        throw supplier.get();
    }

    public static <T> boolean has(Class<T> c, String id, String domain) {
        Map<String, Either<ISharedAntimatterObject, Map<String, Object>>> map = OBJECTS.get(c);
        if (map != null) {
            Either<ISharedAntimatterObject, Map<String, Object>> either = map.get(domain);
            if (either == null) {
                return false;
            }
            return (Boolean)either.map(t -> true, t -> t.containsKey(id));
        }
        return false;
    }

    public static <T> boolean has(Class<T> c, String id) {
        Map<String, Either<ISharedAntimatterObject, Map<String, Object>>> map = OBJECTS.get(c);
        if (map != null) {
            Either<ISharedAntimatterObject, Map<String, Object>> inner = map.get(id);
            return inner != null && inner.left().isPresent();
        }
        return false;
    }

    @Nullable
    public static <T> T get(String className, String domain, String id) {
        Map<String, Class<?>> map = CLASS_LOOKUP.get(domain);
        if (map == null) {
            return null;
        }
        Class<?> clazz = map.get(className);
        if (clazz == null) {
            return null;
        }
        return (T)AntimatterAPI.get(clazz, id, domain);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(String className, String domain, Consumer<T> consumer) {
        Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> map = OBJECTS;
        synchronized (map) {
            Map<String, Class<?>> map2 = CLASS_LOOKUP.get(domain);
            if (map2 == null) {
                return;
            }
            Class<?> clazz = map2.get(className);
            if (clazz == null) {
                return;
            }
            if (domain == null) {
                AntimatterAPI.allInternal(clazz).forEach(consumer);
            } else {
                AntimatterAPI.allInternal(clazz, domain).forEach(consumer);
            }
        }
    }

    @Nullable
    public static <T> T get(String className, String id) {
        return AntimatterAPI.get(className, "antimatter_shared", id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> all(Class<T> c) {
        if (!AntimatterAPI.allowRegistration()) {
            List list;
            Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                list = AntimatterAPI.allInternal(c).collect(Collectors.toList());
            }
            return list;
        }
        return AntimatterAPI.allInternal(c).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> List<T> all(Class<T> c, String domain) {
        if (!AntimatterAPI.allowRegistration()) {
            List list;
            Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                list = AntimatterAPI.allInternal(c, domain).collect(Collectors.toList());
            }
            return list;
        }
        return AntimatterAPI.allInternal(c, domain).collect(Collectors.toList());
    }

    private static <T> Stream<T> allInternal(Class<T> c) {
        Map<String, Either<ISharedAntimatterObject, Map<String, Object>>> map = OBJECTS.get(c);
        return map == null ? Stream.empty() : new Object2ObjectArrayMap(map).values().stream().flatMap(t -> (Stream)t.map(Stream::of, right -> right.values().stream())).map(c::cast);
    }

    private static <T> Stream<T> allInternal(Class<T> c, @Nonnull String domain) {
        return AntimatterAPI.allInternal(c).filter(o -> o instanceof IAntimatterObject && ((IAntimatterObject)o).getDomain().equals(domain) || AntimatterAPI.isRegistryEntry(o, domain));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(Class<T> c, TriConsumer<T, String, String> consumer) {
        Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> map = OBJECTS;
        synchronized (map) {
            Map<String, Either<ISharedAntimatterObject, Map<String, Object>>> map2 = OBJECTS.get(c);
            if (map2 != null) {
                new Object2ObjectArrayMap(map2).forEach((d, e) -> {
                    if (e.left().isPresent()) {
                        e.left().ifPresent(o -> consumer.accept(c.cast(o), (Object)o.getDomain(), (Object)o.getId()));
                    } else {
                        e.right().ifPresent(m -> m.forEach((i, o) -> consumer.accept(c.cast(o), d, i)));
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(Class<T> c, String domain, TriConsumer<T, String, String> consumer) {
        Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> map = OBJECTS;
        synchronized (map) {
            Map<String, Either<ISharedAntimatterObject, Map<String, Object>>> map2 = OBJECTS.get(c);
            if (map2 != null) {
                new Object2ObjectArrayMap(map2).forEach((d, e) -> {
                    if (e.left().isPresent()) {
                        if (domain.equals("antimatter_shared")) {
                            e.left().ifPresent(o -> consumer.accept(c.cast(o), (Object)o.getDomain(), (Object)o.getId()));
                        }
                    } else {
                        e.right().ifPresent(m -> m.forEach((i, o) -> {
                            if (d.equals(domain)) {
                                consumer.accept(c.cast(o), d, i);
                            }
                        }));
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(Class<T> c, Consumer<T> consumer) {
        if (!AntimatterAPI.allowRegistration()) {
            Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                AntimatterAPI.allInternal(c).forEach(consumer);
            }
        } else {
            AntimatterAPI.allInternal(c).forEach(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(Class<T> c, String domain, Consumer<T> consumer) {
        if (AntimatterAPI.allowRegistration()) {
            Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                AntimatterAPI.allInternal(c, domain).forEach(consumer);
            }
        } else {
            AntimatterAPI.allInternal(c, domain).forEach(consumer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> void all(Class<T> c, String[] domains, Consumer<T> consumer) {
        if (AntimatterAPI.allowRegistration()) {
            Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                for (String domain : domains) {
                    AntimatterAPI.allInternal(c, domain).forEach(consumer);
                }
            }
        } else {
            for (String domain : domains) {
                AntimatterAPI.allInternal(c, domain).forEach(consumer);
            }
        }
    }

    private static void runProvider(IAntimatterProvider provider) {
        LogManager.getLogger().debug("Running " + provider.m_6055_());
        provider.run();
    }

    public static Optional<Deque<Runnable>> getCommonDeferredQueue() {
        return Optional.ofNullable((Deque)DEFERRED_QUEUE.get(0));
    }

    public static Optional<Deque<Runnable>> getClientDeferredQueue() {
        return Optional.ofNullable((Deque)DEFERRED_QUEUE.get(1));
    }

    public static Optional<Deque<Runnable>> getServerDeferredQueue() {
        return Optional.ofNullable((Deque)DEFERRED_QUEUE.get(2));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLaterCommon(Runnable ... r) {
        Int2ObjectMap<Deque<Runnable>> int2ObjectMap = DEFERRED_QUEUE;
        synchronized (int2ObjectMap) {
            ((Deque)DEFERRED_QUEUE.computeIfAbsent(0, q -> new LinkedList<Runnable>(Arrays.asList(r)))).addAll(Arrays.asList(r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLaterClient(Runnable ... r) {
        Int2ObjectMap<Deque<Runnable>> int2ObjectMap = DEFERRED_QUEUE;
        synchronized (int2ObjectMap) {
            ((Deque)DEFERRED_QUEUE.computeIfAbsent(1, q -> new LinkedList())).addAll(Arrays.asList(r));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void runLaterServer(Runnable ... r) {
        Int2ObjectMap<Deque<Runnable>> int2ObjectMap = DEFERRED_QUEUE;
        synchronized (int2ObjectMap) {
            ((Deque)DEFERRED_QUEUE.computeIfAbsent(2, q -> new LinkedList<Runnable>(Arrays.asList(r)))).addAll(Arrays.asList(r));
        }
    }

    public static void onRegistration(RegistrationEvent event) {
        RegistrationEvent previous = PHASE;
        PHASE = event;
        Antimatter.LOGGER.info("Registration event " + event);
        Side side = AntimatterAPI.getSIDE();
        if (!REGISTRATION_EVENTS_HANDLED.add(event)) {
            if (AntimatterPlatformUtils.isForge() && AntimatterPlatformUtils.getActiveNamespace().equals("antimatter")) {
                return;
            }
            throw new IllegalStateException("The RegistrationEvent " + event.name() + " has already been handled");
        }
        INTERNAL_REGISTRAR.onRegistrationEvent(event, side);
        List list = AntimatterAPI.all(IAntimatterRegistrar.class).stream().sorted((c1, c2) -> Integer.compare(c2.getPriority(), c1.getPriority())).toList();
        list.forEach(r -> r.onRegistrationEvent(event, side));
        if (CALLBACKS.containsKey((Object)event)) {
            CALLBACKS.get((Object)event).forEach(Runnable::run);
        }
        if (event == RegistrationEvent.CLIENT_DATA_INIT) {
            PHASE = previous;
        }
    }

    public static boolean isModLoaded(String mod) {
        return AntimatterPreLaunchUtil.isModLoaded(mod);
    }

    public static void runOnEvent(RegistrationEvent event, Runnable runnable) {
        CALLBACKS.computeIfAbsent(event, k -> new ObjectArrayList()).add(runnable);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addRegistrar(IAntimatterRegistrar registrar) {
        if (INTERNAL_REGISTRAR == null && registrar instanceof Antimatter) {
            INTERNAL_REGISTRAR = registrar;
        } else if (registrar.isEnabled() || AntimatterConfig.MOD_COMPAT.ENABLE_ALL_REGISTRARS) {
            Map<Class<?>, Map<String, Either<ISharedAntimatterObject, Map<String, Object>>>> map = OBJECTS;
            synchronized (map) {
                AntimatterAPI.registerInternal(IAntimatterRegistrar.class, registrar.getId(), registrar.getDomain(), registrar);
            }
        }
        AntimatterAPI.registerEventBus();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    private static void registerEventBus() {
        AntimatterAPIImpl.registerEventBus();
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static boolean isRegistryEntry(Object object, String domain) {
        void var1_1;
        return AntimatterAPIImpl.isRegistryEntry(object, (String)var1_1);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerTransferApi(BlockEntityType<? extends TileEntityMachine<?>> type) {
        AntimatterAPIImpl.registerTransferApi(type);
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void registerTransferApiPipe(BlockEntityType<? extends TileEntityPipe<?>> type) {
        AntimatterAPIImpl.registerTransferApiPipe(type);
    }

    public static Optional<IAntimatterRegistrar> getRegistrar(String id) {
        return AntimatterAPI.allInternal(IAntimatterRegistrar.class).filter(t -> t.getId().equals(id)).findFirst();
    }

    public static boolean isRegistrarEnabled(String id) {
        return AntimatterAPI.getRegistrar(id).map(IAntimatterRegistrar::isEnabled).orElse(false);
    }

    public static void registerJEICategory(IRecipeMap map, GuiData gui, Tier tier, ResourceLocation model, boolean override) {
        if (AntimatterAPI.isModLoaded("jei") || AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            AntimatterJEIREIPlugin.registerCategory(map, gui, tier, model, override);
        }
    }

    public static void registerJEICategory(IRecipeMap map, GuiData gui, Machine<?> machine, boolean override) {
        if (AntimatterAPI.isModLoaded("jei") || AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            AntimatterJEIREIPlugin.registerCategory(map, gui, machine.getFirstTier(), new ResourceLocation(machine.getDomain(), machine.getId()), override);
        }
    }

    public static void registerJEICategoryModel(IRecipeMap map, Machine<?> machine) {
        if (AntimatterAPI.isModLoaded("jei") || AntimatterAPI.isModLoaded("roughlyenoughitems")) {
            AntimatterJEIREIPlugin.registerCategoryModel(map, new ResourceLocation(machine.getDomain(), machine.getId()), machine.getFirstTier());
        }
    }

    public static void registerJEICategory(IRecipeMap map, GuiData gui) {
        AntimatterAPI.registerJEICategory(map, gui, Tier.LV, null, true);
    }

    public static Item getReplacement(MaterialType<?> type, Material material, String ... namespaces) {
        if (type.getId().contains("liquid")) {
            return null;
        }
        TagKey<Item> tag = type.getMaterialTag(material);
        return AntimatterAPI.getReplacement(null, tag, namespaces);
    }

    public static Item getReplacement(MaterialType<?> type, Material material, StoneType stone, String ... namespaces) {
        if (type.getId().contains("liquid")) {
            return null;
        }
        TagKey<Item> tag = TagUtils.getForgelikeItemTag(String.join((CharSequence)"", stone.getId(), "_", Utils.getConventionalMaterialType(type), "/", material.getId()));
        return AntimatterAPI.getReplacement(null, tag, namespaces);
    }

    public static <T> T getReplacement(@Nullable T originalItem, TagKey<T> tag, String ... namespaces) {
        if (tag == null) {
            throw new IllegalArgumentException("AntimatterAPI#getReplacement received a null tag!");
        }
        if (REPLACEMENTS.containsKey((Object)tag.f_203868_())) {
            return ((Supplier)REPLACEMENTS.get((Object)tag.f_203868_())).get();
        }
        return originalItem;
    }

    public static <T> void addReplacement(ResourceLocation tag, Supplier<T> obj) {
        REPLACEMENTS.put((Object)tag, obj::get);
    }

    public static <T> void addReplacement(TagKey<Item> tag, Supplier<T> obj) {
        REPLACEMENTS.put((Object)tag.f_203868_(), obj::get);
    }

    public static void registerBlockUpdateHandler(IBlockUpdateEvent handler) {
        BLOCK_UPDATE_HANDLERS.add((Object)handler);
    }

    public static void onNotifyBlockUpdate(Level world, BlockPos pos, BlockState oldState, BlockState newState, int flags) {
        BLOCK_UPDATE_HANDLERS.forEach(h -> h.onNotifyBlockUpdate(world, pos, oldState, newState, flags));
    }

    public static Side getSIDE() {
        return SIDE;
    }

    public static void setSIDE(Side SIDE) {
        AntimatterAPI.SIDE = SIDE;
    }

    static {
        PHASE = null;
    }

    public static interface IBlockUpdateEvent {
        public void onNotifyBlockUpdate(Level var1, BlockPos var2, BlockState var3, BlockState var4, int var5);
    }
}

