/*
 * Decompiled with CFR 0.152.
 */
package muramasa.antimatter;

import muramasa.antimatter.AntimatterAPI;
import muramasa.antimatter.AntimatterMod;
import muramasa.antimatter.Data;
import muramasa.antimatter.client.AntimatterModelManager;
import muramasa.antimatter.client.ClientData;
import muramasa.antimatter.cover.ICover;
import muramasa.antimatter.data.AntimatterDefaultTools;
import muramasa.antimatter.data.AntimatterMaterialTypes;
import muramasa.antimatter.data.AntimatterMaterials;
import muramasa.antimatter.data.AntimatterStoneTypes;
import muramasa.antimatter.datagen.AntimatterDynamics;
import muramasa.antimatter.datagen.loaders.MaterialRecipes;
import muramasa.antimatter.datagen.loaders.Pipes;
import muramasa.antimatter.datagen.loaders.StoneRecipes;
import muramasa.antimatter.datagen.loaders.Tools;
import muramasa.antimatter.datagen.providers.AntimatterBlockLootProvider;
import muramasa.antimatter.datagen.providers.AntimatterBlockStateProvider;
import muramasa.antimatter.datagen.providers.AntimatterBlockTagProvider;
import muramasa.antimatter.datagen.providers.AntimatterFluidTagProvider;
import muramasa.antimatter.datagen.providers.AntimatterItemModelProvider;
import muramasa.antimatter.datagen.providers.AntimatterItemTagProvider;
import muramasa.antimatter.datagen.providers.AntimatterLanguageProvider;
import muramasa.antimatter.datagen.providers.AntimatterTagProvider;
import muramasa.antimatter.event.CraftingEvent;
import muramasa.antimatter.event.ProvidersEvent;
import muramasa.antimatter.gui.SlotType;
import muramasa.antimatter.gui.event.GuiEvents;
import muramasa.antimatter.integration.kubejs.KubeJSRegistrar;
import muramasa.antimatter.item.interaction.CauldronInteractions;
import muramasa.antimatter.machine.MachineState;
import muramasa.antimatter.material.SubTag;
import muramasa.antimatter.network.AntimatterNetwork;
import muramasa.antimatter.proxy.ClientHandler;
import muramasa.antimatter.proxy.IProxyHandler;
import muramasa.antimatter.proxy.ServerHandler;
import muramasa.antimatter.recipe.Recipe;
import muramasa.antimatter.recipe.RecipeBuilders;
import muramasa.antimatter.recipe.container.ContainerItemShapedRecipe;
import muramasa.antimatter.recipe.container.ContainerItemShapelessRecipe;
import muramasa.antimatter.recipe.ingredient.IngredientSerializer;
import muramasa.antimatter.recipe.ingredient.PropertyIngredient;
import muramasa.antimatter.recipe.material.MaterialSerializer;
import muramasa.antimatter.recipe.serializer.AntimatterRecipeSerializer;
import muramasa.antimatter.registration.RegistrationEvent;
import muramasa.antimatter.registration.Side;
import muramasa.antimatter.util.TagUtils;
import muramasa.antimatter.util.Utils;
import muramasa.antimatter.worldgen.AntimatterWorldGenerator;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.biome.Biomes;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Antimatter
extends AntimatterMod {
    public static Antimatter INSTANCE;
    public static final Logger LOGGER;
    public static IProxyHandler PROXY;

    @Override
    public void onRegistrarInit() {
        super.onRegistrarInit();
        LOGGER.info("Loading Antimatter");
        INSTANCE = this;
        PROXY = (IProxyHandler)Utils.unsafeRunForDist(() -> ClientHandler::new, () -> ServerHandler::new);
        if (AntimatterAPI.isModLoaded("kubejs")) {
            new KubeJSRegistrar();
        }
        AntimatterDynamics.clientProvider("antimatter", () -> new AntimatterBlockStateProvider("antimatter", "AntimatterAPI".concat(" BlockStates")));
        AntimatterDynamics.clientProvider("antimatter", () -> new AntimatterItemModelProvider("antimatter", "AntimatterAPI".concat(" Item Models")));
        AntimatterDynamics.clientProvider("antimatter_shared", () -> new AntimatterBlockStateProvider("antimatter_shared", "Antimatter Shared BlockStates"));
        AntimatterDynamics.clientProvider("antimatter_shared", () -> new AntimatterItemModelProvider("antimatter_shared", "Antimatter Shared Item Models"));
        AntimatterDynamics.clientProvider("antimatter", () -> new AntimatterLanguageProvider("antimatter", "AntimatterAPI".concat(" en_us Localization"), "en_us"));
        AntimatterDynamics.clientProvider("antimatter_shared", () -> new AntimatterLanguageProvider("antimatter_shared", "AntimatterAPI".concat(" en_us Localization (Shared)"), "en_us"));
        AntimatterAPI.init();
        AntimatterNetwork.register();
    }

    public void addCraftingLoaders(CraftingEvent ev) {
        ev.addLoader(StoneRecipes::loadRecipes);
        ev.addLoader(MaterialRecipes::init);
        ev.addLoader(Pipes::loadRecipes);
        ev.addLoader(Tools::init);
    }

    public void providers(ProvidersEvent ev) {
        AntimatterBlockTagProvider[] p = new AntimatterBlockTagProvider[1];
        ev.addProvider("antimatter", () -> {
            p[0] = new AntimatterBlockTagProvider("antimatter", "AntimatterAPI".concat(" Block Tags"), false);
            return p[0];
        });
        ev.addProvider("antimatter_shared", () -> new AntimatterFluidTagProvider("antimatter_shared", "Antimatter Shared Fluid Tags", false));
        ev.addProvider("antimatter", () -> new AntimatterItemTagProvider("antimatter", "AntimatterAPI".concat(" Item Tags"), false, p[0]));
        ev.addProvider("antimatter", () -> new AntimatterBlockLootProvider("antimatter", "AntimatterAPI".concat(" Loot generator")));
        ev.addProvider("antimatter", () -> new AntimatterTagProvider<Biome>(BuiltinRegistries.f_123865_, "antimatter", "AntimatterAPI".concat(" Biome Tags"), "worldgen/biome"){

            @Override
            protected void processTags(String domain) {
                this.tag(TagUtils.getBiomeTag(new ResourceLocation("is_desert"))).m_211101_(new ResourceKey[]{Biomes.f_48203_});
                this.tag(TagUtils.getBiomeTag(new ResourceLocation("is_plains"))).m_211101_(new ResourceKey[]{Biomes.f_48202_});
                this.tag(TagUtils.getBiomeTag(new ResourceLocation("is_savanna"))).m_211101_(new ResourceKey[]{Biomes.f_48157_, Biomes.f_48158_, Biomes.f_186768_});
                this.tag(TagUtils.getBiomeTag(new ResourceLocation("is_swamp"))).m_211101_(new ResourceKey[]{Biomes.f_48207_});
            }
        });
    }

    @Override
    public void onRegistrationEvent(RegistrationEvent event, Side side) {
        if (event == RegistrationEvent.DATA_INIT) {
            Recipe.init();
            SlotType.init();
            RecipeBuilders.init();
            MachineState.init();
            AntimatterDefaultTools.init(side);
            AntimatterMaterials.init();
            AntimatterMaterialTypes.init();
            AntimatterStoneTypes.init();
            Data.init(side);
            ICover.init();
            SubTag.init();
            AntimatterWorldGenerator.preinit();
            GuiEvents.init();
            MaterialSerializer.init();
            ContainerItemShapedRecipe.init();
            ContainerItemShapelessRecipe.init();
            AntimatterRecipeSerializer.init();
            IngredientSerializer.init();
            PropertyIngredient.Serializer.init();
        } else if (event == RegistrationEvent.WORLDGEN_INIT) {
            AntimatterWorldGenerator.init();
        } else if (event == RegistrationEvent.DATA_READY) {
            CauldronInteractions.init();
        } else if (event == RegistrationEvent.CLIENT_DATA_INIT) {
            AntimatterModelManager.init();
            ClientData.init();
        }
    }

    @Override
    public String getId() {
        return "antimatter";
    }

    static {
        LOGGER = LogManager.getLogger((String)"antimatter");
    }
}

