/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.util;

import com.google.gson.JsonObject;
import com.sintinium.oauth.util.AgnosticUtils;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.util.EntityUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class YggdrasilUtil {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String joinUrl = "https://sessionserver.mojang.com/session/minecraft/join";
    private static final RequestConfig config = RequestConfig.custom().setConnectTimeout(30000).setSocketTimeout(30000).setConnectionRequestTimeout(30000).build();
    private static CloseableHttpClient client;

    private static void openClient() {
        SSLContext sslContext = null;
        try {
            KeyStore keyStore = KeyStore.getInstance("JKS");
            try (InputStream stream = Thread.currentThread().getContextClassLoader().getResourceAsStream("cacerts");){
                keyStore.load(stream, "changeit".toCharArray());
            }
            sslContext = SSLContext.getInstance("TLS");
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(KeyManagerFactory.getDefaultAlgorithm());
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
            keyManagerFactory.init(keyStore, "changeit".toCharArray());
            trustManagerFactory.init(keyStore);
            sslContext.init(keyManagerFactory.getKeyManagers(), trustManagerFactory.getTrustManagers(), null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        client = HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)new SSLConnectionSocketFactory(sslContext)).setDefaultRequestConfig(config).build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean joinServer(String token, String uuid, String hash) {
        try {
            YggdrasilUtil.openClient();
            HttpPost post = new HttpPost(joinUrl);
            JsonObject obj = new JsonObject();
            obj.addProperty("accessToken", token);
            obj.addProperty("selectedProfile", uuid);
            obj.addProperty("serverId", hash);
            StringEntity requestEntity = new StringEntity(obj.toString(), ContentType.APPLICATION_JSON);
            post.setEntity((HttpEntity)requestEntity);
            CloseableHttpResponse response = client.execute((HttpUriRequest)post);
            if (response != null) {
                boolean bl = false;
                return bl;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            boolean bl = false;
            return bl;
        }
        finally {
            try {
                client.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return true;
    }

    private static JsonObject parseObject(HttpResponse entity) throws IOException {
        String responseString = EntityUtils.toString((HttpEntity)entity.getEntity());
        if (entity.getStatusLine().getStatusCode() < 200 || entity.getStatusLine().getStatusCode() >= 300) {
            LOGGER.error("Received error code: " + entity.getStatusLine().getStatusCode());
            LOGGER.error("Response: " + responseString);
        }
        return AgnosticUtils.parseJson(responseString).getAsJsonObject();
    }
}

