/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.client;

import java.lang.reflect.Field;
import java.util.Map;
import java.util.Objects;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.gui.screens.TitleScreen;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.DimensionSpecialEffects;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.level.block.entity.BannerPattern;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.EntityRenderersEvent;
import net.minecraftforge.client.event.ScreenEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import twilightforest.TFConfig;
import twilightforest.TwilightForestMod;
import twilightforest.block.TFBlocks;
import twilightforest.block.entity.TFBlockEntities;
import twilightforest.client.OptifineWarningScreen;
import twilightforest.client.RenderLayerRegistration;
import twilightforest.client.TFShaders;
import twilightforest.client.TwilightForestRenderInfo;
import twilightforest.client.renderer.entity.IceLayer;
import twilightforest.client.renderer.entity.ShieldLayer;
import twilightforest.compat.CuriosCompat;
import twilightforest.inventory.TFContainers;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD, modid="twilightforest")
public class TFClientSetup {
    public static boolean optifinePresent = false;
    private static Field field_EntityRenderersEvent$AddLayers_renderers;

    public static void init() {
        IEventBus busMod = FMLJavaModLoadingContext.get().getModEventBus();
        TFShaders.init(busMod);
    }

    @SubscribeEvent
    public static void clientSetup(FMLClientSetupEvent evt) {
        try {
            Class.forName("net.optifine.Config");
            optifinePresent = true;
        }
        catch (ClassNotFoundException e) {
            optifinePresent = false;
        }
        RenderLayerRegistration.init();
        TFBlockEntities.registerTileEntityRenders();
        TFContainers.renderScreens();
        TwilightForestRenderInfo renderInfo = new TwilightForestRenderInfo(128.0f, false, DimensionSpecialEffects.SkyType.NONE, false, false);
        DimensionSpecialEffects.f_108857_.put((Object)TwilightForestMod.prefix("renderer"), (Object)renderInfo);
        for (BannerPattern pattern : BannerPattern.values()) {
            if (!pattern.m_58572_().startsWith("twilightforest")) continue;
            Sheets.f_173376_.put(pattern, Sheets.m_173387_((BannerPattern)pattern));
            Sheets.f_173377_.put(pattern, Sheets.m_173389_((BannerPattern)pattern));
        }
        evt.enqueueWork(() -> {
            Sheets.addWoodType((WoodType)TFBlocks.TWILIGHT_OAK);
            Sheets.addWoodType((WoodType)TFBlocks.CANOPY);
            Sheets.addWoodType((WoodType)TFBlocks.MANGROVE);
            Sheets.addWoodType((WoodType)TFBlocks.DARKWOOD);
            Sheets.addWoodType((WoodType)TFBlocks.TIMEWOOD);
            Sheets.addWoodType((WoodType)TFBlocks.TRANSFORMATION);
            Sheets.addWoodType((WoodType)TFBlocks.MINING);
            Sheets.addWoodType((WoodType)TFBlocks.SORTING);
            if (ModList.get().isLoaded("curios")) {
                CuriosCompat.registerCurioRenderers();
            }
        });
    }

    @SubscribeEvent
    public static void attachRenderLayers(EntityRenderersEvent.AddLayers event) {
        if (field_EntityRenderersEvent$AddLayers_renderers == null) {
            try {
                field_EntityRenderersEvent$AddLayers_renderers = EntityRenderersEvent.AddLayers.class.getDeclaredField("renderers");
                field_EntityRenderersEvent$AddLayers_renderers.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                e.printStackTrace();
            }
        }
        if (field_EntityRenderersEvent$AddLayers_renderers != null) {
            event.getSkins().forEach(renderer -> {
                LivingEntityRenderer skin = event.getSkin(renderer);
                TFClientSetup.attachRenderLayers(Objects.requireNonNull(skin));
            });
            try {
                ((Map)field_EntityRenderersEvent$AddLayers_renderers.get(event)).values().stream().filter(LivingEntityRenderer.class::isInstance).map(LivingEntityRenderer.class::cast).forEach(TFClientSetup::attachRenderLayers);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }
    }

    private static <T extends LivingEntity, M extends EntityModel<T>> void attachRenderLayers(LivingEntityRenderer<T, M> renderer) {
        renderer.m_115326_(new ShieldLayer<T, M>(renderer));
        renderer.m_115326_(new IceLayer<T, M>(renderer));
    }

    @Mod.EventBusSubscriber(value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE, modid="twilightforest")
    public static class ForgeEvents {
        private static boolean optifineWarningShown = false;

        @SubscribeEvent
        public static void showOptifineWarning(ScreenEvent.InitScreenEvent.Post event) {
            if (optifinePresent && !optifineWarningShown && !((Boolean)TFConfig.CLIENT_CONFIG.disableOptifineNagScreen.get()).booleanValue() && event.getScreen() instanceof TitleScreen) {
                optifineWarningShown = true;
                Minecraft.m_91087_().m_91152_((Screen)new OptifineWarningScreen(event.getScreen()));
            }
        }
    }
}

