/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import twilightforest.TFSounds;
import twilightforest.block.TFBlocks;
import twilightforest.item.TFItems;
import twilightforest.util.TFStats;

public class TrollRootBlock
extends Block {
    protected static final VoxelShape AABB = Shapes.m_83064_((AABB)new AABB(0.1, 0.0, 0.1, 0.9, 1.0, 0.9));

    protected TrollRootBlock(BlockBehaviour.Properties props) {
        super(props);
    }

    public static boolean canPlaceRootBelow(LevelReader world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        return state.m_204336_(BlockTags.f_13061_) || block == TFBlocks.TROLLVIDR.get() || block == TFBlocks.TROLLBER.get() || block == TFBlocks.UNRIPE_TROLLBER.get();
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult result) {
        if (state.m_60734_() == TFBlocks.TROLLBER.get()) {
            level.m_7731_(pos, ((Block)TFBlocks.TROLLVIDR.get()).m_49966_(), 2);
            level.m_5594_(null, pos, TFSounds.PICKED_TORCHBERRIES, SoundSource.BLOCKS, 1.0f, 1.0f);
            ItemEntity torchberries = new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), new ItemStack((ItemLike)TFItems.TORCHBERRIES.get()));
            level.m_7967_((Entity)torchberries);
            if (player instanceof ServerPlayer) {
                player.m_36220_((ResourceLocation)TFStats.TORCHBERRIES_HARVESTED.get());
            }
            return InteractionResult.m_19078_((boolean)level.m_5776_());
        }
        return super.m_6227_(state, level, pos, player, hand, result);
    }

    @Deprecated
    public boolean m_7898_(BlockState state, LevelReader world, BlockPos pos) {
        return TrollRootBlock.canPlaceRootBelow(world, pos.m_7494_());
    }

    @Deprecated
    public VoxelShape m_5940_(BlockState state, BlockGetter worldIn, BlockPos pos, CollisionContext context) {
        return AABB;
    }

    @Deprecated
    public BlockState m_7417_(BlockState state, Direction dirToNeighbor, BlockState neighborState, LevelAccessor world, BlockPos pos, BlockPos neighborPos) {
        if (dirToNeighbor == Direction.UP) {
            return this.m_7898_(state, (LevelReader)world, pos) ? state : Blocks.f_50016_.m_49966_();
        }
        return state;
    }
}

