/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftblibrary.config.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.icon.Icons;
import dev.ftb.mods.ftblibrary.icon.MutableColor4I;
import dev.ftb.mods.ftblibrary.math.Bits;
import dev.ftb.mods.ftblibrary.ui.BaseScreen;
import dev.ftb.mods.ftblibrary.ui.Button;
import dev.ftb.mods.ftblibrary.ui.Panel;
import dev.ftb.mods.ftblibrary.ui.PanelScrollBar;
import dev.ftb.mods.ftblibrary.ui.SimpleButton;
import dev.ftb.mods.ftblibrary.ui.Theme;
import dev.ftb.mods.ftblibrary.ui.VerticalSpaceWidget;
import dev.ftb.mods.ftblibrary.ui.Widget;
import dev.ftb.mods.ftblibrary.ui.WidgetLayout;
import dev.ftb.mods.ftblibrary.ui.WidgetType;
import dev.ftb.mods.ftblibrary.ui.input.Key;
import dev.ftb.mods.ftblibrary.ui.input.MouseButton;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.network.chat.TextColor;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public class EditConfigScreen
extends BaseScreen {
    public static final Color4I COLOR_BACKGROUND = Color4I.rgba(-1724697805);
    public static Theme THEME = new Theme(){

        @Override
        public void drawScrollBarBackground(PoseStack matrixStack, int x, int y, int w, int h, WidgetType type) {
            Color4I.BLACK.withAlpha(70).draw(matrixStack, x, y, w, h);
        }

        @Override
        public void drawScrollBar(PoseStack matrixStack, int x, int y, int w, int h, WidgetType type, boolean vertical) {
            this.getContentColor(WidgetType.NORMAL).withAlpha(100).withBorder(Color4I.GRAY.withAlpha(100), false).draw(matrixStack, x, y, w, h);
        }
    };
    private final ConfigGroup group;
    private final Component title;
    private final List<Widget> configEntryButtons;
    private final Panel configPanel;
    private final Button buttonAccept;
    private final Button buttonCancel;
    private final Button buttonCollapseAll;
    private final Button buttonExpandAll;
    private final PanelScrollBar scroll;
    private int groupSize = 0;
    private boolean autoclose = false;
    private int dividerX;

    public EditConfigScreen(ConfigGroup g) {
        this.group = g;
        this.title = g.getName().m_6881_().m_130940_(ChatFormatting.BOLD);
        this.configEntryButtons = new ArrayList<Widget>();
        this.configPanel = new Panel(this){

            @Override
            public void addWidgets() {
                for (Widget w : EditConfigScreen.this.configEntryButtons) {
                    if (w instanceof ConfigEntryButton && ((ConfigEntryButton)w).group.collapsed) continue;
                    this.add(w);
                }
            }

            @Override
            public void alignWidgets() {
                for (Widget w : this.widgets) {
                    w.setWidth(this.width - 16);
                }
                EditConfigScreen.this.scroll.setMaxValue(this.align(WidgetLayout.VERTICAL));
            }
        };
        ArrayList<ConfigValue> list = new ArrayList<ConfigValue>();
        this.collectAllConfigValues(this.group, list);
        if (!list.isEmpty()) {
            list.sort(null);
            ConfigGroupButton group = null;
            for (ConfigValue value : list) {
                if (group == null || group.group != value.group) {
                    this.configEntryButtons.add(new VerticalSpaceWidget(this.configPanel, 4));
                    group = new ConfigGroupButton(this.configPanel, value.group);
                    this.configEntryButtons.add(group);
                    ++this.groupSize;
                }
                ConfigEntryButton btn = new ConfigEntryButton(this.configPanel, group, value);
                this.configEntryButtons.add(btn);
                this.dividerX = Math.max(this.dividerX, this.getTheme().getStringWidth((FormattedText)btn.keyText));
            }
            if (this.groupSize == 1) {
                this.configEntryButtons.remove(group);
            }
        }
        this.dividerX += 10;
        this.scroll = new PanelScrollBar(this, this.configPanel);
        this.buttonAccept = new SimpleButton(this, (Component)new TranslatableComponent("gui.accept"), Icons.ACCEPT, (widget, button) -> this.doAccept());
        this.buttonCancel = new SimpleButton(this, (Component)new TranslatableComponent("gui.cancel"), Icons.CANCEL, (widget, button) -> this.doCancel());
        this.buttonExpandAll = new SimpleButton(this, (Component)new TranslatableComponent("gui.expand_all"), Icons.ADD, (widget, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ConfigGroupButton)) continue;
                ((ConfigGroupButton)w).setCollapsed(false);
            }
            this.scroll.setValue(0.0);
            widget.getGui().refreshWidgets();
        });
        this.buttonCollapseAll = new SimpleButton(this, (Component)new TranslatableComponent("gui.collapse_all"), Icons.REMOVE, (widget, button) -> {
            for (Widget w : this.configEntryButtons) {
                if (!(w instanceof ConfigGroupButton)) continue;
                ((ConfigGroupButton)w).setCollapsed(true);
            }
            this.scroll.setValue(0.0);
            widget.getGui().refreshWidgets();
        });
    }

    private void collectAllConfigValues(ConfigGroup group, List<ConfigValue> list) {
        list.addAll(group.getValues());
        for (ConfigGroup group1 : group.getGroups()) {
            this.collectAllConfigValues(group1, list);
        }
    }

    @Override
    public boolean onInit() {
        return this.setFullscreen();
    }

    @Override
    public void addWidgets() {
        this.add(this.buttonAccept);
        this.add(this.buttonCancel);
        if (this.groupSize > 1) {
            this.add(this.buttonExpandAll);
            this.add(this.buttonCollapseAll);
        }
        this.add(this.configPanel);
        this.add(this.scroll);
    }

    @Override
    public void alignWidgets() {
        this.configPanel.setPosAndSize(0, 20, this.width, this.height - 20);
        this.configPanel.alignWidgets();
        this.scroll.setPosAndSize(this.width - 16, 20, 16, this.height - 20);
        this.buttonAccept.setPos(this.width - 18, 2);
        this.buttonCancel.setPos(this.width - 38, 2);
        if (this.groupSize > 1) {
            this.buttonExpandAll.setPos(this.width - 58, 2);
            this.buttonCollapseAll.setPos(this.width - 78, 2);
        }
    }

    public EditConfigScreen setAutoclose(boolean autoclose) {
        this.autoclose = autoclose;
        return this;
    }

    private void doAccept() {
        this.group.save(true);
        if (this.autoclose) {
            this.closeGui();
        }
    }

    private void doCancel() {
        this.group.save(false);
        if (this.autoclose) {
            this.closeGui();
        }
    }

    @Override
    public boolean onClosedByKey(Key key) {
        if (super.onClosedByKey(key)) {
            this.group.save(true);
            return true;
        }
        return false;
    }

    @Override
    public void drawBackground(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
        COLOR_BACKGROUND.draw(matrixStack, 0, 0, w, 20);
        theme.drawString(matrixStack, this.getTitle(), 6, 6, 2);
    }

    @Override
    public Component getTitle() {
        return this.title;
    }

    @Override
    public Theme getTheme() {
        return THEME;
    }

    public static class ConfigGroupButton
    extends Button {
        public final ConfigGroup group;
        public MutableComponent title;
        public MutableComponent info;
        public boolean collapsed = false;

        public ConfigGroupButton(Panel panel, ConfigGroup g) {
            super(panel);
            this.setHeight(12);
            this.group = g;
            if (this.group.parent != null) {
                ArrayList<ConfigGroup> groups = new ArrayList<ConfigGroup>();
                do {
                    groups.add(g);
                } while ((g = g.parent) != null);
                groups.remove(groups.size() - 1);
                this.title = new TextComponent("");
                for (int i = groups.size() - 1; i >= 0; --i) {
                    this.title.m_7220_(((ConfigGroup)groups.get(i)).getName());
                    if (i == 0) continue;
                    this.title.m_130946_(" > ");
                }
            } else {
                this.title = new TranslatableComponent("stat.generalButton");
            }
            this.title.m_130940_(ChatFormatting.YELLOW);
            String infoKey = this.group.getPath() + ".info";
            this.info = I18n.m_118936_((String)infoKey) ? new TranslatableComponent(infoKey) : null;
            this.setCollapsed(this.collapsed);
        }

        public void setCollapsed(boolean v) {
            this.collapsed = v;
            this.setTitle((Component)new TextComponent("").m_7220_((Component)new TextComponent(this.collapsed ? "[-] " : "[v] ").m_130940_(this.collapsed ? ChatFormatting.RED : ChatFormatting.GREEN)).m_7220_((Component)this.title));
        }

        @Override
        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            COLOR_BACKGROUND.draw(matrixStack, x, y, w, h);
            theme.drawString(matrixStack, this.getTitle(), x + 3, y + 2);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Color4I.GRAY.withAlpha(80).draw(matrixStack, 0, y, this.width, 1);
            Color4I.GRAY.withAlpha(80).draw(matrixStack, 0, y, 1, this.height);
            if (this.isMouseOver()) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (this.info != null) {
                list.add((Component)this.info);
            }
        }

        @Override
        public void onClicked(MouseButton button) {
            this.setCollapsed(!this.collapsed);
            this.getGui().refreshWidgets();
        }
    }

    private class ConfigEntryButton
    extends Button {
        public final ConfigGroupButton group;
        public final ConfigValue inst;
        public Component keyText;

        public ConfigEntryButton(Panel panel, ConfigGroupButton g, ConfigValue i) {
            super(panel);
            this.setHeight(12);
            this.group = g;
            this.inst = i;
            this.keyText = !this.inst.getCanEdit() ? new TextComponent(this.inst.getName()).m_130940_(ChatFormatting.GRAY) : new TextComponent(this.inst.getName());
        }

        @Override
        public void draw(PoseStack matrixStack, Theme theme, int x, int y, int w, int h) {
            boolean mouseOver;
            boolean bl = mouseOver = this.getMouseY() >= 20 && this.isMouseOver();
            if (mouseOver) {
                Color4I.WHITE.withAlpha(33).draw(matrixStack, x, y, w, h);
            }
            theme.drawString(matrixStack, this.keyText, 5, y + 2, Bits.setFlag(0, 2, mouseOver));
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            Component s = this.inst.getStringForGUI(this.inst.value);
            int slen = theme.getStringWidth((FormattedText)s);
            int maxLen = this.width - EditConfigScreen.this.dividerX - 10;
            if (slen > maxLen) {
                s = new TextComponent(theme.trimStringToWidth((FormattedText)s, maxLen).getString().trim() + "...");
                slen = maxLen + 2;
            }
            MutableColor4I textCol = this.inst.getColor(this.inst.value).mutable();
            textCol.setAlpha(255);
            if (mouseOver) {
                textCol.addBrightness(60);
                if (this.getMouseX() > x + w - slen - 9) {
                    Color4I.WHITE.withAlpha(33).draw(matrixStack, x + w - slen - 8, y, slen + 8, h);
                }
            }
            theme.drawString(matrixStack, s, EditConfigScreen.this.dividerX + 5, y + 2, textCol, 0);
            Color4I.GRAY.withAlpha(33).draw(matrixStack, EditConfigScreen.this.dividerX, y, 1, this.height);
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void onClicked(MouseButton button) {
            if (this.getMouseY() >= 20) {
                this.playClickSound();
                this.inst.onClicked(button, accepted -> this.run());
            }
        }

        @Override
        public void addMouseOverText(TooltipList list) {
            if (this.getMouseY() > 18) {
                list.add((Component)this.keyText.m_6881_().m_130940_(ChatFormatting.UNDERLINE));
                String tooltip = this.inst.getTooltip();
                if (!tooltip.isEmpty()) {
                    for (String s : tooltip.split("\n")) {
                        list.styledString(s, Style.f_131099_.m_131155_(Boolean.valueOf(true)).m_131148_(TextColor.m_131270_((ChatFormatting)ChatFormatting.GRAY)));
                    }
                }
                list.blankLine();
                this.inst.addInfo(list);
            }
        }
    }
}

