/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.hopper;

import com.abdelaziz.canary.api.inventory.CanaryDefaultedList;
import com.abdelaziz.canary.common.block.entity.inventory_change_tracking.InventoryChangeTracker;
import com.abdelaziz.canary.common.hopper.CanaryDoubleStackList;
import com.abdelaziz.canary.common.hopper.ComparatorUpdatePattern;
import com.abdelaziz.canary.common.hopper.HopperHelper;
import com.abdelaziz.canary.common.hopper.StorableItemStack;
import com.abdelaziz.canary.mixin.block.hopper.NonNullListAccessor;
import net.minecraft.core.NonNullList;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import org.jetbrains.annotations.NotNull;

public class CanaryStackList
extends NonNullList<ItemStack>
implements CanaryDefaultedList {
    final int maxCountPerStack;
    protected int cachedSignalStrength;
    private ComparatorUpdatePattern cachedComparatorUpdatePattern;
    private boolean signalStrengthOverride;
    private long modCount;
    private int occupiedSlots;
    private int fullSlots;
    CanaryDoubleStackList parent;
    InventoryChangeTracker inventoryModificationCallback;

    public CanaryStackList(NonNullList<ItemStack> original, int maxCountPerStack) {
        super(((NonNullListAccessor)original).getList(), (Object)ItemStack.f_41583_);
        this.maxCountPerStack = maxCountPerStack;
        this.cachedSignalStrength = -1;
        this.cachedComparatorUpdatePattern = null;
        this.modCount = 0L;
        this.signalStrengthOverride = false;
        this.occupiedSlots = 0;
        this.fullSlots = 0;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = (ItemStack)this.get(i);
            if (stack.m_41619_()) continue;
            ++this.occupiedSlots;
            if (stack.m_41741_() <= stack.m_41613_()) {
                ++this.fullSlots;
            }
            ((StorableItemStack)stack).registerToInventory(this, i);
        }
        this.inventoryModificationCallback = null;
    }

    public CanaryStackList(int maxCountPerStack) {
        super(null, (Object)ItemStack.f_41583_);
        this.maxCountPerStack = maxCountPerStack;
        this.cachedSignalStrength = -1;
        this.inventoryModificationCallback = null;
    }

    public long getModCount() {
        return this.modCount;
    }

    public void changedALot() {
        ItemStack stack;
        int i;
        this.changed();
        this.occupiedSlots = 0;
        this.fullSlots = 0;
        int size = this.size();
        for (i = 0; i < size; ++i) {
            stack = (ItemStack)this.get(i);
            if (stack.m_41619_()) continue;
            ++this.occupiedSlots;
            if (stack.m_41741_() <= stack.m_41613_()) {
                ++this.fullSlots;
            }
            ((StorableItemStack)stack).unregisterFromInventory(this);
        }
        for (i = 0; i < size; ++i) {
            stack = (ItemStack)this.get(i);
            if (stack.m_41619_()) continue;
            ((StorableItemStack)stack).registerToInventory(this, i);
        }
    }

    public void beforeSlotCountChange(int slot, int newCount) {
        ItemStack stack = (ItemStack)this.get(slot);
        int count = stack.m_41613_();
        if (newCount <= 0) {
            ((StorableItemStack)stack).unregisterFromInventory(this, slot);
        }
        int maxCount = stack.m_41741_();
        this.occupiedSlots -= newCount <= 0 ? 1 : 0;
        this.fullSlots += (newCount >= maxCount ? 1 : 0) - (count >= maxCount ? 1 : 0);
        this.changed();
    }

    public void changed() {
        this.cachedSignalStrength = -1;
        this.cachedComparatorUpdatePattern = null;
        ++this.modCount;
        InventoryChangeTracker inventoryModificationCallback = this.inventoryModificationCallback;
        if (inventoryModificationCallback != null) {
            this.inventoryModificationCallback = null;
            inventoryModificationCallback.emitContentModified();
        }
    }

    public ItemStack set(int index, ItemStack element) {
        ItemStack previous = (ItemStack)super.set(index, (Object)element);
        if (previous != element) {
            ((StorableItemStack)previous).unregisterFromInventory(this, index);
            if (!element.m_41619_()) {
                ((StorableItemStack)element).registerToInventory(this, index);
            }
            this.occupiedSlots += (previous.m_41619_() ? 1 : 0) - (element.m_41619_() ? 1 : 0);
            this.fullSlots += (element.m_41613_() >= element.m_41741_() ? 1 : 0) - (previous.m_41613_() >= previous.m_41741_() ? 1 : 0);
            this.changed();
        }
        return previous;
    }

    public void add(int slot, ItemStack element) {
        super.add(slot, (Object)element);
        if (!element.m_41619_()) {
            ((StorableItemStack)element).registerToInventory(this, this.indexOf(element));
        }
        this.changedALot();
    }

    public ItemStack remove(int index) {
        ItemStack previous = (ItemStack)super.remove(index);
        ((StorableItemStack)previous).unregisterFromInventory(this, index);
        this.changedALot();
        return previous;
    }

    public void clear() {
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            ItemStack stack = (ItemStack)this.get(i);
            if (stack.m_41619_()) continue;
            ((StorableItemStack)stack).unregisterFromInventory(this, i);
        }
        super.clear();
        this.changedALot();
    }

    public boolean hasSignalStrengthOverride() {
        return this.signalStrengthOverride;
    }

    public int getSignalStrength(Container inventory) {
        if (this.signalStrengthOverride) {
            return 0;
        }
        int signalStrength = this.cachedSignalStrength;
        if (signalStrength == -1) {
            this.cachedSignalStrength = this.calculateSignalStrength(inventory.m_6643_());
            return this.cachedSignalStrength;
        }
        return signalStrength;
    }

    int calculateSignalStrength(int inventorySize) {
        int i = 0;
        float f = 0.0f;
        inventorySize = Math.min(inventorySize, this.size());
        for (int j = 0; j < inventorySize; ++j) {
            ItemStack itemStack = (ItemStack)this.get(j);
            if (itemStack.m_41619_()) continue;
            f += (float)itemStack.m_41613_() / (float)Math.min(this.maxCountPerStack, itemStack.m_41741_());
            ++i;
        }
        return Mth.m_14143_((float)((f /= (float)inventorySize) * 14.0f)) + (i > 0 ? 1 : 0);
    }

    public void setReducedSignalStrengthOverride() {
        this.signalStrengthOverride = true;
    }

    public void clearSignalStrengthOverride() {
        this.signalStrengthOverride = false;
    }

    public void runComparatorUpdatePatternOnFailedExtract(CanaryStackList masterStackList, Container inventory) {
        if (inventory instanceof BlockEntity) {
            if (this.cachedComparatorUpdatePattern == null) {
                this.cachedComparatorUpdatePattern = HopperHelper.determineComparatorUpdatePattern(inventory, masterStackList);
            }
            this.cachedComparatorUpdatePattern.apply((BlockEntity)inventory, masterStackList);
        }
    }

    public boolean maybeSendsComparatorUpdatesOnFailedExtract() {
        return this.cachedComparatorUpdatePattern == null || this.cachedComparatorUpdatePattern != ComparatorUpdatePattern.NO_UPDATE;
    }

    public int getOccupiedSlots() {
        return this.occupiedSlots;
    }

    public int getFullSlots() {
        return this.fullSlots;
    }

    @Override
    public void changedInteractionConditions() {
        this.changed();
    }

    public void setInventoryModificationCallback(@NotNull InventoryChangeTracker inventoryModificationCallback) {
        if (this.inventoryModificationCallback != null && this.inventoryModificationCallback != inventoryModificationCallback) {
            this.inventoryModificationCallback.emitCallbackReplaced();
        }
        this.inventoryModificationCallback = inventoryModificationCallback;
    }

    public void removeInventoryModificationCallback(@NotNull InventoryChangeTracker inventoryModificationCallback) {
        if (this.inventoryModificationCallback != null && this.inventoryModificationCallback == inventoryModificationCallback) {
            this.inventoryModificationCallback = null;
        }
    }
}

