/*
 * Decompiled with CFR 0.152.
 */
package com.abdelaziz.canary.common.entity.movement_tracker;

import com.abdelaziz.canary.common.entity.movement_tracker.EntityMovementTrackerSection;
import com.abdelaziz.canary.common.entity.movement_tracker.MovementTrackerCache;
import com.abdelaziz.canary.common.entity.movement_tracker.MovementTrackerHelper;
import com.abdelaziz.canary.common.entity.movement_tracker.SectionedEntityMovementListener;
import com.abdelaziz.canary.common.util.tuples.WorldSectionBox;
import com.abdelaziz.canary.mixin.util.entity_movement_tracking.PersistentEntitySectionManagerAccessor;
import com.abdelaziz.canary.mixin.util.entity_movement_tracking.ServerLevelAccessor;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import net.minecraft.core.SectionPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.entity.EntityAccess;
import net.minecraft.world.level.entity.EntitySection;
import net.minecraft.world.level.entity.EntitySectionStorage;

public abstract class SectionedEntityMovementTracker<E extends EntityAccess, S> {
    final WorldSectionBox trackedWorldSections;
    final Class<S> clazz;
    private final int trackedClass;
    ArrayList<EntitySection<E>> sortedSections;
    boolean[] sectionVisible;
    private int timesRegistered;
    private final ArrayList<EntityMovementTrackerSection> sectionsNotListeningTo;
    private long maxChangeTime;
    private ReferenceOpenHashSet<SectionedEntityMovementListener> nearbyEntityMovementListeners;

    public SectionedEntityMovementTracker(WorldSectionBox interactionChunks, Class<S> clazz) {
        this.clazz = clazz;
        this.trackedWorldSections = interactionChunks;
        this.trackedClass = MovementTrackerHelper.MOVEMENT_NOTIFYING_ENTITY_CLASSES.indexOf(clazz);
        assert (this.trackedClass != -1);
        this.nearbyEntityMovementListeners = null;
        this.sectionsNotListeningTo = new ArrayList();
    }

    public int hashCode() {
        return HashCommon.mix((int)this.trackedWorldSections.hashCode()) ^ HashCommon.mix((int)this.trackedClass) ^ this.getClass().hashCode();
    }

    public boolean equals(Object obj) {
        return obj.getClass() == this.getClass() && this.clazz == ((SectionedEntityMovementTracker)obj).clazz && this.trackedWorldSections.equals(((SectionedEntityMovementTracker)obj).trackedWorldSections);
    }

    public boolean isUnchangedSince(long lastCheckedTime) {
        if (lastCheckedTime <= this.maxChangeTime) {
            return false;
        }
        if (!this.sectionsNotListeningTo.isEmpty()) {
            this.setChanged(this.listenToAllSectionsAndGetMaxChangeTime());
            return lastCheckedTime > this.maxChangeTime;
        }
        return true;
    }

    private long listenToAllSectionsAndGetMaxChangeTime() {
        long maxChangeTime = Long.MIN_VALUE;
        ArrayList<EntityMovementTrackerSection> notListeningTo = this.sectionsNotListeningTo;
        for (int i = notListeningTo.size() - 1; i >= 0; --i) {
            EntityMovementTrackerSection entityTrackerSection = notListeningTo.remove(i);
            entityTrackerSection.listenToMovementOnce(this, this.trackedClass);
            maxChangeTime = Math.max(maxChangeTime, entityTrackerSection.getChangeTime(this.trackedClass));
        }
        return maxChangeTime;
    }

    public void register(ServerLevel world) {
        assert (world == this.trackedWorldSections.world());
        if (this.timesRegistered == 0) {
            EntitySectionStorage cache = ((PersistentEntitySectionManagerAccessor)((ServerLevelAccessor)world).getEntityManager()).getSectionStorage();
            WorldSectionBox trackedSections = this.trackedWorldSections;
            int size = trackedSections.numSections();
            assert (size > 0);
            this.sortedSections = new ArrayList(size);
            this.sectionVisible = new boolean[size];
            for (int x = trackedSections.chunkX1(); x < trackedSections.chunkX2(); ++x) {
                for (int z = trackedSections.chunkZ1(); z < trackedSections.chunkZ2(); ++z) {
                    for (int y = trackedSections.chunkY1(); y < trackedSections.chunkY2(); ++y) {
                        EntitySection section = cache.m_156893_(SectionPos.m_123209_((int)x, (int)y, (int)z));
                        EntityMovementTrackerSection sectionAccess = (EntityMovementTrackerSection)section;
                        this.sortedSections.add(section);
                        sectionAccess.addListener(this);
                    }
                }
            }
            this.setChanged(world.m_46467_());
        }
        ++this.timesRegistered;
    }

    public void unRegister(ServerLevel world) {
        assert (world == this.trackedWorldSections.world());
        if (--this.timesRegistered > 0) {
            return;
        }
        assert (this.timesRegistered == 0);
        EntitySectionStorage cache = ((PersistentEntitySectionManagerAccessor)((ServerLevelAccessor)world).getEntityManager()).getSectionStorage();
        MovementTrackerCache storage = (MovementTrackerCache)cache;
        storage.remove(this);
        ArrayList<EntitySection<E>> sections = this.sortedSections;
        for (int i = sections.size() - 1; i >= 0; --i) {
            EntitySection<E> section = sections.get(i);
            EntityMovementTrackerSection sectionAccess = (EntityMovementTrackerSection)section;
            sectionAccess.removeListener(cache, this);
            if (this.sectionsNotListeningTo.remove(section)) continue;
            ((EntityMovementTrackerSection)section).removeListenToMovementOnce(this, this.trackedClass);
        }
        this.setChanged(world.m_46467_());
    }

    public void onSectionEnteredRange(EntityMovementTrackerSection section) {
        this.setChanged(this.trackedWorldSections.world().m_46467_());
        int sectionIndex = this.sortedSections.lastIndexOf(section);
        this.sectionVisible[sectionIndex] = true;
        this.sectionsNotListeningTo.add(section);
    }

    public void onSectionLeftRange(EntityMovementTrackerSection section) {
        this.setChanged(this.trackedWorldSections.world().m_46467_());
        int sectionIndex = this.sortedSections.lastIndexOf(section);
        this.sectionVisible[sectionIndex] = false;
        if (!this.sectionsNotListeningTo.remove(section)) {
            section.removeListenToMovementOnce(this, this.trackedClass);
        }
    }

    private void setChanged(long atTime) {
        if (atTime > this.maxChangeTime) {
            this.maxChangeTime = atTime;
        }
    }

    public void listenToEntityMovementOnce(SectionedEntityMovementListener listener) {
        if (this.nearbyEntityMovementListeners == null) {
            this.nearbyEntityMovementListeners = new ReferenceOpenHashSet();
        }
        this.nearbyEntityMovementListeners.add((Object)listener);
        if (!this.sectionsNotListeningTo.isEmpty()) {
            this.setChanged(this.listenToAllSectionsAndGetMaxChangeTime());
        }
    }

    public void emitEntityMovement(int classMask, EntityMovementTrackerSection section) {
        if ((classMask & 1 << this.trackedClass) != 0) {
            ReferenceOpenHashSet<SectionedEntityMovementListener> listeners = this.nearbyEntityMovementListeners;
            if (listeners != null) {
                for (SectionedEntityMovementListener listener : listeners) {
                    listener.handleEntityMovement(this.clazz);
                }
                listeners.clear();
            }
            this.sectionsNotListeningTo.add(section);
        }
    }
}

