/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.wct;

import appeng.api.features.Locatables;
import appeng.api.implementations.blockentities.IWirelessAccessPoint;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.upgrades.IUpgradeableItem;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.networking.WirelessBlockEntity;
import appeng.items.tools.powered.WirelessTerminalItem;
import appeng.menu.locator.MenuLocator;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.Platform;
import de.mari_023.ae2wtlib.wct.magnet_card.MagnetHost;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.HashMap;
import java.util.OptionalLong;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class CraftingTerminalHandler {
    private static final HashMap<UUID, CraftingTerminalHandler> players = new HashMap();
    private final Player player;
    private ItemStack craftingTerminal = ItemStack.f_41583_;
    private IActionHost securityStation;
    private IGrid targetGrid;
    private MenuLocator locator;
    private IWirelessAccessPoint myWap;
    private double sqRange = Double.MAX_VALUE;
    private HashMap<Item, Long> restockAbleItems = new HashMap();
    private MagnetHost magnetHost;

    private CraftingTerminalHandler(Player player) {
        this.player = player;
    }

    public static CraftingTerminalHandler getCraftingTerminalHandler(Player player) {
        if (players.containsKey(player.m_142081_())) {
            if (player == CraftingTerminalHandler.players.get((Object)player.m_142081_()).player || !(player instanceof ServerPlayer) && CraftingTerminalHandler.players.get((Object)player.m_142081_()).player instanceof ServerPlayer) {
                return players.get(player.m_142081_());
            }
            CraftingTerminalHandler.removePlayer(player);
        }
        CraftingTerminalHandler handler = new CraftingTerminalHandler(player);
        players.put(player.m_142081_(), handler);
        return handler;
    }

    public static void removePlayer(Player player) {
        players.remove(player.m_142081_());
    }

    public void invalidateCache() {
        this.craftingTerminal = ItemStack.f_41583_;
        this.locator = null;
        this.securityStation = null;
        this.targetGrid = null;
        this.myWap = null;
        this.sqRange = Double.MAX_VALUE;
        this.restockAbleItems.clear();
        this.magnetHost = null;
    }

    public ItemStack getCraftingTerminal() {
        Inventory inv = this.player.m_150109_();
        if (!this.craftingTerminal.m_41619_() && (inv.m_36063_(this.craftingTerminal) || Platform.trinketsPresent() && Platform.isStillPresentTrinkets(this.player, this.craftingTerminal))) {
            return this.craftingTerminal;
        }
        this.locator = WUTHandler.findTerminal(this.player, "crafting");
        this.craftingTerminal = this.locator == null ? ItemStack.f_41583_ : WUTHandler.getItemStackFromLocator(this.player, this.locator);
        if (this.craftingTerminal.m_41619_()) {
            this.invalidateCache();
        } else {
            this.securityStation = null;
            this.targetGrid = null;
        }
        return this.craftingTerminal;
    }

    @Nullable
    public MenuLocator getLocator() {
        if (this.getCraftingTerminal().m_41619_()) {
            return null;
        }
        return this.locator;
    }

    @Nullable
    public IActionHost getSecurityStation() {
        if (this.getCraftingTerminal().m_41619_()) {
            this.securityStation = null;
            return null;
        }
        if (this.securityStation != null) {
            return this.securityStation;
        }
        OptionalLong unParsedKey = ((WirelessTerminalItem)this.craftingTerminal.m_41720_()).getGridKey(this.craftingTerminal);
        if (unParsedKey.isEmpty()) {
            this.securityStation = null;
            return null;
        }
        long parsedKey = unParsedKey.getAsLong();
        this.securityStation = (IActionHost)Locatables.securityStations().get(this.player.f_19853_, parsedKey);
        return this.securityStation;
    }

    @Nullable
    public IGrid getTargetGrid() {
        if (this.getSecurityStation() == null) {
            this.targetGrid = null;
            return null;
        }
        IGridNode n = this.securityStation.getActionableNode();
        if (n == null) {
            this.targetGrid = null;
            return null;
        }
        this.targetGrid = n.getGrid();
        return this.targetGrid;
    }

    public boolean inRange() {
        ItemStack is = this.getCraftingTerminal();
        if (is.m_41619_()) {
            return false;
        }
        if (((IUpgradeableItem)is.m_41720_()).getUpgrades(is).isInstalled((ItemLike)AE2wtlib.INFINITY_BOOSTER)) {
            return true;
        }
        this.sqRange = Double.MAX_VALUE;
        if (this.getTargetGrid() == null) {
            return false;
        }
        if (this.myWap != null && this.myWap.getGrid() == this.targetGrid && this.testWap(this.myWap)) {
            return true;
        }
        Set tw = this.targetGrid.getMachines(WirelessBlockEntity.class);
        this.myWap = null;
        for (WirelessBlockEntity n : tw) {
            if (!this.testWap((IWirelessAccessPoint)n)) continue;
            this.myWap = n;
        }
        return this.myWap != null;
    }

    private boolean testWap(IWirelessAccessPoint wap) {
        double offZ;
        double offY;
        double rangeLimit = wap.getRange();
        rangeLimit *= rangeLimit;
        DimensionalBlockPos dc = wap.getLocation();
        if (dc.getLevel() != this.player.f_19853_) {
            return false;
        }
        double offX = (double)dc.getPos().m_123341_() - this.player.m_20185_();
        double r = offX * offX + (offY = (double)dc.getPos().m_123342_() - this.player.m_20186_()) * offY + (offZ = (double)dc.getPos().m_123343_() - this.player.m_20189_()) * offZ;
        if (r < rangeLimit && this.sqRange > r && wap.isActive()) {
            this.sqRange = r;
            return true;
        }
        return false;
    }

    public long getAccessibleAmount(ItemStack stack) {
        return (long)stack.m_41613_() + (this.restockAbleItems.get(stack.m_41720_()) == null ? 0L : this.restockAbleItems.get(stack.m_41720_()));
    }

    public boolean isRestockable(ItemStack stack) {
        return this.restockAbleItems.containsKey(stack.m_41720_());
    }

    public void setRestockAbleItems(HashMap<Item, Long> items) {
        this.restockAbleItems = items;
    }

    @Nullable
    public MagnetHost getMagnetHost() {
        if (this.magnetHost == null) {
            if (this.getCraftingTerminal().m_41619_()) {
                return null;
            }
            this.magnetHost = new MagnetHost(this);
        }
        return this.magnetHost;
    }
}

