/*
 * Decompiled with CFR 0.152.
 */
package de.mari_023.ae2wtlib.terminal;

import appeng.api.features.Locatables;
import appeng.api.implementations.menuobjects.ItemMenuHost;
import appeng.api.networking.security.IActionHost;
import appeng.core.localization.PlayerMessages;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import de.mari_023.ae2wtlib.AE2wtlib;
import de.mari_023.ae2wtlib.wut.WUTHandler;
import java.util.OptionalLong;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public interface IUniversalWirelessTerminalItem {
    default public boolean open(Player player, ItemStack stack, MenuLocator locator, boolean returningFromSubmenu) {
        return MenuOpener.open(this.getMenuType(stack), (Player)player, (MenuLocator)locator, (boolean)returningFromSubmenu);
    }

    default public boolean tryOpen(Player player, MenuLocator locator, ItemStack stack, boolean returningFromSubmenu) {
        if (this.checkUniversalPreconditions(stack, player)) {
            return this.open(player, stack, locator, returningFromSubmenu);
        }
        return false;
    }

    @Nullable
    default public ItemMenuHost getMenuHost(Player player, MenuLocator locator, ItemStack stack) {
        return WUTHandler.wirelessTerminals.get(WUTHandler.getCurrentTerminal(stack)).wTMenuHostFactory().create(player, null, stack, (p, subMenu) -> this.tryOpen(player, locator, stack, true));
    }

    public MenuType<?> getMenuType(ItemStack var1);

    default public boolean checkUniversalPreconditions(ItemStack item, Player player) {
        if (item.m_41619_() || item.m_41720_() != this && item.m_41720_() != AE2wtlib.UNIVERSAL_TERMINAL) {
            return false;
        }
        Level level = player.m_20193_();
        if (level.m_5776_()) {
            return false;
        }
        OptionalLong key = this.getGridKey(item);
        if (key.isEmpty()) {
            player.m_6352_((Component)PlayerMessages.DeviceNotLinked.text(), Util.f_137441_);
            return false;
        }
        IActionHost securityStation = (IActionHost)Locatables.securityStations().get(level, key.getAsLong());
        if (securityStation == null) {
            player.m_6352_((Component)PlayerMessages.StationCanNotBeLocated.text(), Util.f_137441_);
            return false;
        }
        if (!this.hasPower(player, 0.5, item)) {
            player.m_6352_((Component)PlayerMessages.DeviceNotPowered.text(), Util.f_137441_);
            return false;
        }
        return true;
    }

    public OptionalLong getGridKey(ItemStack var1);

    public boolean hasPower(Player var1, double var2, ItemStack var4);
}

