/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.progression;

import appeng.api.networking.crafting.ICraftingLink;
import appeng.api.networking.crafting.ICraftingPlan;
import appeng.api.networking.crafting.ICraftingRequester;
import appeng.api.networking.ticking.TickRateModulation;
import com.almostreliable.lazierae2.content.requester.RequesterEntity;
import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.progression.CraftingLinkState;
import com.almostreliable.lazierae2.progression.IProgressionState;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public final class CraftingPlanState
implements IProgressionState {
    private final Future<? extends ICraftingPlan> future;

    CraftingPlanState(Future<? extends ICraftingPlan> future) {
        this.future = future;
    }

    @Override
    public IProgressionState handle(RequesterEntity owner, int slot) {
        if (!this.future.isDone()) {
            return this;
        }
        if (this.future.isCancelled()) {
            return IProgressionState.IDLE;
        }
        try {
            ICraftingPlan plan = this.future.get();
            ICraftingLink link = owner.getMainNodeGrid().getCraftingService().submitJob(plan, (ICraftingRequester)owner, null, false, owner.getActionSource());
            if (link == null) {
                return IProgressionState.IDLE;
            }
            return new CraftingLinkState(link);
        }
        catch (InterruptedException | ExecutionException e) {
            return IProgressionState.IDLE;
        }
    }

    @Override
    public TypeEnums.PROGRESSION_TYPE type() {
        return TypeEnums.PROGRESSION_TYPE.PLAN;
    }

    @Override
    public TickRateModulation getTickRateModulation() {
        return this.future.isDone() && !this.future.isCancelled() ? TickRateModulation.URGENT : TickRateModulation.SLOWER;
    }
}

