/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.network.sync;

import com.almostreliable.lazierae2.network.sync.IDataHandler;
import com.mojang.logging.LogUtils;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.network.FriendlyByteBuf;

public class MenuSynchronizer {
    private final Map<Short, IDataHandler> dataHandlers = new HashMap<Short, IDataHandler>();

    public void encode(FriendlyByteBuf buffer) {
        this.handleEncode(buffer, false);
    }

    public void encodeAll(FriendlyByteBuf buffer) {
        this.handleEncode(buffer, true);
    }

    public void decode(FriendlyByteBuf buffer) {
        short id = buffer.readShort();
        while (id != -1) {
            IDataHandler dataHandler = this.dataHandlers.get(id);
            if (dataHandler == null) {
                LogUtils.getLogger().warn("Unknown data handler with ID {} in {}!", (Object)id, (Object)buffer.getClass().getName());
            } else {
                dataHandler.decode(buffer);
            }
            id = buffer.readShort();
        }
    }

    public boolean hasDataHandlers() {
        return !this.dataHandlers.isEmpty();
    }

    public boolean hasChanged() {
        for (IDataHandler dataHandler : this.dataHandlers.values()) {
            if (!dataHandler.hasChanged()) continue;
            return true;
        }
        return false;
    }

    public void addDataHandler(IDataHandler dataHandler) {
        this.dataHandlers.put((short)this.dataHandlers.size(), dataHandler);
    }

    private void handleEncode(FriendlyByteBuf buffer, boolean all) {
        for (Map.Entry<Short, IDataHandler> dataHandler : this.dataHandlers.entrySet()) {
            if (!all && !dataHandler.getValue().hasChanged()) continue;
            buffer.writeShort((int)dataHandler.getKey().shortValue());
            dataHandler.getValue().encode(buffer);
        }
        buffer.m_130130_(-1);
    }
}

