/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.gui;

import com.almostreliable.lazierae2.content.GenericBlock;
import com.almostreliable.lazierae2.content.processor.ProcessorEntity;
import com.almostreliable.lazierae2.content.processor.ProcessorMenu;
import com.almostreliable.lazierae2.gui.GenericScreen;
import com.almostreliable.lazierae2.gui.control.IOControl;
import com.almostreliable.lazierae2.gui.widgets.AutoExtractButton;
import com.almostreliable.lazierae2.gui.widgets.EnergyDumpButton;
import com.almostreliable.lazierae2.inventory.UpgradeSlot;
import com.almostreliable.lazierae2.util.GuiUtil;
import com.almostreliable.lazierae2.util.TextUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.level.block.state.properties.Property;

public class ProcessorScreen
extends GenericScreen<ProcessorMenu> {
    public static final ResourceLocation TEXTURE = TextUtil.getRL(TextUtil.f("textures/gui/{}.png", "processor"));
    public static final int TEXTURE_WIDTH = 178;
    public static final int TEXTURE_HEIGHT = 154;
    public static final int PROGRESS_WIDTH = 40;
    public static final int PROGRESS_HEIGHT = 27;
    public static final int SLOT_SIZE = 18;
    private static final int ENERGY_WIDTH = 2;
    private static final int ENERGY_HEIGHT = 58;
    private final ResourceLocation progressTexture;
    private final GuiUtil.Tooltip progressTooltip;
    private final GuiUtil.Tooltip energyTooltip;
    private final GuiUtil.Tooltip upgradeTooltip;

    public ProcessorScreen(ProcessorMenu menu, Inventory inventory, Component ignoredTitle) {
        super(menu, inventory);
        this.progressTexture = TextUtil.getRL(TextUtil.f("textures/gui/progress/{}.png", new Object[]{((ProcessorEntity)menu.entity).getProcessorType()}));
        this.progressTooltip = this.setupProgressTooltip();
        this.energyTooltip = this.setupEnergyTooltip();
        this.upgradeTooltip = this.setupUpgradeTooltip();
    }

    protected void m_7856_() {
        super.m_7856_();
        this.addRenderable((AbstractWidget)new AutoExtractButton(this, ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity)::isAutoExtracting));
        this.addRenderable((AbstractWidget)new EnergyDumpButton(this));
        this.addRenderables((AbstractWidget[])IOControl.setup(this, 7, 7));
    }

    protected void m_7027_(PoseStack stack, int mX, int mY) {
        ProcessorScreen.m_93215_((PoseStack)stack, (Font)this.f_96547_, (Component)this.f_96539_, (int)88, (int)-12, (int)-1);
    }

    protected void m_7286_(PoseStack stack, float partial, int mX, int mY) {
        RenderSystem.m_157456_((int)0, (ResourceLocation)TEXTURE);
        ProcessorScreen.m_93133_((PoseStack)stack, (int)this.f_97735_, (int)this.f_97736_, (float)0.0f, (float)0.0f, (int)176, (int)154, (int)178, (int)154);
        if (((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).getProcessorType().getInputSlots() == 3) {
            ProcessorScreen.m_93133_((PoseStack)stack, (int)(this.f_97735_ + 43), (int)(this.f_97736_ + 7), (float)43.0f, (float)28.0f, (int)18, (int)18, (int)178, (int)154);
            ProcessorScreen.m_93133_((PoseStack)stack, (int)(this.f_97735_ + 43), (int)(this.f_97736_ + 49), (float)43.0f, (float)28.0f, (int)18, (int)18, (int)178, (int)154);
        }
        int capacity = ((ProcessorMenu)this.f_97732_).getEnergyCapacity();
        int energy = Math.min(((ProcessorMenu)this.f_97732_).getEnergyStored(), capacity);
        int barHeight = energy > 0 ? energy * 58 / capacity : 0;
        ProcessorScreen.m_93133_((PoseStack)stack, (int)(this.f_97735_ + 166), (int)(this.f_97736_ + 66 - barHeight), (float)176.0f, (float)0.0f, (int)2, (int)barHeight, (int)178, (int)154);
        RenderSystem.m_157456_((int)0, (ResourceLocation)this.progressTexture);
        int progress = ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).getProgress();
        int processTime = ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).getProcessTime();
        int barWidth = processTime > 0 && progress > 0 ? (progress + 1) * 20 / processTime : 0;
        ProcessorScreen.m_93133_((PoseStack)stack, (int)(this.f_97735_ + 78), (int)(this.f_97736_ + 24), (float)0.0f, (float)0.0f, (int)20, (int)27, (int)40, (int)27);
        ProcessorScreen.m_93133_((PoseStack)stack, (int)(this.f_97735_ + 78), (int)(this.f_97736_ + 24), (float)20.0f, (float)0.0f, (int)Math.min(barWidth, 20), (int)27, (int)40, (int)27);
    }

    @Override
    protected void m_7025_(PoseStack stack, int mX, int mY) {
        if (this.m_6774_(78, 23, 20, 27, mX, mY)) {
            this.m_96597_(stack, this.progressTooltip.build(), mX, mY);
            return;
        }
        if (this.m_6774_(165, 7, 4, 60, mX, mY)) {
            this.m_96597_(stack, this.energyTooltip.build(), mX, mY);
            return;
        }
        if (this.f_97734_ instanceof UpgradeSlot) {
            this.m_96597_(stack, this.upgradeTooltip.build(), mX, mY);
            return;
        }
        super.m_7025_(stack, mX, mY);
    }

    private GuiUtil.Tooltip setupProgressTooltip() {
        return GuiUtil.Tooltip.builder().title("progress.title", new Supplier[0]).blank().conditional(progress -> {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity)::getProgress;
            supplierArray[1] = ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity)::getProcessTime;
            progress.condition(() -> ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).getProgress() > 0 && ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).getProcessTime() > 0 || ((Boolean)((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).m_58900_().m_61143_((Property)GenericBlock.ACTIVE)).equals(Boolean.TRUE)).then(GuiUtil.Tooltip.builder().keyValue("progress.progress", supplierArray).conditional(extendedInfo -> {
                Supplier[] supplierArray = new Supplier[1];
                supplierArray[0] = ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity)::getRecipeTime;
                extendedInfo.condition(Screen::m_96638_).then(GuiUtil.Tooltip.builder().keyValue(((ProcessorMenu)this.f_97732_)::hasUpgrades, "progress.recipe_time", supplierArray).keyValue(((ProcessorMenu)this.f_97732_)::hasUpgrades, "progress.time_multiplier", this::getProcessTimeMultiplier).blank(((ProcessorMenu)this.f_97732_)::hasUpgrades).keyValue("progress.energy", () -> TextUtil.formatEnergy(((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).getEnergyCost(), 1, 2, false, true)).keyValue(((ProcessorMenu)this.f_97732_)::hasUpgrades, "progress.recipe_energy", () -> TextUtil.formatEnergy(((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).getRecipeEnergy(), 1, 2, false, true)).keyValue(((ProcessorMenu)this.f_97732_)::hasUpgrades, "progress.energy_multiplier", this::getEnergyCostMultiplier)).otherwise(GuiUtil.Tooltip.builder().blank().shiftForInfo());
            })).otherwise(GuiUtil.Tooltip.builder().line("progress.none", new Supplier[0]));
        });
    }

    private GuiUtil.Tooltip setupEnergyTooltip() {
        return GuiUtil.Tooltip.builder().title("energy.title", new Supplier[0]).blank().keyValue("energy.current", () -> TextUtil.formatEnergy(((ProcessorMenu)this.f_97732_).getEnergyStored(), 1, 3, Screen.m_96638_(), true)).keyValue("energy.capacity", () -> TextUtil.formatEnergy(((ProcessorMenu)this.f_97732_).getEnergyCapacity(), 1, 2, Screen.m_96638_(), true)).blank(() -> !Screen.m_96638_()).hotkeyHoldAction(() -> !Screen.m_96638_(), "key.keyboard.left.shift", "extended_numbers", new Supplier[0]);
    }

    private GuiUtil.Tooltip setupUpgradeTooltip() {
        return GuiUtil.Tooltip.builder().title("upgrade.title", new Supplier[0]).blank().conditional(tooltip -> {
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = ((ProcessorMenu)this.f_97732_)::getUpgradeCount;
            supplierArray[1] = () -> ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).getProcessorType().getUpgradeSlots();
            tooltip.condition(((ProcessorMenu)this.f_97732_)::hasUpgrades).then(GuiUtil.Tooltip.builder().keyValue("upgrade.current", supplierArray).keyValue("upgrade.time", this::getProcessTimeMultiplier).keyValue("upgrade.energy", this::getEnergyCostMultiplier).keyValue("upgrade.additional", this::getAdditionalUpgradeEnergy)).otherwise(GuiUtil.Tooltip.builder().line("upgrade.none", ChatFormatting.YELLOW, new Supplier[0]).blank().line(Screen::m_96638_, "upgrade.description", new Supplier[0]).shiftForInfo());
        });
    }

    private double getProcessTimeMultiplier() {
        return ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).calculateMultiplier(upgrades -> ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).getProcessorType().getProcessTimeMultiplier(upgrades));
    }

    private double getEnergyCostMultiplier() {
        return ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).calculateMultiplier(upgrades -> ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).getProcessorType().getEnergyCostMultiplier(upgrades));
    }

    private String getAdditionalUpgradeEnergy() {
        assert (this.f_97734_ != null);
        int additional = ((ProcessorEntity)((ProcessorMenu)this.f_97732_).entity).getProcessorType().getEnergyBufferAdd() * ((ProcessorMenu)this.f_97732_).getUpgradeCount();
        return TextUtil.formatEnergy(additional, 1, 2, Screen.m_96638_(), true);
    }
}

