/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.core;

import appeng.items.misc.CrystalSeedItem;
import com.almostreliable.lazierae2.content.GenericBlock;
import com.almostreliable.lazierae2.content.GenericEntity;
import com.almostreliable.lazierae2.content.GenericMenu;
import com.almostreliable.lazierae2.content.processor.ProcessorBlock;
import com.almostreliable.lazierae2.content.processor.ProcessorEntity;
import com.almostreliable.lazierae2.content.processor.ProcessorMenu;
import com.almostreliable.lazierae2.content.processor.ProcessorType;
import com.almostreliable.lazierae2.content.requester.RequesterBlock;
import com.almostreliable.lazierae2.content.requester.RequesterEntity;
import com.almostreliable.lazierae2.content.requester.RequesterMenu;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipe;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipeSerializer;
import java.util.Arrays;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.network.IContainerFactory;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;

public final class Setup {
    private static final Tab TAB = new Tab("lazierae2");

    private Setup() {
    }

    public static void init(IEventBus modEventBus) {
        Blocks.REGISTRY.register(modEventBus);
        Items.REGISTRY.register(modEventBus);
        Entities.REGISTRY.register(modEventBus);
        Menus.REGISTRY.register(modEventBus);
        Serializers.REGISTRY.register(modEventBus);
    }

    public static final class Blocks {
        private static final DeferredRegister<Block> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"lazierae2");
        public static final RegistryObject<ProcessorBlock> AGGREGATOR = Blocks.register(ProcessorBlock::new, ProcessorType.AGGREGATOR);
        public static final RegistryObject<ProcessorBlock> ETCHER = Blocks.register(ProcessorBlock::new, ProcessorType.ETCHER);
        public static final RegistryObject<ProcessorBlock> GRINDER = Blocks.register(ProcessorBlock::new, ProcessorType.GRINDER);
        public static final RegistryObject<ProcessorBlock> INFUSER = Blocks.register(ProcessorBlock::new, ProcessorType.INFUSER);
        public static final RegistryObject<RequesterBlock> REQUESTER = Blocks.register("requester", RequesterBlock::new);

        private Blocks() {
        }

        private static <B extends GenericBlock> RegistryObject<B> register(String id, Supplier<? extends B> constructor) {
            RegistryObject block = REGISTRY.register(id, constructor);
            Blocks.registerBlockItem(id, block);
            return block;
        }

        private static <B extends GenericBlock> RegistryObject<B> register(Function<? super ProcessorType, ? extends B> constructor, ProcessorType processorType) {
            RegistryObject block = REGISTRY.register(processorType.getId(), () -> (GenericBlock)((Object)((Object)constructor.apply(processorType))));
            Blocks.registerBlockItem(processorType.getId(), block);
            return block;
        }

        private static <B extends GenericBlock> void registerBlockItem(String id, RegistryObject<B> block) {
            Items.REGISTRY.register(id, () -> new BlockItem((Block)block.get(), new Item.Properties().m_41491_((CreativeModeTab)TAB)));
        }
    }

    public static final class Items {
        private static final DeferredRegister<Item> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"lazierae2");
        public static final RegistryObject<Item> COAL_DUST = Items.register("coal_dust");
        public static final RegistryObject<Item> CARB_FLUIX_DUST = Items.register("carbonic_fluix_dust");
        public static final RegistryObject<Item> FLUIX_STEEL = Items.register("fluix_steel_ingot");
        public static final RegistryObject<Item> RESONATING_CRYSTAL = Items.register("resonating_crystal");
        public static final RegistryObject<Item> RESONATING_SEED = Items.register("resonating_seed", () -> new CrystalSeedItem(Items.getProperties(), (ItemLike)RESONATING_CRYSTAL.get()));
        public static final RegistryObject<Item> RESONATING_DUST = Items.register("resonating_dust");
        public static final RegistryObject<Item> LOGIC_UNIT = Items.register("logic_unit");
        public static final RegistryObject<Item> GROWTH_CORE = Items.register("growth_core");
        public static final RegistryObject<Item> UNIVERSAL_PRESS = Items.register("universal_press");
        public static final RegistryObject<Item> PARALLEL_PRINTED = Items.register("parallel_printed");
        public static final RegistryObject<Item> PARALLEL_PROCESSOR = Items.register("parallel_processor");

        private Items() {
        }

        private static RegistryObject<Item> register(String id) {
            return Items.register(id, () -> new Item(Items.getProperties()));
        }

        private static RegistryObject<Item> register(String id, Supplier<? extends Item> item) {
            return REGISTRY.register(id, item);
        }

        private static Item.Properties getProperties() {
            return new Item.Properties().m_41491_((CreativeModeTab)TAB);
        }
    }

    public static final class Entities {
        private static final DeferredRegister<BlockEntityType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"lazierae2");
        public static final RegistryObject<BlockEntityType<ProcessorEntity>> PROCESSOR = Entities.register("processor", ProcessorEntity::new, Blocks.AGGREGATOR, Blocks.GRINDER, Blocks.INFUSER, Blocks.ETCHER);
        public static final RegistryObject<BlockEntityType<RequesterEntity>> REQUESTER = Entities.register("requester", RequesterEntity::new, Blocks.REQUESTER);

        private Entities() {
        }

        @SafeVarargs
        private static <E extends GenericEntity, B extends GenericBlock> RegistryObject<BlockEntityType<E>> register(String id, BlockEntityType.BlockEntitySupplier<E> entity, RegistryObject<B> ... blocks) {
            return REGISTRY.register(id, () -> BlockEntityType.Builder.m_155273_((BlockEntityType.BlockEntitySupplier)entity, (Block[])((Block[])Arrays.stream(blocks).map(RegistryObject::get).toArray(GenericBlock[]::new))).m_58966_(null));
        }
    }

    public static final class Menus {
        private static final DeferredRegister<MenuType<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.CONTAINERS, (String)"lazierae2");
        public static final RegistryObject<MenuType<ProcessorMenu>> PROCESSOR = Menus.register("processor", (windowId, inventory, data) -> {
            BlockEntity entity = inventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
            if (!(entity instanceof ProcessorEntity)) {
                throw new IllegalStateException("Entity is not a LazierAE2 processor!");
            }
            ProcessorEntity processor = (ProcessorEntity)entity;
            return new ProcessorMenu(windowId, processor, inventory);
        });
        public static final RegistryObject<MenuType<RequesterMenu>> REQUESTER = Menus.register("requester", (windowId, inventory, data) -> {
            BlockEntity entity = inventory.f_35978_.f_19853_.m_7702_(data.m_130135_());
            if (!(entity instanceof RequesterEntity)) {
                throw new IllegalStateException("Entity is not a LazierAE2 requester!");
            }
            RequesterEntity requester = (RequesterEntity)entity;
            return new RequesterMenu(windowId, requester, inventory);
        });

        private Menus() {
        }

        private static <M extends GenericMenu<?>> RegistryObject<MenuType<M>> register(String id, IContainerFactory<M> factory) {
            return REGISTRY.register(id, () -> IForgeMenuType.create((IContainerFactory)factory));
        }
    }

    public static final class Serializers {
        private static final DeferredRegister<RecipeSerializer<?>> REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.RECIPE_SERIALIZERS, (String)"lazierae2");
        public static final RegistryObject<RecipeSerializer<ProcessorRecipe>> AGGREGATOR = Serializers.register(ProcessorType.AGGREGATOR);
        public static final RegistryObject<RecipeSerializer<ProcessorRecipe>> ETCHER = Serializers.register(ProcessorType.ETCHER);
        public static final RegistryObject<RecipeSerializer<ProcessorRecipe>> GRINDER = Serializers.register(ProcessorType.GRINDER);
        public static final RegistryObject<RecipeSerializer<ProcessorRecipe>> INFUSER = Serializers.register(ProcessorType.INFUSER);

        private Serializers() {
        }

        private static RegistryObject<RecipeSerializer<ProcessorRecipe>> register(ProcessorType processorType) {
            return REGISTRY.register(processorType.getId(), () -> new ProcessorRecipeSerializer(processorType));
        }
    }

    private static final class Tab
    extends CreativeModeTab {
        private Tab(String label) {
            super(label);
        }

        public ItemStack m_6976_() {
            return new ItemStack((ItemLike)Items.RESONATING_CRYSTAL.get());
        }
    }

    public static final class Tags {
        private Tags() {
        }

        public static final class Blocks {
            public static final TagKey<Block> MACHINES = Blocks.mod("machines");

            private Blocks() {
            }

            private static TagKey<Block> mod(String path) {
                return BlockTags.create((ResourceLocation)new ResourceLocation("lazierae2", path));
            }
        }

        public static final class Items {
            public static final TagKey<Item> DUSTS_COAL = Items.forge("dusts/coal");
            public static final TagKey<Item> DUSTS_CARBONIC_FLUIX = Items.forge("dusts/carbonic_fluix");
            public static final TagKey<Item> DUSTS_RESONATING = Items.forge("dusts/resonating");
            public static final TagKey<Item> GEMS_RESONATING = Items.forge("gems/resonating");
            public static final TagKey<Item> INGOTS_FLUIX_STEEL = Items.forge("ingots/fluix_steel");
            public static final TagKey<Item> PROCESSORS = Items.mod("processors");
            public static final TagKey<Item> PROCESSOR_PARALLEL = Items.mod("processors/parallel");
            public static final TagKey<Item> INGOTS_STEEL = Items.forge("ingots/steel");

            private Items() {
            }

            private static TagKey<Item> forge(String path) {
                return ItemTags.create((ResourceLocation)new ResourceLocation("forge", path));
            }

            private static TagKey<Item> mod(String path) {
                return ItemTags.create((ResourceLocation)new ResourceLocation("lazierae2", path));
            }
        }
    }
}

