/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content.processor;

import com.almostreliable.lazierae2.content.processor.ProcessorBlock;
import com.almostreliable.lazierae2.core.Config;
import com.almostreliable.lazierae2.core.Setup;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipe;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipeFactory;
import com.almostreliable.lazierae2.recipe.type.SingleInputRecipe;
import com.almostreliable.lazierae2.recipe.type.TripleInputRecipe;
import com.almostreliable.lazierae2.util.TextUtil;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.Lazy;
import net.minecraftforge.registries.RegistryObject;

public enum ProcessorType implements RecipeType<ProcessorRecipe>
{
    AGGREGATOR("aggregator", 3, () -> Config.COMMON.aggregator, () -> Setup.Blocks.AGGREGATOR, () -> Setup.Serializers.AGGREGATOR),
    ETCHER("etcher", 3, () -> Config.COMMON.etcher, () -> Setup.Blocks.ETCHER, () -> Setup.Serializers.ETCHER),
    GRINDER("grinder", 1, () -> Config.COMMON.grinder, () -> Setup.Blocks.GRINDER, () -> Setup.Serializers.GRINDER),
    INFUSER("infuser", 3, () -> Config.COMMON.infuser, () -> Setup.Blocks.INFUSER, () -> Setup.Serializers.INFUSER);

    private final String id;
    private final int inputSlots;
    private final Lazy<Config.ProcessorConfig> config;
    private final Supplier<RegistryObject<? extends ProcessorBlock>> itemProvider;
    private final Supplier<RegistryObject<? extends RecipeSerializer<ProcessorRecipe>>> recipeSerializer;

    private ProcessorType(String id, int inputSlots, Supplier<Config.ProcessorConfig> config, Supplier<RegistryObject<? extends ProcessorBlock>> itemProvider, Supplier<RegistryObject<? extends RecipeSerializer<ProcessorRecipe>>> recipeSerializer) {
        this.id = id;
        this.inputSlots = inputSlots;
        this.config = Lazy.of(config);
        this.itemProvider = itemProvider;
        this.recipeSerializer = recipeSerializer;
        Registry.m_122965_((Registry)Registry.f_122864_, (ResourceLocation)TextUtil.getRL(id), (Object)((Object)this));
    }

    public String toString() {
        return this.id;
    }

    public double getProcessTimeMultiplier(int upgrades) {
        return (Double)((List)((Config.ProcessorConfig)this.config.get()).processTimeMulti.get()).get(upgrades - 1);
    }

    public double getEnergyCostMultiplier(int upgrades) {
        return (Double)((List)((Config.ProcessorConfig)this.config.get()).energyUsageMulti.get()).get(upgrades - 1);
    }

    public ItemLike getItemProvider() {
        return (ItemLike)this.itemProvider.get().get();
    }

    public String getId() {
        return this.id;
    }

    public int getBaseProcessTime() {
        return (Integer)((Config.ProcessorConfig)this.config.get()).baseProcessTime.get();
    }

    public int getBaseEnergyCost() {
        return (Integer)((Config.ProcessorConfig)this.config.get()).baseEnergyUsage.get();
    }

    public int getUpgradeSlots() {
        return (Integer)((Config.ProcessorConfig)this.config.get()).upgradeSlots.get();
    }

    public int getBaseEnergyBuffer() {
        return (Integer)((Config.ProcessorConfig)this.config.get()).baseEnergyBuffer.get();
    }

    public int getEnergyBufferAdd() {
        return (Integer)((Config.ProcessorConfig)this.config.get()).energyBufferAdd.get();
    }

    public ProcessorRecipeFactory getRecipeFactory() {
        return this.inputSlots == 1 ? SingleInputRecipe::new : TripleInputRecipe::new;
    }

    public RecipeSerializer<ProcessorRecipe> getRecipeSerializer() {
        return (RecipeSerializer)this.recipeSerializer.get().get();
    }

    public int getInputSlots() {
        return this.inputSlots;
    }
}

