/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content.processor;

import com.almostreliable.lazierae2.content.processor.ProcessorEntity;
import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.util.TextUtil;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.Container;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class ProcessorInventory
implements IItemHandlerModifiable,
INBTSerializable<CompoundTag> {
    public static final int NON_INPUT_SLOTS = 2;
    static final int UPGRADE_SLOT = 0;
    static final int OUTPUT_SLOT = 1;
    private final ProcessorEntity entity;
    private final int inputSlots;
    private LazyOptional<IItemHandler> inputInventoryCap;
    private LazyOptional<IItemHandler> outputInventoryCap;
    private LazyOptional<IItemHandler> ioInventoryCap;
    private NonNullList<ItemStack> stacks;
    @Nullable
    private Container vanillaInventory;
    private boolean vanillaNeedsUpdate;

    ProcessorInventory(ProcessorEntity entity) {
        this.entity = entity;
        this.inputSlots = entity.getProcessorType().getInputSlots();
        this.stacks = NonNullList.m_122780_((int)(this.inputSlots + 2), (Object)ItemStack.f_41583_);
        this.setupSubInventories();
    }

    public CompoundTag serializeNBT() {
        ListTag tagList = new ListTag();
        for (int slot = 0; slot < this.stacks.size(); ++slot) {
            if (((ItemStack)this.stacks.get(slot)).m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128405_("slot", slot);
            ((ItemStack)this.stacks.get(slot)).m_41739_(itemTag);
            tagList.add((Object)itemTag);
        }
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("size", this.stacks.size());
        tag.m_128365_("items", (Tag)tagList);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.setSize(tag.m_128441_("size") ? tag.m_128451_("size") : this.stacks.size());
        ListTag tagList = tag.m_128437_("items", 10);
        for (int i = 0; i < tagList.size(); ++i) {
            CompoundTag itemTags = tagList.m_128728_(i);
            int slot = itemTags.m_128451_("slot");
            if (slot < 0 || slot >= this.stacks.size()) continue;
            this.stacks.set(slot, (Object)ItemStack.m_41712_((CompoundTag)itemTags));
        }
        this.setupSubInventories();
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.validateSlot(slot);
        this.stacks.set(slot, (Object)stack);
        this.onContentsChanged();
    }

    Container toVanilla() {
        if (this.vanillaInventory == null || this.vanillaNeedsUpdate) {
            this.vanillaInventory = new RecipeWrapper((IItemHandlerModifiable)this);
            this.vanillaNeedsUpdate = false;
        }
        return this.vanillaInventory;
    }

    void dropContents(boolean creative) {
        int slot;
        if (this.entity.m_58904_() == null) {
            return;
        }
        BlockPos pos = this.entity.m_58899_();
        int n = slot = creative ? 0 : 1;
        while (slot < this.getSlots()) {
            ItemStack stack = this.getStackInSlot(slot);
            if (!stack.m_41619_()) {
                this.entity.m_58904_().m_7967_((Entity)new ItemEntity(this.entity.m_58904_(), (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
            }
            ++slot;
        }
    }

    LazyOptional<IItemHandler> getInventoryCap(TypeEnums.IO_SETTING type) {
        return switch (type) {
            case TypeEnums.IO_SETTING.INPUT -> this.inputInventoryCap;
            case TypeEnums.IO_SETTING.OUTPUT -> this.outputInventoryCap;
            case TypeEnums.IO_SETTING.IO -> this.ioInventoryCap;
            default -> throw new IllegalArgumentException(TextUtil.f("Unknown inventory type: {}", new Object[]{type}));
        };
    }

    CompoundTag serializeUpgrades() {
        return this.getStackInSlot(0).m_41739_(new CompoundTag());
    }

    void deserializeUpgrades(CompoundTag tag) {
        this.setStackInSlot(0, ItemStack.m_41712_((CompoundTag)tag));
    }

    void shrinkInputSlots(Map<Integer, Integer> slotsToShrink, int outputMultiplier) {
        for (Map.Entry<Integer, Integer> slot : slotsToShrink.entrySet()) {
            if (this.getStackInSlot(slot.getKey()).m_41613_() == slot.getValue() * outputMultiplier) {
                this.setStackInSlot(slot.getKey(), ItemStack.f_41583_);
                continue;
            }
            this.getStackInSlot(slot.getKey()).m_41774_(slot.getValue() * outputMultiplier);
            this.entity.m_6596_();
        }
    }

    void invalidate() {
        this.inputInventoryCap.invalidate();
        this.outputInventoryCap.invalidate();
        this.ioInventoryCap.invalidate();
    }

    ItemStack insertToInputs(ItemStack stack) {
        int slot;
        if (stack.m_41619_()) {
            return stack;
        }
        if (!stack.m_41753_()) {
            for (int slot2 = 2; slot2 < Math.min(this.getSlots(), 2 + this.inputSlots); ++slot2) {
                if (!(stack = this.insertItem(slot2, stack, false)).m_41619_()) continue;
                return ItemStack.f_41583_;
            }
            return stack;
        }
        for (slot = 2; slot < Math.min(this.getSlots(), 2 + this.inputSlots); ++slot) {
            ItemStack slotStack = this.getStackInSlot(slot);
            if (!ItemHandlerHelper.canItemStacksStackRelaxed((ItemStack)slotStack, (ItemStack)stack)) continue;
            int oldCount = stack.m_41613_();
            if (!(stack = this.insertItem(slot, stack, false)).m_41619_() && oldCount == stack.m_41613_()) continue;
            return stack;
        }
        if (!stack.m_41619_()) {
            for (slot = 2; slot < Math.min(this.getSlots(), 2 + this.inputSlots); ++slot) {
                if (!this.getStackInSlot(slot).m_41619_() || !(stack = this.insertItem(slot, stack, false)).m_41619_()) continue;
                return stack;
            }
        }
        return stack;
    }

    int getStackLimit(int slot, ItemStack stack) {
        return Math.min(this.getSlotLimit(slot), stack.m_41741_());
    }

    private void setupSubInventories() {
        this.inputInventoryCap = LazyOptional.of(() -> new InputInventory(this, this.inputSlots));
        this.outputInventoryCap = LazyOptional.of(() -> new OutputInventory(this));
        this.ioInventoryCap = LazyOptional.of(() -> new IOInventory(this, this.inputSlots + 1));
    }

    private void onContentsChanged() {
        this.vanillaNeedsUpdate = true;
        this.entity.m_6596_();
    }

    private void validateSlot(int slot) {
        if (slot < 0 || slot >= this.stacks.size()) {
            throw new IllegalStateException(TextUtil.f("Slot {} is not in range [0,{})", slot, this.stacks.size()));
        }
    }

    int getInputSlots() {
        return this.inputSlots;
    }

    ItemStack getStackInOutput() {
        return this.getStackInSlot(1);
    }

    void setStackInOutput(ItemStack stack) {
        this.setStackInSlot(1, stack);
    }

    int getUpgradeCount() {
        return this.getStackInSlot(0).m_41613_();
    }

    public int getSlots() {
        return this.stacks.size();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        this.validateSlot(slot);
        return (ItemStack)this.stacks.get(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        boolean reachedLimit;
        if (stack.m_41619_()) {
            return ItemStack.f_41583_;
        }
        if (!this.isItemValid(slot, stack)) {
            return stack;
        }
        this.validateSlot(slot);
        ItemStack current = (ItemStack)this.stacks.get(slot);
        int limit = this.getStackLimit(slot, stack);
        if (!current.m_41619_()) {
            if (!ItemHandlerHelper.canItemStacksStack((ItemStack)stack, (ItemStack)current)) {
                return stack;
            }
            limit -= current.m_41613_();
        }
        if (limit <= 0) {
            return stack;
        }
        boolean bl = reachedLimit = stack.m_41613_() > limit;
        if (!simulate) {
            if (current.m_41619_()) {
                this.stacks.set(slot, (Object)(reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)limit) : stack));
            } else {
                current.m_41769_(reachedLimit ? limit : stack.m_41613_());
            }
            this.onContentsChanged();
        }
        return reachedLimit ? ItemHandlerHelper.copyStackWithSize((ItemStack)stack, (int)(stack.m_41613_() - limit)) : ItemStack.f_41583_;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (amount == 0) {
            return ItemStack.f_41583_;
        }
        this.validateSlot(slot);
        ItemStack current = (ItemStack)this.stacks.get(slot);
        if (current.m_41619_()) {
            return ItemStack.f_41583_;
        }
        int toExtract = Math.min(amount, current.m_41741_());
        if (current.m_41613_() <= toExtract) {
            if (!simulate) {
                this.stacks.set(slot, (Object)ItemStack.f_41583_);
                this.onContentsChanged();
                return current;
            }
            return current.m_41777_();
        }
        if (!simulate) {
            this.stacks.set(slot, (Object)ItemHandlerHelper.copyStackWithSize((ItemStack)current, (int)(current.m_41613_() - toExtract)));
            this.onContentsChanged();
        }
        return ItemHandlerHelper.copyStackWithSize((ItemStack)current, (int)toExtract);
    }

    public int getSlotLimit(int slot) {
        this.validateSlot(slot);
        if (slot == 0) {
            return this.entity.getProcessorType().getUpgradeSlots();
        }
        return 64;
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        if (slot != 1 && slot != 0 && this.inputSlots > 1) {
            for (int inputSlot = 2; inputSlot < this.inputSlots + 2; ++inputSlot) {
                if (inputSlot == slot || !((ItemStack)this.stacks.get(inputSlot)).m_41656_(stack)) continue;
                return false;
            }
        }
        return true;
    }

    private void setSize(int size) {
        this.stacks = NonNullList.m_122780_((int)size, (Object)ItemStack.f_41583_);
    }

    private static final class IOInventory
    extends OutputInventory {
        private final int size;

        private IOInventory(ProcessorInventory parent, int size) {
            super(parent);
            this.size = size;
        }

        @Override
        public int getSlots() {
            return this.size;
        }

        @Override
        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            if (slot + 1 < 2) {
                return stack;
            }
            return this.parent.insertItem(slot + 1, stack, simulate);
        }

        @Override
        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            if (slot + 1 != 1) {
                return ItemStack.f_41583_;
            }
            return this.parent.extractItem(slot + 1, amount, simulate);
        }
    }

    private static class OutputInventory
    implements IItemHandlerModifiable {
        final ProcessorInventory parent;

        private OutputInventory(ProcessorInventory parent) {
            this.parent = parent;
        }

        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.parent.setStackInSlot(slot + 1, stack);
        }

        public int getSlots() {
            return 1;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.parent.getStackInSlot(slot + 1);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return stack;
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return this.parent.extractItem(slot + 1, amount, simulate);
        }

        public int getSlotLimit(int slot) {
            return this.parent.getSlotLimit(slot + 1);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.parent.isItemValid(slot + 1, stack);
        }
    }

    private record InputInventory(ProcessorInventory parent, int size) implements IItemHandlerModifiable
    {
        public void setStackInSlot(int slot, @Nonnull ItemStack stack) {
            this.parent.setStackInSlot(slot + 2, stack);
        }

        public int getSlots() {
            return this.size;
        }

        @Nonnull
        public ItemStack getStackInSlot(int slot) {
            return this.parent.getStackInSlot(slot + 2);
        }

        @Nonnull
        public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
            return this.parent.insertItem(slot + 2, stack, simulate);
        }

        @Nonnull
        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            return ItemStack.f_41583_;
        }

        public int getSlotLimit(int slot) {
            return this.parent.getSlotLimit(slot + 2);
        }

        public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
            return this.parent.isItemValid(slot + 2, stack);
        }
    }
}

