/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.compat.jei;

import com.almostreliable.lazierae2.content.processor.ProcessorEntity;
import com.almostreliable.lazierae2.content.processor.ProcessorMenu;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.transfer.IRecipeTransferInfo;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.Slot;

public class ProcessorRecipeInfo<R extends ProcessorRecipe>
implements IRecipeTransferInfo<ProcessorMenu, R> {
    private final RecipeType<R> recipeType;
    private final int recipeSlotStart;
    private final int recipeSlotCount;
    private final int inventorySlotStart;
    private final int inventorySlotCount;

    ProcessorRecipeInfo(RecipeType<R> recipeType, int recipeSlotStart, int recipeSlotCount, int inventorySlotStart, int inventorySlotCount) {
        this.recipeType = recipeType;
        this.recipeSlotStart = recipeSlotStart;
        this.recipeSlotCount = recipeSlotCount;
        this.inventorySlotStart = inventorySlotStart;
        this.inventorySlotCount = inventorySlotCount;
    }

    public Class<ProcessorMenu> getContainerClass() {
        return ProcessorMenu.class;
    }

    public RecipeType<R> getRecipeType() {
        return this.recipeType;
    }

    public boolean canHandle(ProcessorMenu container, ProcessorRecipe recipe) {
        return ((ProcessorEntity)container.entity).getProcessorType().getId().equals(this.recipeType.getUid().m_135815_());
    }

    public List<Slot> getRecipeSlots(ProcessorMenu container, ProcessorRecipe recipe) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = this.recipeSlotStart; i < this.recipeSlotStart + this.recipeSlotCount; ++i) {
            Slot slot = container.m_38853_(i);
            slots.add(slot);
        }
        return slots;
    }

    public List<Slot> getInventorySlots(ProcessorMenu container, ProcessorRecipe recipe) {
        ArrayList<Slot> slots = new ArrayList<Slot>();
        for (int i = this.inventorySlotStart; i < this.inventorySlotStart + this.inventorySlotCount; ++i) {
            Slot slot = container.m_38853_(i);
            slots.add(slot);
        }
        return slots;
    }

    public Class<R> getRecipeClass() {
        return ProcessorRecipe.class;
    }

    public ResourceLocation getRecipeCategoryUid() {
        return this.recipeType.getUid();
    }
}

