/*
 * Decompiled with CFR 0.152.
 */
package com.natamus.collective.forge.events;

import com.natamus.collective_common_forge.events.CollectiveEvents;
import com.natamus.collective_common_forge.functions.WorldFunctions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber
public class RegisterCollectiveEvents {
    @SubscribeEvent
    public void onWorldTick(TickEvent.WorldTickEvent e) {
        Level level = e.world;
        if (level.f_46443_ || !e.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        CollectiveEvents.onWorldTick((ServerLevel)level);
    }

    @SubscribeEvent
    public void onServerTick(TickEvent.ServerTickEvent e) {
        if (!e.phase.equals((Object)TickEvent.Phase.END)) {
            return;
        }
        CollectiveEvents.onServerTick(ServerLifecycleHooks.getCurrentServer());
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMobSpawnerSpecialSpawn(LivingSpawnEvent.SpecialSpawn e) {
        Level Level2 = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getWorld());
        if (Level2 == null) {
            return;
        }
        if (e.getSpawner() != null) {
            e.getEntity().m_20049_("collective.fromspawner");
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onMobSpawnerCheckSpawn(LivingSpawnEvent.CheckSpawn e) {
        Level Level2 = WorldFunctions.getWorldIfInstanceOfAndNotRemote(e.getWorld());
        if (Level2 == null) {
            return;
        }
        if (e.getSpawner() != null) {
            e.getEntity().m_20049_("collective.fromspawner");
        }
    }

    @SubscribeEvent
    public void onEntityJoinLevel(EntityJoinWorldEvent e) {
        if (!CollectiveEvents.onEntityJoinLevel(e.getWorld(), e.getEntity())) {
            e.setCanceled(true);
        }
    }
}

