/*
 * Decompiled with CFR 0.152.
 */
package mezz.jei.forge.platform;

import java.util.Collection;
import java.util.Optional;
import mezz.jei.common.platform.IPlatformRegistry;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;

public class ForgeRegistryWrapper<T extends IForgeRegistryEntry<T>>
implements IPlatformRegistry<T> {
    private final ForgeRegistry<T> forgeRegistry;

    public static <T, V extends IForgeRegistryEntry<V>> IPlatformRegistry<T> getRegistry(ResourceKey<? extends Registry<T>> key) {
        ForgeRegistryWrapper<T> registryWrapper;
        ForgeRegistry registry = RegistryManager.ACTIVE.getRegistry(key.m_135782_());
        ForgeRegistryWrapper<T> castRegistry = registryWrapper = new ForgeRegistryWrapper<T>(registry);
        return castRegistry;
    }

    private ForgeRegistryWrapper(ForgeRegistry<T> forgeRegistry) {
        this.forgeRegistry = forgeRegistry;
    }

    @Override
    public Collection<T> getValues() {
        return this.forgeRegistry.getValues();
    }

    @Override
    @Nullable
    public T getValue(ResourceLocation resourceLocation) {
        return (T)this.forgeRegistry.getValue(resourceLocation);
    }

    @Override
    public int getId(T entry) {
        return this.forgeRegistry.getID(entry);
    }

    @Override
    public Optional<T> getValue(int id) {
        IForgeRegistryEntry value = this.forgeRegistry.getValue(id);
        return Optional.ofNullable(value);
    }

    @Override
    public boolean contains(T entry) {
        return this.forgeRegistry.containsValue(entry);
    }
}

