/*
 * Decompiled with CFR 0.152.
 */
package tfar.finitewater.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import tfar.finitewater.config.Config;

public class ConfigHandler {
    public static final ConfigHandler CONFIG_HANDLER = new ConfigHandler();
    private File file;
    private Config config;

    private ConfigHandler() {
    }

    private boolean prepareConfigFile() {
        if (this.file != null) {
            return false;
        }
        File configDirectory = new File(".", "config");
        this.file = new File(configDirectory, "finitewater.json");
        return !this.file.exists();
    }

    public Config getConfig() {
        if (this.config != null) {
            return this.config;
        }
        this.config = new Config();
        this.load();
        return this.config;
    }

    private void load() {
        this.prepareConfigFile();
        try {
            if (this.file.exists()) {
                Gson gson = new Gson();
                BufferedReader br = new BufferedReader(new FileReader(this.file));
                this.config = (Config)gson.fromJson((Reader)br, Config.class);
            }
        }
        catch (Exception e) {
            System.err.println("Couldn't load configuration file for finite water, reverting to defaults");
            e.printStackTrace();
        }
    }

    public void save() {
        if (!this.prepareConfigFile()) {
            return;
        }
        this.config = new Config();
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonString = gson.toJson((Object)this.config);
        try (FileWriter fileWriter = new FileWriter(this.file);){
            fileWriter.write(jsonString);
        }
        catch (IOException e) {
            System.err.println("Couldn't save ore configuration file for gt4r");
            e.printStackTrace();
        }
    }
}

