/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.jei.throwinginwater;

import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.AEItems;
import appeng.core.localization.ItemModText;
import appeng.entity.GrowingCrystalEntity;
import appeng.integration.modules.jei.JEIPlugin;
import appeng.integration.modules.jei.throwinginwater.GrowingSeedIconRenderer;
import appeng.integration.modules.jei.throwinginwater.ThrowingInWaterDisplay;
import appeng.integration.modules.jei.throwinginwater.WaterBlockRenderer;
import appeng.items.misc.CrystalSeedItem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import org.apache.commons.lang3.time.DurationFormatUtils;

public class ThrowingInWaterCategory
implements IRecipeCategory<ThrowingInWaterDisplay> {
    public static final RecipeType<ThrowingInWaterDisplay> RECIPE_TYPE = RecipeType.create((String)"ae2", (String)"throwing_in_water", ThrowingInWaterDisplay.class);
    private final IDrawable icon;
    private final IDrawable background;
    private final IDrawable arrow;
    private final IDrawable slotBackground;
    private final IDrawableAnimated animatedArrow;

    public ThrowingInWaterCategory(IGuiHelper guiHelper) {
        ItemStack stage1 = AEItems.CERTUS_CRYSTAL_SEED.stack();
        CrystalSeedItem.setGrowthTicks(stage1, 0);
        ItemStack stage2 = AEItems.CERTUS_CRYSTAL_SEED.stack();
        CrystalSeedItem.setGrowthTicks(stage2, 9600);
        ItemStack stage3 = AEItems.CERTUS_CRYSTAL_SEED.stack();
        CrystalSeedItem.setGrowthTicks(stage3, 16800);
        ItemStack result = AEItems.CERTUS_QUARTZ_CRYSTAL.stack();
        this.background = guiHelper.createBlankDrawable(130, 62);
        this.slotBackground = guiHelper.createDrawable(JEIPlugin.TEXTURE, 0, 34, 18, 18);
        this.icon = new GrowingSeedIconRenderer(guiHelper, List.of(stage1, stage2, stage3, result));
        this.arrow = guiHelper.createDrawable(JEIPlugin.TEXTURE, 0, 17, 24, 17);
        this.animatedArrow = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(JEIPlugin.TEXTURE, 0, 0, 24, 17), 60, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public RecipeType<ThrowingInWaterDisplay> getRecipeType() {
        return RECIPE_TYPE;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, ThrowingInWaterDisplay recipe, IFocusGroup focuses) {
        int slotIndex = 0;
        int y = 5;
        for (Ingredient input : recipe.getIngredients()) {
            builder.addSlot(RecipeIngredientRole.INPUT, 6, y + 1).setSlotName("input" + slotIndex++).addIngredients(input);
            y += 18;
        }
        int yOffset = this.getYOffset(recipe);
        builder.addSlot(RecipeIngredientRole.OUTPUT, 106, yOffset + 1).setSlotName("output").addItemStack(recipe.getResult());
        builder.addInvisibleIngredients(RecipeIngredientRole.CATALYST).addItemStack(AEBlocks.QUARTZ_GROWTH_ACCELERATOR.stack());
    }

    public void draw(ThrowingInWaterDisplay recipe, IRecipeSlotsView recipeSlotsView, PoseStack stack, double mouseX, double mouseY) {
        int y = 5;
        for (Ingredient input : recipe.getIngredients()) {
            this.slotBackground.draw(stack, 5, y);
            y += 18;
        }
        int yOffset = this.getYOffset(recipe);
        this.arrow.draw(stack, 25, yOffset);
        new WaterBlockRenderer().draw(stack, 55, yOffset);
        this.arrow.draw(stack, 76, yOffset);
        if (recipe.isSupportsAccelerators()) {
            this.animatedArrow.draw(stack, 76, yOffset);
        }
        this.slotBackground.draw(stack, 105, yOffset);
        if (recipe.isSupportsAccelerators()) {
            int durationY = 10 + recipe.getIngredients().size() * 18 + 2;
            long defaultDuration = GrowingCrystalEntity.getGrowthDuration(0).toMillis();
            Minecraft minecraft = Minecraft.m_91087_();
            TextComponent text = new TextComponent(DurationFormatUtils.formatDurationWords((long)defaultDuration, (boolean)true, (boolean)true));
            int textWidth = minecraft.f_91062_.m_92852_((FormattedText)text);
            minecraft.f_91062_.m_92889_(stack, (Component)text, (float)(this.background.getWidth() - textWidth) / 2.0f, (float)durationY, -12566464);
        }
    }

    private int getYOffset(ThrowingInWaterDisplay recipe) {
        return (recipe.getIngredients().size() - 1) / 2 * 18 + 5;
    }

    public List<Component> getTooltipStrings(ThrowingInWaterDisplay recipe, IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        int yOffset = this.getYOffset(recipe);
        if (recipe.isSupportsAccelerators() && mouseY >= (double)(yOffset + 18) && mouseY <= (double)(yOffset + 31)) {
            ArrayList<Component> tooltipLines = new ArrayList<Component>();
            tooltipLines.add((Component)ItemModText.WITH_CRYSTAL_GROWTH_ACCELERATORS.text());
            for (int i = 1; i <= 5; ++i) {
                long duration = GrowingCrystalEntity.getGrowthDuration(i).toMillis();
                tooltipLines.add((Component)new TextComponent(i + ": " + DurationFormatUtils.formatDurationWords((long)duration, (boolean)true, (boolean)true)));
            }
            return tooltipLines;
        }
        return Collections.emptyList();
    }

    public Component getTitle() {
        return ItemModText.THROWING_IN_WATER_CATEGORY.text();
    }

    public ResourceLocation getUid() {
        return this.getRecipeType().getUid();
    }

    public Class<? extends ThrowingInWaterDisplay> getRecipeClass() {
        return this.getRecipeType().getRecipeClass();
    }
}

