/*
 * Decompiled with CFR 0.152.
 */
package appeng.datagen.providers.models;

import appeng.block.crafting.AbstractCraftingUnitBlock;
import appeng.block.crafting.PatternProviderBlock;
import appeng.block.misc.VibrationChamberBlock;
import appeng.block.networking.EnergyCellBlock;
import appeng.block.spatial.SpatialAnchorBlock;
import appeng.block.spatial.SpatialIOPortBlock;
import appeng.block.storage.IOPortBlock;
import appeng.core.AppEng;
import appeng.core.definitions.AEBlocks;
import appeng.core.definitions.BlockDefinition;
import appeng.datagen.providers.models.AE2BlockStateProvider;
import appeng.init.client.InitItemModelsProperties;
import java.util.ArrayList;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.CustomLoaderBuilder;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.client.model.generators.VariantBlockStateBuilder;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockModelProvider
extends AE2BlockStateProvider {
    public BlockModelProvider(DataGenerator gen, ExistingFileHelper exFileHelper) {
        super(gen, "ae2", exFileHelper);
    }

    protected void registerStatesAndModels() {
        this.emptyModel(AEBlocks.MATRIX_FRAME);
        this.builtInModel(AEBlocks.QUARTZ_GLASS, true);
        this.builtInModel(AEBlocks.CABLE_BUS);
        this.builtInModel(AEBlocks.PAINT);
        this.builtInModel(AEBlocks.SKY_COMPASS, true);
        this.builtInBlockModel("drive");
        this.builtInBlockModel("spatial_pylon");
        this.builtInBlockModel("qnb/qnb_formed");
        this.builtInBlockModel("crafting/monitor_formed");
        this.builtInBlockModel("crafting/unit_formed");
        this.builtInBlockModel("crafting/accelerator_formed");
        this.builtInBlockModel("crafting/1k_storage_formed");
        this.builtInBlockModel("crafting/4k_storage_formed");
        this.builtInBlockModel("crafting/16k_storage_formed");
        this.builtInBlockModel("crafting/64k_storage_formed");
        this.builtInBlockModel("crafting/256k_storage_formed");
        this.simpleBlock(AEBlocks.SPATIAL_PYLON.block(), (ModelFile)this.models().getBuilder(this.modelPath(AEBlocks.SPATIAL_PYLON)));
        this.itemModels().cubeAll(this.modelPath(AEBlocks.SPATIAL_PYLON), AppEng.makeId("item/spatial_pylon"));
        this.generateOreBlock(AEBlocks.QUARTZ_ORE);
        this.generateOreBlock(AEBlocks.DEEPSLATE_QUARTZ_ORE);
        this.simpleBlockAndItem(AEBlocks.CONDENSER);
        this.simpleBlockAndItem(AEBlocks.ENERGY_ACCEPTOR);
        this.simpleBlockAndItem(AEBlocks.INTERFACE);
        this.simpleBlockAndItem(AEBlocks.DEBUG_ITEM_GEN, "block/debug/item_gen");
        this.simpleBlockAndItem(AEBlocks.DEBUG_CHUNK_LOADER, "block/debug/chunk_loader");
        this.simpleBlockAndItem(AEBlocks.DEBUG_PHANTOM_NODE, "block/debug/phantom_node");
        this.simpleBlockAndItem(AEBlocks.DEBUG_CUBE_GEN, "block/debug/cube_gen");
        this.simpleBlockAndItem(AEBlocks.DEBUG_ENERGY_GEN, "block/debug/energy_gen");
        this.craftingModel(AEBlocks.CRAFTING_ACCELERATOR, "accelerator");
        this.craftingModel(AEBlocks.CRAFTING_UNIT, "unit");
        this.craftingModel(AEBlocks.CRAFTING_STORAGE_1K, "1k_storage");
        this.craftingModel(AEBlocks.CRAFTING_STORAGE_4K, "4k_storage");
        this.craftingModel(AEBlocks.CRAFTING_STORAGE_16K, "16k_storage");
        this.craftingModel(AEBlocks.CRAFTING_STORAGE_64K, "64k_storage");
        this.craftingModel(AEBlocks.CRAFTING_STORAGE_256K, "256k_storage");
        this.simpleBlockAndItem(AEBlocks.CELL_WORKBENCH, (ModelFile)this.models().cubeBottomTop(this.modelPath(AEBlocks.CELL_WORKBENCH), AppEng.makeId("block/cell_workbench_side"), AppEng.makeId("block/cell_workbench_bottom"), AppEng.makeId("block/cell_workbench")));
        this.energyCell(AEBlocks.ENERGY_CELL, "block/energy_cell");
        this.energyCell(AEBlocks.DENSE_ENERGY_CELL, "block/dense_energy_cell");
        this.simpleBlockAndItem(AEBlocks.CREATIVE_ENERGY_CELL, "block/creative_energy_cell");
        this.vibrationChamber();
        this.spatialAnchor();
        this.patternProvider();
        this.ioPorts();
    }

    private void vibrationChamber() {
        BlockModelBuilder offModel = (BlockModelBuilder)this.models().orientable(this.modelPath(AEBlocks.VIBRATION_CHAMBER), AppEng.makeId("block/vibration_chamber"), AppEng.makeId("block/vibration_chamber_front"), AppEng.makeId("block/vibration_chamber"));
        BlockModelBuilder onModel = (BlockModelBuilder)this.models().orientable(this.modelPath(AEBlocks.VIBRATION_CHAMBER) + "_on", AppEng.makeId("block/vibration_chamber"), AppEng.makeId("block/vibration_chamber_front_on"), AppEng.makeId("block/vibration_chamber"));
        this.getVariantBuilder(AEBlocks.VIBRATION_CHAMBER.block()).partialState().with((Property)VibrationChamberBlock.ACTIVE, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)onModel)}).partialState().with((Property)VibrationChamberBlock.ACTIVE, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)offModel)});
        this.itemModels().withExistingParent(this.modelPath(AEBlocks.VIBRATION_CHAMBER), offModel.getLocation());
    }

    private void spatialAnchor() {
        BlockModelBuilder offModel = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(AEBlocks.SPATIAL_ANCHOR), AppEng.makeId("block/spatial_anchor_side_off"), AppEng.makeId("block/spatial_anchor_bottom"), AppEng.makeId("block/spatial_anchor_top_off"));
        BlockModelBuilder onModel = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(AEBlocks.SPATIAL_ANCHOR) + "_on", AppEng.makeId("block/spatial_anchor_side"), AppEng.makeId("block/spatial_anchor_bottom"), AppEng.makeId("block/spatial_anchor_top"));
        this.getVariantBuilder(AEBlocks.SPATIAL_ANCHOR.block()).partialState().with((Property)SpatialAnchorBlock.POWERED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)onModel)}).partialState().with((Property)SpatialAnchorBlock.POWERED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)offModel)});
        this.itemModels().withExistingParent(this.modelPath(AEBlocks.SPATIAL_ANCHOR), offModel.getLocation());
    }

    private void patternProvider() {
        BlockDefinition<PatternProviderBlock> def = AEBlocks.PATTERN_PROVIDER;
        ModelFile normalModel = this.cubeAll(def.block());
        this.simpleBlockItem(def.block(), normalModel);
    }

    private void ioPorts() {
        BlockModelBuilder ioOff = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(AEBlocks.IO_PORT), AppEng.makeId("block/io_port_side_off"), AppEng.makeId("block/io_port_bottom"), AppEng.makeId("block/io_port_top_off"));
        BlockModelBuilder ioOn = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(AEBlocks.IO_PORT) + "_on", AppEng.makeId("block/io_port_side"), AppEng.makeId("block/io_port_bottom"), AppEng.makeId("block/io_port_top"));
        BlockModelBuilder spatialOff = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(AEBlocks.SPATIAL_IO_PORT), AppEng.makeId("block/spatial_io_port_side_off"), AppEng.makeId("block/spatial_io_port_bottom"), AppEng.makeId("block/spatial_io_port_top_off"));
        BlockModelBuilder spatialOn = (BlockModelBuilder)this.models().cubeBottomTop(this.modelPath(AEBlocks.SPATIAL_IO_PORT) + "_on", AppEng.makeId("block/spatial_io_port_side"), AppEng.makeId("block/spatial_io_port_bottom"), AppEng.makeId("block/spatial_io_port_top"));
        this.getVariantBuilder(AEBlocks.IO_PORT.block()).partialState().with((Property)IOPortBlock.POWERED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)ioOn)}).partialState().with((Property)IOPortBlock.POWERED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)ioOff)});
        this.getVariantBuilder(AEBlocks.SPATIAL_IO_PORT.block()).partialState().with((Property)SpatialIOPortBlock.POWERED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)spatialOn)}).partialState().with((Property)SpatialIOPortBlock.POWERED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)spatialOff)});
        this.itemModels().withExistingParent(this.modelPath(AEBlocks.IO_PORT), ioOff.getLocation());
        this.itemModels().withExistingParent(this.modelPath(AEBlocks.SPATIAL_IO_PORT), spatialOff.getLocation());
    }

    private String modelPath(BlockDefinition<?> block) {
        return block.id().m_135815_();
    }

    private void emptyModel(BlockDefinition<?> block) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder(block.id().m_135815_());
        this.simpleBlockAndItem(block, (ModelFile)model);
    }

    private void builtInModel(BlockDefinition<?> block) {
        this.builtInModel(block, false);
    }

    private void builtInModel(BlockDefinition<?> block, boolean skipItem) {
        BlockModelBuilder model = this.builtInBlockModel(block.id().m_135815_());
        this.getVariantBuilder((Block)block.block()).partialState().setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
        if (!skipItem) {
            this.itemModels().getBuilder(block.id().m_135815_());
        }
    }

    private BlockModelBuilder builtInBlockModel(String name) {
        BlockModelBuilder model = (BlockModelBuilder)this.models().getBuilder("block/" + name);
        ResourceLocation loaderId = AppEng.makeId("block/" + name);
        model.customLoader((bmb, efh) -> new CustomLoaderBuilder<BlockModelBuilder>(loaderId, bmb, efh){});
        return model;
    }

    private void energyCell(BlockDefinition<?> block, String baseTexture) {
        VariantBlockStateBuilder blockBuilder = this.getVariantBuilder((Block)block.block());
        ArrayList<BlockModelBuilder> models = new ArrayList<BlockModelBuilder>();
        for (int i = 0; i < 5; ++i) {
            BlockModelBuilder model = (BlockModelBuilder)this.models().cubeAll(this.modelPath(block) + "_" + i, AppEng.makeId(baseTexture + "_" + i));
            blockBuilder.partialState().with((Property)EnergyCellBlock.ENERGY_STORAGE, (Comparable)Integer.valueOf(i)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)model)});
            models.add(model);
        }
        ItemModelBuilder item = (ItemModelBuilder)this.itemModels().withExistingParent(this.modelPath(block), ((ModelFile)models.get(0)).getLocation());
        for (int i = 1; i < models.size(); ++i) {
            float fillFactor = (float)i / (float)models.size();
            item.override().predicate(InitItemModelsProperties.ENERGY_FILL_LEVEL_ID, fillFactor).model((ModelFile)models.get(i));
        }
    }

    private void craftingModel(BlockDefinition<?> block, String name) {
        BlockModelBuilder blockModel = (BlockModelBuilder)this.models().cubeAll("block/crafting/" + name, AppEng.makeId("block/crafting/" + name));
        this.getVariantBuilder((Block)block.block()).partialState().with((Property)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(false)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)blockModel)}).partialState().with((Property)AbstractCraftingUnitBlock.FORMED, (Comparable)Boolean.valueOf(true)).setModels(new ConfiguredModel[]{new ConfiguredModel((ModelFile)this.models().getBuilder("block/crafting/" + name + "_formed"))});
        this.simpleBlockItem((Block)block.block(), (ModelFile)blockModel);
    }

    private void generateOreBlock(BlockDefinition<?> block) {
        String name = block.id().m_135815_();
        BlockModelBuilder primaryModel = (BlockModelBuilder)this.models().cubeAll(name + "_0", AppEng.makeId("block/" + name + "_0"));
        this.simpleBlock((Block)block.block(), ConfiguredModel.builder().modelFile((ModelFile)primaryModel).nextModel().modelFile((ModelFile)this.models().cubeAll(name + "_1", AppEng.makeId("block/" + name + "_1"))).nextModel().modelFile((ModelFile)this.models().cubeAll(name + "_2", AppEng.makeId("block/" + name + "_2"))).nextModel().modelFile((ModelFile)this.models().cubeAll(name + "_3", AppEng.makeId("block/" + name + "_3"))).build());
        this.simpleBlockItem((Block)block.block(), (ModelFile)primaryModel);
    }
}

