/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.model;

import appeng.client.render.DelegateBakedModel;
import appeng.client.render.FacingToRotation;
import appeng.client.render.model.AEModelData;
import appeng.client.render.model.AutoRotatingCacheKey;
import com.google.common.base.Objects;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.blaze3d.vertex.VertexFormatElement;
import com.mojang.math.Vector4f;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;
import net.minecraftforge.client.model.pipeline.BakedQuadBuilder;
import net.minecraftforge.client.model.pipeline.IVertexConsumer;
import net.minecraftforge.client.model.pipeline.QuadGatheringTransformer;

public class AutoRotatingBakedModel
extends DelegateBakedModel {
    private final BakedModel parent;
    private final LoadingCache<AutoRotatingCacheKey, List<BakedQuad>> quadCache;

    public AutoRotatingBakedModel(BakedModel parent) {
        super(parent);
        this.parent = parent;
        this.quadCache = CacheBuilder.newBuilder().maximumSize(252L).build((CacheLoader)new CacheLoader<AutoRotatingCacheKey, List<BakedQuad>>(){

            public List<BakedQuad> load(AutoRotatingCacheKey key) {
                return AutoRotatingBakedModel.this.getRotatedModel(key.getBlockState(), key.getSide(), new Random(0L), key.getModelData());
            }
        });
    }

    private List<BakedQuad> getRotatedModel(BlockState state, Direction side, Random rand, IModelData modelData) {
        FacingToRotation f2r = FacingToRotation.get((Direction)modelData.getData(AEModelData.FORWARD), (Direction)modelData.getData(AEModelData.UP));
        if (f2r.isRedundant()) {
            return this.parent.getQuads(state, side, rand, modelData);
        }
        List original = this.parent.getQuads(state, f2r.resultingRotate(side), rand, modelData);
        ArrayList<BakedQuad> rotated = new ArrayList<BakedQuad>(original.size());
        for (BakedQuad quad : original) {
            BakedQuadBuilder builder = new BakedQuadBuilder();
            VertexRotator rot = new VertexRotator(f2r, quad.m_111306_());
            rot.setParent((IVertexConsumer)builder);
            quad.pipe((IVertexConsumer)rot);
            if (quad.m_111306_() != null) {
                builder.setQuadOrientation(f2r.rotate(quad.m_111306_()));
            } else {
                builder.setQuadOrientation(null);
            }
            BakedQuad unpackedQuad = builder.build();
            BakedQuad packedQuad = new BakedQuad(unpackedQuad.m_111303_(), quad.m_111305_(), unpackedQuad.m_111306_(), quad.m_173410_(), quad.m_111307_());
            rotated.add(packedQuad);
        }
        return rotated;
    }

    @Override
    public List<BakedQuad> m_6840_(@Nullable BlockState state, @Nullable Direction side, Random rand) {
        return this.getQuads(state, side, rand, (IModelData)EmptyModelData.INSTANCE);
    }

    public List<BakedQuad> getQuads(@Nullable BlockState state, @Nullable Direction side, Random rand, IModelData extraData) {
        if (!extraData.hasProperty(AEModelData.AEMODEL)) {
            return this.parent.getQuads(state, side, rand, extraData);
        }
        if (((Boolean)extraData.getData(AEModelData.CACHEABLE)).booleanValue()) {
            return (List)this.quadCache.getUnchecked((Object)new AutoRotatingCacheKey(state, (AEModelData)extraData.getData(AEModelData.AEMODEL), side));
        }
        return this.getRotatedModel(state, side, rand, extraData);
    }

    public IModelData getModelData(BlockAndTintGetter level, BlockPos pos, BlockState state, IModelData modelData) {
        return this.parent.getModelData(level, pos, state, modelData);
    }

    public static class VertexRotator
    extends QuadGatheringTransformer {
        private final FacingToRotation f2r;
        private final Direction face;
        private static final float EPS = 1.0E-4f;

        public VertexRotator(FacingToRotation f2r, Direction face) {
            this.f2r = f2r;
            this.face = face;
        }

        public void setParent(IVertexConsumer parent) {
            super.setParent(parent);
            if (Objects.equal((Object)this.getVertexFormat(), (Object)parent.getVertexFormat())) {
                return;
            }
            this.setVertexFormat(parent.getVertexFormat());
        }

        protected void processQuad() {
            VertexFormat format = this.parent.getVertexFormat();
            ImmutableList elements = format.m_86023_();
            for (int v = 0; v < 4; ++v) {
                for (int e = 0; e < elements.size(); ++e) {
                    VertexFormatElement element = (VertexFormatElement)elements.get(e);
                    if (element.m_86048_() == VertexFormatElement.Usage.POSITION) {
                        this.parent.put(e, this.transform(this.quadData[e][v]));
                        continue;
                    }
                    if (element.m_86048_() == VertexFormatElement.Usage.NORMAL) {
                        this.parent.put(e, this.transformNormal(this.quadData[e][v]));
                        continue;
                    }
                    this.parent.put(e, this.quadData[e][v]);
                }
            }
        }

        private float[] transform(float[] fs) {
            switch (fs.length) {
                case 3: {
                    Vector4f vec = new Vector4f(fs[0], fs[1], fs[2], 1.0f);
                    vec.setX(vec.m_123601_() - 0.5f);
                    vec.setY(vec.m_123615_() - 0.5f);
                    vec.setZ(vec.m_123616_() - 0.5f);
                    vec.m_123607_(this.f2r.getMat());
                    vec.setX(vec.m_123601_() + 0.5f);
                    vec.setY(vec.m_123615_() + 0.5f);
                    vec.setZ(vec.m_123616_() + 0.5f);
                    return new float[]{VertexRotator.snap(vec.m_123601_()), VertexRotator.snap(vec.m_123615_()), VertexRotator.snap(vec.m_123616_())};
                }
                case 4: {
                    Vector4f vecc = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                    vecc.setX(vecc.m_123601_() - 0.5f);
                    vecc.setY(vecc.m_123615_() - 0.5f);
                    vecc.setZ(vecc.m_123616_() - 0.5f);
                    vecc.m_123607_(this.f2r.getMat());
                    vecc.setX(vecc.m_123601_() + 0.5f);
                    vecc.setY(vecc.m_123615_() + 0.5f);
                    vecc.setZ(vecc.m_123616_() + 0.5f);
                    return new float[]{VertexRotator.snap(vecc.m_123601_()), VertexRotator.snap(vecc.m_123615_()), VertexRotator.snap(vecc.m_123616_()), VertexRotator.snap(vecc.m_123617_())};
                }
            }
            return fs;
        }

        private static float snap(float x) {
            if (Math.abs(x) <= 1.0E-4f) {
                return 0.0f;
            }
            if (Math.abs(x - 1.0f) <= 1.0E-4f) {
                return 1.0f;
            }
            return x;
        }

        private float[] transformNormal(float[] fs) {
            if (this.face == null) {
                switch (fs.length) {
                    case 3: {
                        Vector4f vec = new Vector4f(fs[0], fs[1], fs[2], 0.0f);
                        vec.m_123607_(this.f2r.getMat());
                        return new float[]{vec.m_123601_(), vec.m_123615_(), vec.m_123616_()};
                    }
                    case 4: {
                        Vector4f vec4 = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                        vec4.m_123607_(this.f2r.getMat());
                        return new float[]{VertexRotator.snap(vec4.m_123601_()), VertexRotator.snap(vec4.m_123615_()), VertexRotator.snap(vec4.m_123616_()), 0.0f};
                    }
                }
                return fs;
            }
            switch (fs.length) {
                case 3: {
                    Vec3i vec = this.f2r.rotate(this.face).m_122436_();
                    return new float[]{vec.m_123341_(), vec.m_123342_(), vec.m_123343_()};
                }
                case 4: {
                    Vector4f veccc = new Vector4f(fs[0], fs[1], fs[2], fs[3]);
                    Vec3i vecc = this.f2r.rotate(this.face).m_122436_();
                    return new float[]{vecc.m_123341_(), vecc.m_123342_(), vecc.m_123343_(), veccc.m_123617_()};
                }
            }
            return fs;
        }

        public void setQuadTint(int tint) {
            this.parent.setQuadTint(tint);
        }

        public void setQuadOrientation(Direction orientation) {
            this.parent.setQuadOrientation(this.f2r.rotate(orientation));
        }

        public void setApplyDiffuseLighting(boolean diffuse) {
            this.parent.setApplyDiffuseLighting(diffuse);
        }

        public void setTexture(TextureAtlasSprite texture) {
            this.parent.setTexture(texture);
        }
    }
}

