/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbquests.quest.task;

import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.util.StringUtils;
import dev.ftb.mods.ftbquests.client.EnergyTaskClientData;
import dev.ftb.mods.ftbquests.quest.Quest;
import dev.ftb.mods.ftbquests.quest.task.ISingleLongValueTask;
import dev.ftb.mods.ftbquests.quest.task.Task;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class EnergyTask
extends Task
implements ISingleLongValueTask {
    public long value = 1000L;
    public long maxInput = 1000L;

    public EnergyTask(Quest quest) {
        super(quest);
    }

    @Override
    public long getMaxProgress() {
        return this.value;
    }

    @Override
    public void writeData(CompoundTag nbt) {
        super.writeData(nbt);
        nbt.m_128356_("value", this.value);
        if (this.maxInput > 0L) {
            nbt.m_128356_("max_input", this.maxInput);
        }
    }

    @Override
    public void readData(CompoundTag nbt) {
        super.readData(nbt);
        this.value = nbt.m_128454_("value");
        if (this.value < 1L) {
            this.value = 1L;
        }
        this.maxInput = nbt.m_128454_("max_input");
    }

    @Override
    public void writeNetData(FriendlyByteBuf buffer) {
        super.writeNetData(buffer);
        buffer.m_130103_(this.value);
        buffer.m_130103_(this.maxInput);
    }

    @Override
    public void readNetData(FriendlyByteBuf buffer) {
        super.readNetData(buffer);
        this.value = buffer.m_130258_();
        this.maxInput = buffer.m_130258_();
    }

    @Override
    public void setValue(long v) {
        this.value = v;
    }

    @OnlyIn(value=Dist.CLIENT)
    public MutableComponent getAltTitle() {
        return new TextComponent(StringUtils.formatDouble((double)this.value, (boolean)true));
    }

    @Override
    public boolean consumesResources() {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void getConfig(ConfigGroup config) {
        super.getConfig(config);
        config.addLong("value", this.value, v -> {
            this.value = v;
        }, 1000L, 1L, Long.MAX_VALUE);
        config.addLong("max_input", this.maxInput, v -> {
            this.maxInput = v;
        }, 1000L, 0L, Integer.MAX_VALUE).setNameKey("ftbquests.task.max_input");
    }

    public abstract EnergyTaskClientData getClientData();
}

