/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.upgrades;

import java.util.Collections;
import java.util.Comparator;
import java.util.Optional;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.nbt.StringTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.p3pp3rf1y.sophisticatedcore.upgrades.PrimaryMatch;
import net.p3pp3rf1y.sophisticatedcore.util.ItemStackHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class FilterLogicBase {
    protected final ItemStack upgrade;
    protected final Consumer<ItemStack> saveHandler;
    protected final String parentTagKey;
    private boolean allowListDefault = false;
    @Nullable
    protected Set<TagKey<Item>> tagKeys = null;

    public FilterLogicBase(ItemStack upgrade, Consumer<ItemStack> saveHandler, String parentTagKey) {
        this.upgrade = upgrade;
        this.saveHandler = saveHandler;
        this.parentTagKey = parentTagKey;
    }

    public String getParentTagKey() {
        return this.parentTagKey;
    }

    public void setAllowByDefault() {
        this.allowListDefault = true;
    }

    protected void save() {
        this.saveHandler.accept(this.upgrade);
    }

    public boolean stackMatchesFilter(ItemStack stack, ItemStack filter) {
        if (filter.m_41619_()) {
            return false;
        }
        PrimaryMatch primaryMatch = this.getPrimaryMatch();
        if (primaryMatch == PrimaryMatch.MOD ? !stack.m_41720_().getRegistryName().m_135827_().equals(filter.m_41720_().getRegistryName().m_135827_()) : primaryMatch == PrimaryMatch.ITEM && !ItemStack.m_41746_((ItemStack)stack, (ItemStack)filter)) {
            return false;
        }
        if (this.shouldMatchDurability() && stack.m_41773_() != filter.m_41773_()) {
            return false;
        }
        return !this.shouldMatchNbt() || ItemStackHelper.areItemStackTagsEqualIgnoreDurability(stack, filter);
    }

    public Set<TagKey<Item>> getTagKeys() {
        if (this.tagKeys == null) {
            this.initTags();
        }
        return Collections.unmodifiableSet(this.tagKeys);
    }

    public void addTag(TagKey<Item> tagName) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        this.tagKeys.add(tagName);
        this.serializeTags();
        this.save();
    }

    private void serializeTags() {
        if (this.tagKeys == null) {
            return;
        }
        NBTHelper.setList(this.upgrade, this.parentTagKey, "tags", this.tagKeys, t -> StringTag.m_129297_((String)t.f_203868_().toString()));
    }

    public void removeTagName(TagKey<Item> tagName) {
        if (this.tagKeys == null) {
            this.initTags();
        }
        this.tagKeys.remove(tagName);
        this.serializeTags();
        this.save();
    }

    protected void initTags() {
        this.tagKeys = NBTHelper.getCollection(this.upgrade, this.parentTagKey, "tags", (byte)8, elementNbt -> Optional.of(TagKey.m_203882_((ResourceKey)Registry.f_122904_, (ResourceLocation)new ResourceLocation(elementNbt.m_7916_()))), () -> new TreeSet<TagKey>(Comparator.comparing(TagKey::f_203868_))).orElse(new TreeSet<TagKey>(Comparator.comparing(TagKey::f_203868_)));
    }

    public void setAllowList(boolean isAllowList) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "isAllowList", isAllowList);
        this.save();
    }

    public boolean isAllowList() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "isAllowList").orElse(this.allowListDefault);
    }

    public boolean shouldMatchDurability() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchDurability").orElse(false);
    }

    public void setMatchDurability(boolean matchDurability) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchDurability", matchDurability);
        this.save();
    }

    public void setMatchNbt(boolean matchNbt) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchNbt", matchNbt);
        this.save();
    }

    public boolean shouldMatchNbt() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchNbt").orElse(false);
    }

    public void setPrimaryMatch(PrimaryMatch primaryMatch) {
        NBTHelper.setEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", primaryMatch);
        this.save();
    }

    public PrimaryMatch getPrimaryMatch() {
        return NBTHelper.getEnumConstant(this.upgrade, this.parentTagKey, "primaryMatch", PrimaryMatch::fromName).orElse(PrimaryMatch.ITEM);
    }

    public boolean shouldMatchAnyTag() {
        return NBTHelper.getBoolean(this.upgrade, this.parentTagKey, "matchAnyTag").orElse(true);
    }

    public void setMatchAnyTag(boolean matchAnyTag) {
        NBTHelper.setBoolean(this.upgrade, this.parentTagKey, "matchAnyTag", matchAnyTag);
        this.save();
    }
}

