/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.settings;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.saveddata.SavedData;
import net.minecraft.world.level.storage.DimensionDataStorage;
import net.minecraftforge.fml.util.thread.SidedThreadGroups;
import net.minecraftforge.server.ServerLifecycleHooks;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;

public class SettingsTemplateStorage
extends SavedData {
    private static final String SAVED_DATA_NAME = "sophisticatedcore_settings_templates";
    private Map<UUID, Map<Integer, CompoundTag>> playerTemplates = new HashMap<UUID, Map<Integer, CompoundTag>>();
    private static final SettingsTemplateStorage clientStorageCopy = new SettingsTemplateStorage();

    private SettingsTemplateStorage() {
    }

    private SettingsTemplateStorage(Map<UUID, Map<Integer, CompoundTag>> playerTemplates) {
        this.playerTemplates = playerTemplates;
    }

    public void putPlayerTemplate(Player player, int slot, CompoundTag settingsTag) {
        this.playerTemplates.computeIfAbsent(player.m_142081_(), u -> new HashMap()).put(slot, settingsTag);
        this.m_77762_();
    }

    public Map<Integer, CompoundTag> getPlayerTemplates(Player player) {
        return this.playerTemplates.getOrDefault(player.m_142081_(), new HashMap());
    }

    public CompoundTag m_7176_(CompoundTag tag) {
        NBTHelper.putMap(tag, "playerTemplates", this.playerTemplates, UUID::toString, slotTemplates -> NBTHelper.putMap(new CompoundTag(), "slotTemplates", slotTemplates, String::valueOf, settingsTag -> settingsTag));
        return tag;
    }

    public static SettingsTemplateStorage get() {
        MinecraftServer server;
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            ServerLevel overworld = server.m_129880_(Level.f_46428_);
            DimensionDataStorage storage = overworld.m_8895_();
            return (SettingsTemplateStorage)storage.m_164861_(SettingsTemplateStorage::load, SettingsTemplateStorage::new, SAVED_DATA_NAME);
        }
        return clientStorageCopy;
    }

    private static SettingsTemplateStorage load(CompoundTag tag) {
        return new SettingsTemplateStorage(NBTHelper.getMap(tag, "playerTemplates", UUID::fromString, (key, playerTemplatesTag) -> NBTHelper.getMap((CompoundTag)playerTemplatesTag, "slotTemplates", Integer::valueOf, (k, settingsTag) -> Optional.of((CompoundTag)settingsTag))).orElse(new HashMap()));
    }
}

