/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedcore.common.gui;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.util.Pair;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.ContainerListener;
import net.minecraft.world.inventory.ContainerSynchronizer;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.HighStackCountSynchronizer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.IAdditionalSlotInfoMenu;
import net.p3pp3rf1y.sophisticatedcore.common.gui.ISyncedContainer;
import net.p3pp3rf1y.sophisticatedcore.common.gui.StorageContainerMenuBase;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.network.PacketHandler;
import net.p3pp3rf1y.sophisticatedcore.network.SyncAdditionalSlotInfoMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncContainerClientDataMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncEmptySlotIconsMessage;
import net.p3pp3rf1y.sophisticatedcore.network.SyncTemplateSettingsMessage;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.ISettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsContainerBase;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsTemplateStorage;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.main.MainSettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsContainer;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedcore.util.NoopStorageWrapper;

public abstract class SettingsContainerMenu<S extends IStorageWrapper>
extends AbstractContainerMenu
implements ISyncedContainer,
IAdditionalSlotInfoMenu {
    private static final Map<String, ISettingsContainerFactory<?, ?>> SETTINGS_CONTAINER_FACTORIES = new HashMap();
    private static final String ACTION_TAG = "action";
    protected final Player player;
    protected final S storageWrapper;
    private final List<Slot> storageInventorySlots = new ArrayList<Slot>();
    public final NonNullList<ItemStack> lastGhostSlots = NonNullList.m_122779_();
    public final NonNullList<ItemStack> remoteGhostSlots = NonNullList.m_122779_();
    private final Map<String, SettingsContainerBase<?>> settingsContainers = new LinkedHashMap();
    public final List<Slot> ghostSlots = new ArrayList<Slot>();
    private boolean inventorySlotStackChanged = false;
    private final Set<Integer> inaccessibleSlots = new HashSet<Integer>();
    private final Map<Integer, ItemStack> slotFilterItems = new HashMap<Integer, ItemStack>();
    private final Map<Integer, Pair<ResourceLocation, ResourceLocation>> emptySlotIcons = new HashMap<Integer, Pair<ResourceLocation, ResourceLocation>>();
    @Nullable
    private TemplateSettingsHandler selectedTemplate;

    protected SettingsContainerMenu(MenuType<?> menuType, int windowId, Player player, S storageWrapper) {
        super(menuType, windowId);
        this.player = player;
        this.storageWrapper = storageWrapper;
        this.addStorageInventorySlots();
        this.addSettingsContainers();
    }

    public int getNumberOfStorageInventorySlots() {
        return this.storageWrapper.getInventoryHandler().getSlots();
    }

    public S getStorageWrapper() {
        return this.storageWrapper;
    }

    private void addSettingsContainers() {
        SettingsHandler settingsHandler = this.storageWrapper.getSettingsHandler();
        settingsHandler.getSettingsCategories().forEach((name, category) -> this.settingsContainers.put((String)name, SettingsContainerMenu.instantiateContainer(this, name, category)));
    }

    private void addStorageInventorySlots() {
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        int slotIndex = 0;
        while (slotIndex < inventoryHandler.getSlots()) {
            int finalSlotIndex = slotIndex++;
            this.storageInventorySlots.add(this.m_38897_((Slot)new ViewOnlyStorageInventorySlot((IItemHandler)inventoryHandler, finalSlotIndex)));
        }
    }

    public int getColumnsTaken() {
        return this.storageWrapper.getColumnsTaken();
    }

    protected Slot m_38897_(Slot slot) {
        slot.f_40219_ = this.ghostSlots.size();
        this.ghostSlots.add(slot);
        this.lastGhostSlots.add((Object)ItemStack.f_41583_);
        this.remoteGhostSlots.add((Object)ItemStack.f_41583_);
        return slot;
    }

    public void m_38946_() {
        for (int slot = 0; slot < this.ghostSlots.size(); ++slot) {
            ItemStack itemstack = this.ghostSlots.get(slot).m_7993_();
            com.google.common.base.Supplier supplier = Suppliers.memoize(() -> ((ItemStack)itemstack).m_41777_());
            this.triggerSlotListeners(slot, itemstack, (Supplier<ItemStack>)supplier);
            this.synchronizeSlotToRemote(slot, itemstack, (Supplier<ItemStack>)supplier);
        }
        if (this.inventorySlotStackChanged) {
            this.inventorySlotStackChanged = false;
            this.sendAdditionalSlotInfo();
        }
    }

    public void m_182423_() {
        for (int slotIndex = 0; slotIndex < this.ghostSlots.size(); ++slotIndex) {
            ItemStack itemstack = this.ghostSlots.get(slotIndex).m_7993_();
            this.triggerSlotListeners(slotIndex, itemstack, () -> ((ItemStack)itemstack).m_41777_());
        }
        this.m_150429_();
    }

    private void triggerSlotListeners(int slotIndex, ItemStack slotStack, Supplier<ItemStack> slotStackCopy) {
        ItemStack itemstack = (ItemStack)this.lastGhostSlots.get(slotIndex);
        if (!ItemStack.m_41728_((ItemStack)itemstack, (ItemStack)slotStack)) {
            boolean clientStackChanged = !slotStack.equals(itemstack, true);
            ItemStack itemstack1 = slotStackCopy.get();
            this.lastGhostSlots.set(slotIndex, (Object)itemstack1);
            if (clientStackChanged) {
                for (ContainerListener containerlistener : this.f_38848_) {
                    containerlistener.m_7934_((AbstractContainerMenu)this, slotIndex, itemstack1);
                }
            }
        }
    }

    private void synchronizeSlotToRemote(int slotIndex, ItemStack slotStack, Supplier<ItemStack> slotStackCopy) {
        ItemStack remoteStack;
        if (!this.f_150398_ && !ItemStack.m_41728_((ItemStack)(remoteStack = (ItemStack)this.remoteGhostSlots.get(slotIndex)), (ItemStack)slotStack)) {
            ItemStack stackCopy = slotStackCopy.get();
            this.remoteGhostSlots.set(slotIndex, (Object)stackCopy);
            if (remoteStack.m_41619_() || slotStack.m_41619_()) {
                this.inventorySlotStackChanged = true;
            }
            if (this.f_150397_ != null) {
                this.f_150397_.m_142074_((AbstractContainerMenu)this, slotIndex, stackCopy);
            }
        }
    }

    public int getNumberOfSlots() {
        return this.storageWrapper.getInventoryHandler().getSlots();
    }

    public void m_150429_() {
        Player player;
        for (int slotIndex = 0; slotIndex < this.ghostSlots.size(); ++slotIndex) {
            this.remoteGhostSlots.set(slotIndex, (Object)this.ghostSlots.get(slotIndex).m_7993_().m_41777_());
        }
        if (this.f_150397_ != null) {
            this.f_150397_.m_142589_((AbstractContainerMenu)this, this.remoteGhostSlots, this.f_150396_, new int[0]);
        }
        if ((player = this.player) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            PacketHandler.INSTANCE.sendToClient(serverPlayer, new SyncTemplateSettingsMessage(SettingsTemplateStorage.get().getPlayerTemplates((Player)serverPlayer)));
        }
        this.sendEmptySlotIcons();
        this.sendAdditionalSlotInfo();
    }

    public abstract void detectSettingsChangeAndReload();

    public void m_150416_(ContainerSynchronizer synchronizer) {
        Player player = this.player;
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            if (this.storageWrapper.getInventoryHandler().getStackSizeMultiplier() > 1) {
                super.m_150416_((ContainerSynchronizer)new HighStackCountSynchronizer(serverPlayer));
                return;
            }
        }
        super.m_150416_(synchronizer);
    }

    public Slot m_38853_(int slotId) {
        return this.ghostSlots.get(slotId);
    }

    public void onMemorizedStackAdded(int slotNumber) {
        this.storageWrapper.getInventoryHandler().onSlotFilterChanged(slotNumber);
        this.sendAdditionalSlotInfo();
    }

    public void onMemorizedStackRemoved(int slotNumber) {
        if (this.m_38853_(slotNumber).m_7993_().m_41619_()) {
            this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).itemChanged(slotNumber);
            this.storageWrapper.getInventoryHandler().onSlotFilterChanged(slotNumber);
            this.sendAdditionalSlotInfo();
        }
    }

    public void onMemorizedItemsChanged() {
        this.storageWrapper.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).itemsChanged();
    }

    public boolean m_6875_(Player player) {
        return true;
    }

    public List<Slot> getStorageInventorySlots() {
        return this.storageInventorySlots;
    }

    @Override
    public void handleMessage(CompoundTag data) {
        if (data.m_128441_("categoryName")) {
            String categoryName = data.m_128461_("categoryName");
            if (this.settingsContainers.containsKey(categoryName)) {
                this.settingsContainers.get(categoryName).handleMessage(data);
            }
        } else if (data.m_128425_(ACTION_TAG, 8)) {
            String action = data.m_128461_(ACTION_TAG);
            if (action.equals("saveTemplate")) {
                this.saveTemplate(data.m_128451_("slot"));
            } else if (action.equals("loadTemplate")) {
                this.loadTemplate();
            }
        }
    }

    public void m_150399_(int slotId, int dragType, ClickType clickTypeIn, Player player) {
    }

    public void forEachSettingsContainer(BiConsumer<String, ? super SettingsContainerBase<?>> consumer) {
        this.settingsContainers.forEach(consumer);
    }

    public Player getPlayer() {
        return this.player;
    }

    public BlockPos getBlockPosition() {
        return BlockPos.f_121853_;
    }

    public void saveTemplate(int saveSlot) {
        SettingsTemplateStorage.get().putPlayerTemplate(this.player, saveSlot, this.storageWrapper.getSettingsHandler().getNbt().m_6426_());
        this.sendDataToServer(() -> {
            CompoundTag tag = NBTHelper.putString(new CompoundTag(), ACTION_TAG, "saveTemplate");
            tag.m_128405_("slot", saveSlot);
            return tag;
        });
    }

    public void loadTemplate() {
        if (this.selectedTemplate == null) {
            return;
        }
        this.storageWrapper.getSettingsHandler().getSettingsCategories().values().forEach(category -> this.overwriteCategory(category.getClass(), (ISettingsCategory<?>)category, (ISettingsCategory<?>)this.selectedTemplate.getTypeCategory(category.getClass())));
        this.sendDataToServer(() -> NBTHelper.putString(new CompoundTag(), ACTION_TAG, "loadTemplate"));
    }

    private <T extends ISettingsCategory<T>> void overwriteCategory(Class<T> categoryClazz, ISettingsCategory<?> currentCategory, ISettingsCategory<?> otherCategory) {
        currentCategory.overwriteWith(otherCategory);
    }

    public <T extends ISettingsCategory<?>> Optional<T> getSelectedTemplatesCategory(Class<T> categoryClass) {
        return this.selectedTemplate != null ? Optional.of(this.selectedTemplate.getTypeCategory(categoryClass)) : Optional.empty();
    }

    public int getNumberOfRows() {
        return this.storageWrapper.getNumberOfSlotRows();
    }

    protected static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> void addFactory(String categoryName, ISettingsContainerFactory<C, T> factory) {
        SETTINGS_CONTAINER_FACTORIES.put(categoryName, factory);
    }

    private static <C extends ISettingsCategory> SettingsContainerBase<C> instantiateContainer(SettingsContainerMenu<?> settingsContainer, String name, C category) {
        return SettingsContainerMenu.getSettingsContainerFactory(name).create(settingsContainer, name, category);
    }

    private static <C extends ISettingsCategory, T extends SettingsContainerBase<C>> ISettingsContainerFactory<C, T> getSettingsContainerFactory(String name) {
        return SETTINGS_CONTAINER_FACTORIES.get(name);
    }

    public void updateSelectedTemplate(@Nullable CompoundTag settingsTag) {
        this.selectedTemplate = settingsTag == null ? null : new TemplateSettingsHandler(settingsTag){

            @Override
            protected SettingsHandler getCurrentSettingsHandler() {
                return SettingsContainerMenu.this.storageWrapper.getSettingsHandler();
            }
        };
    }

    public void sendDataToServer(Supplier<CompoundTag> supplyData) {
        if (this.isServer()) {
            return;
        }
        CompoundTag data = supplyData.get();
        PacketHandler.INSTANCE.sendToServer(new SyncContainerClientDataMessage(data));
    }

    protected boolean isServer() {
        return !this.player.f_19853_.f_46443_;
    }

    public void sendAdditionalSlotInfo() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        HashSet<Integer> inaccessibleSlots = new HashSet<Integer>();
        InventoryHandler inventoryHandler = this.storageWrapper.getInventoryHandler();
        HashMap<Integer, Item> slotFilterItems = new HashMap<Integer, Item>();
        for (int slot = 0; slot < inventoryHandler.getSlots(); ++slot) {
            if (!inventoryHandler.isSlotAccessible(slot)) {
                inaccessibleSlots.add(slot);
            }
            if (inventoryHandler.getFilterItem(slot) == Items.f_41852_) continue;
            slotFilterItems.put(slot, inventoryHandler.getFilterItem(slot));
        }
        PacketHandler.INSTANCE.sendToClient(serverPlayer, new SyncAdditionalSlotInfoMessage(inaccessibleSlots, Map.of(), slotFilterItems));
    }

    @Override
    public void updateAdditionalSlotInfo(Set<Integer> inaccessibleSlots, Map<Integer, Integer> slotLimitOverrides, Map<Integer, Item> slotFilterItems) {
        this.inaccessibleSlots.clear();
        this.inaccessibleSlots.addAll(inaccessibleSlots);
        this.slotFilterItems.clear();
        slotFilterItems.forEach((slot, item) -> this.slotFilterItems.put((Integer)slot, new ItemStack((ItemLike)item)));
    }

    @Override
    public void updateEmptySlotIcons(Map<ResourceLocation, Set<Integer>> emptySlotIcons) {
        this.emptySlotIcons.clear();
        emptySlotIcons.forEach((textureName, slots) -> slots.forEach(slot -> this.emptySlotIcons.put((Integer)slot, (Pair<ResourceLocation, ResourceLocation>)new Pair((Object)InventoryMenu.f_39692_, textureName))));
    }

    public void m_182414_(int slot, ItemStack stack) {
        ItemStack previous = this.m_38853_(slot).m_7993_();
        super.m_182414_(slot, stack);
        if (previous.m_41619_() || stack.m_41619_()) {
            this.inventorySlotStackChanged = true;
        }
    }

    private void sendEmptySlotIcons() {
        Player player = this.player;
        if (!(player instanceof ServerPlayer)) {
            return;
        }
        ServerPlayer serverPlayer = (ServerPlayer)player;
        HashMap<ResourceLocation, Set<Integer>> noItemSlotTextures = new HashMap<ResourceLocation, Set<Integer>>();
        for (int slot = 0; slot < this.storageWrapper.getInventoryHandler().getSlots(); ++slot) {
            Pair<ResourceLocation, ResourceLocation> noItemIcon = this.storageWrapper.getInventoryHandler().getNoItemIcon(slot);
            if (noItemIcon == null) continue;
            noItemSlotTextures.computeIfAbsent((ResourceLocation)noItemIcon.getSecond(), rl -> new HashSet()).add(slot);
        }
        PacketHandler.INSTANCE.sendToClient(serverPlayer, new SyncEmptySlotIconsMessage(noItemSlotTextures));
    }

    public ItemStack getSlotFilterItem(int slot) {
        return this.slotFilterItems.getOrDefault(slot, ItemStack.f_41583_);
    }

    static {
        SettingsContainerMenu.addFactory("global", MainSettingsContainer::new);
        SettingsContainerMenu.addFactory("no_sort", NoSortSettingsContainer::new);
        SettingsContainerMenu.addFactory("memory", MemorySettingsContainer::new);
        SettingsContainerMenu.addFactory("item_display", ItemDisplaySettingsContainer::new);
    }

    private class ViewOnlyStorageInventorySlot
    extends SlotItemHandler {
        public ViewOnlyStorageInventorySlot(IItemHandler inventoryHandler, int slotIndex) {
            super(inventoryHandler, slotIndex, 0, 0);
        }

        public boolean m_8010_(Player playerIn) {
            return false;
        }

        @Nullable
        public Pair<ResourceLocation, ResourceLocation> m_7543_() {
            return SettingsContainerMenu.this.inaccessibleSlots.contains(this.getSlotIndex()) ? StorageContainerMenuBase.INACCESSIBLE_SLOT_BACKGROUND : (Pair)SettingsContainerMenu.this.emptySlotIcons.getOrDefault(this.getSlotIndex(), null);
        }
    }

    private static abstract class TemplateSettingsHandler
    extends SettingsHandler {
        protected TemplateSettingsHandler(CompoundTag contentsNbt) {
            super(contentsNbt, () -> {}, NoopStorageWrapper.INSTANCE::getInventoryHandler, NoopStorageWrapper.INSTANCE::getRenderInfo);
        }

        protected abstract SettingsHandler getCurrentSettingsHandler();

        @Override
        protected CompoundTag getSettingsNbtFromContentsNbt(CompoundTag contentsNbt) {
            return contentsNbt;
        }

        @Override
        protected void addItemDisplayCategory(Supplier<InventoryHandler> inventoryHandlerSupplier, Supplier<RenderInfo> renderInfoSupplier, CompoundTag settingsNbt) {
            int itemNumberLimit = this.getCurrentSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class).getItemNumberLimit();
            this.addSettingsCategory(settingsNbt, "item_display", this.markContentsDirty, (categoryNbt, saveNbt) -> new ItemDisplaySettingsCategory(inventoryHandlerSupplier, renderInfoSupplier, (CompoundTag)categoryNbt, (Consumer<CompoundTag>)saveNbt, itemNumberLimit, () -> this.getTypeCategory(MemorySettingsCategory.class)));
        }

        @Override
        public String getGlobalSettingsCategoryName() {
            return this.getCurrentSettingsHandler().getGlobalSettingsCategoryName();
        }

        @Override
        public ISettingsCategory<?> instantiateGlobalSettingsCategory(CompoundTag categoryNbt, Consumer<CompoundTag> saveNbt) {
            return this.getCurrentSettingsHandler().instantiateGlobalSettingsCategory(categoryNbt, saveNbt);
        }

        @Override
        protected void saveCategoryNbt(CompoundTag settingsNbt, String categoryName, CompoundTag tag) {
        }
    }

    public static interface ISettingsContainerFactory<C extends ISettingsCategory, T extends SettingsContainerBase<C>> {
        public T create(SettingsContainerMenu<?> var1, String var2, C var3);
    }
}

