/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.util;

import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.util.TextUtil;
import com.mojang.blaze3d.platform.InputConstants;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.function.BooleanSupplier;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.BaseComponent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;

public final class GuiUtil {
    private GuiUtil() {
    }

    public static int fillColorAlpha(int color) {
        return 0xFF000000 | color;
    }

    public static void renderText(PoseStack stack, String text, ANCHOR anchor, int x, int y, float scale, int color) {
        stack.m_85836_();
        stack.m_85837_((double)x, (double)y, 0.0);
        stack.m_85841_(scale, scale, 1.0f);
        int xOffset = 0;
        int yOffset = 0;
        Font font = Minecraft.m_91087_().f_91062_;
        int width = font.m_92895_(text);
        Objects.requireNonNull(font);
        int height = 9;
        switch (anchor) {
            case TOP_LEFT: {
                break;
            }
            case TOP_RIGHT: {
                xOffset -= width;
                break;
            }
            case BOTTOM_LEFT: {
                yOffset -= height;
                break;
            }
            case BOTTOM_RIGHT: {
                xOffset -= width;
                yOffset -= height;
            }
        }
        font.m_92883_(stack, text, (float)xOffset, (float)yOffset, color);
        stack.m_85849_();
    }

    public static enum ANCHOR {
        TOP_LEFT,
        TOP_RIGHT,
        BOTTOM_LEFT,
        BOTTOM_RIGHT;

    }

    public static final class Tooltip {
        private final List<GenericComponent> components = new ArrayList<GenericComponent>();

        private Tooltip() {
        }

        public static Tooltip builder() {
            return new Tooltip();
        }

        public List<Component> build() {
            ArrayList<Component> list = new ArrayList<Component>();
            for (GenericComponent component : this.components) {
                component.resolve(list);
            }
            return list;
        }

        public Tooltip blank() {
            return this.component((Component)new TextComponent(" "), new Supplier[0]);
        }

        public Tooltip blank(BooleanSupplier condition) {
            return this.component((Component)new ConditionComponent(condition, (Component)new TextComponent(" "), new Supplier[0]), new Supplier[0]);
        }

        public Tooltip title(String key, Supplier<?> ... replacements) {
            return this.component((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GOLD), replacements);
        }

        public Tooltip title(BooleanSupplier condition, String key, Supplier<?> ... replacements) {
            return this.component((Component)new ConditionComponent(condition, (Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GOLD), replacements), new Supplier[0]);
        }

        public Tooltip line(String key, Supplier<?> ... replacements) {
            return this.component((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.WHITE), replacements);
        }

        public Tooltip line(String key, ChatFormatting color, Supplier<?> ... replacements) {
            return this.component((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, color), replacements);
        }

        public Tooltip line(BooleanSupplier condition, String key, Supplier<?> ... replacements) {
            return this.component((Component)new ConditionComponent(condition, (Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.WHITE), replacements), new Supplier[0]);
        }

        public Tooltip line(BooleanSupplier condition, String key, ChatFormatting color, Supplier<?> ... replacements) {
            return this.component((Component)new ConditionComponent(condition, (Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, color), replacements), new Supplier[0]);
        }

        public Tooltip lineEnum(TypeEnums.TRANSLATE_TYPE type, ChatFormatting color, Enum<?> e) {
            return this.component((Component)TextUtil.translate(type, e.toString().toLowerCase(), color), new Supplier[0]);
        }

        public Tooltip keyValue(String key, Supplier<?> ... replacements) {
            return this.component((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, TextUtil.f("{}.key", key), ChatFormatting.GREEN).m_7220_((Component)TextUtil.colorize(": ", ChatFormatting.GREEN)).m_7220_((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, TextUtil.f("{}.value", key), ChatFormatting.WHITE)), replacements);
        }

        public Tooltip keyValue(BooleanSupplier condition, String key, Supplier<?> ... replacements) {
            return this.component((Component)new ConditionComponent(condition, (Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, TextUtil.f("{}.key", key), ChatFormatting.GREEN).m_7220_((Component)TextUtil.colorize(": ", ChatFormatting.GREEN)).m_7220_((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, TextUtil.f("{}.value", key), ChatFormatting.WHITE)), replacements), new Supplier[0]);
        }

        public Tooltip keyEnum(String key, TypeEnums.TRANSLATE_TYPE type, Supplier<Enum<?>> e) {
            return this.component((Component)new EnumComponent((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GREEN).m_7220_((Component)TextUtil.colorize(": ", ChatFormatting.GREEN)).m_7220_(TextComponent.f_131282_), type, e), new Supplier[0]);
        }

        public Tooltip clickAction(String key, Supplier<?> ... replacements) {
            return this.component((Component)TextUtil.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_click", ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)), replacements);
        }

        public Tooltip shiftClickAction(String key, Supplier<?> ... replacements) {
            return this.component((Component)TextUtil.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtil.colorize(String.format("%s + %s", InputConstants.m_84851_((String)"key.keyboard.left.shift").m_84875_().getString(), TextUtil.translateAsString(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_click")), ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)), replacements);
        }

        public Tooltip hotkeyAction(String hotkey, String key, Supplier<?> ... replacements) {
            return this.component((Component)TextUtil.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtil.colorize(InputConstants.m_84851_((String)hotkey).m_84875_().getString(), ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)), replacements);
        }

        public Tooltip hotkeyHoldAction(String hotkey, String key, Supplier<?> ... replacements) {
            return this.component((Component)TextUtil.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_hold", ChatFormatting.GRAY)).m_130946_(" ").m_7220_((Component)TextUtil.colorize(InputConstants.m_84851_((String)hotkey).m_84875_().getString(), ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)), replacements);
        }

        public Tooltip hotkeyHoldAction(BooleanSupplier condition, String hotkey, String key, Supplier<?> ... replacements) {
            return this.component((Component)new ConditionComponent(condition, (Component)TextUtil.colorize("> ", ChatFormatting.GRAY).m_7220_((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, "action_hold", ChatFormatting.GRAY)).m_130946_(" ").m_7220_((Component)TextUtil.colorize(InputConstants.m_84851_((String)hotkey).m_84875_().getString(), ChatFormatting.AQUA)).m_130946_(" ").m_7220_((Component)TextUtil.translate(TypeEnums.TRANSLATE_TYPE.TOOLTIP, key, ChatFormatting.GRAY)), replacements), new Supplier[0]);
        }

        public Tooltip shiftForInfo() {
            return this.hotkeyHoldAction(() -> !Screen.m_96638_(), "key.keyboard.left.shift", "extended_info", new Supplier[0]);
        }

        public Tooltip conditional(Consumer<? super LogicComponentNew> logicBuilder) {
            LogicComponentNew logic = new LogicComponentNew();
            logicBuilder.accept(logic);
            logic.validate();
            return this.component((Component)logic, new Supplier[0]);
        }

        private Tooltip component(Component component, Supplier<?> ... replacements) {
            if (component instanceof GenericComponent) {
                GenericComponent genericComponent = (GenericComponent)component;
                if (replacements.length > 0) {
                    throw new IllegalArgumentException("Cannot apply replacements to a generic component");
                }
                this.components.add(genericComponent);
            } else {
                this.components.add(new TooltipComponentNew(component, replacements));
            }
            return this;
        }

        private static abstract class GenericComponent
        extends BaseComponent {
            private GenericComponent() {
            }

            abstract void resolve(List<? super Component> var1);
        }

        private static final class ConditionComponent
        extends TooltipComponentNew {
            private final BooleanSupplier condition;

            private ConditionComponent(BooleanSupplier condition, Component component, Supplier<?> ... replacements) {
                super(component, replacements);
                this.condition = condition;
            }

            @Override
            void resolve(List<? super Component> tooltip) {
                if (!this.condition.getAsBoolean()) {
                    return;
                }
                super.resolve(tooltip);
            }
        }

        private static final class EnumComponent
        extends TooltipComponentNew {
            private final TypeEnums.TRANSLATE_TYPE type;

            private EnumComponent(Component component, TypeEnums.TRANSLATE_TYPE type, Supplier<Enum<?>> e) {
                super(component, e);
                this.type = type;
            }

            @Override
            public void resolve(List<? super Component> tooltip) {
                this.component.m_7360_().set(1, TextUtil.translate(this.type, this.replacements[0].get().toString().toLowerCase(), ChatFormatting.WHITE));
                tooltip.add((Component)this.component.m_6881_());
            }
        }

        public static final class LogicComponentNew
        extends GenericComponent {
            private BooleanSupplier condition;
            private Tooltip then;
            private Tooltip otherwise;

            private LogicComponentNew() {
            }

            public BaseComponent m_6879_() {
                return new TextComponent((this.condition.getAsBoolean() ? this.then : this.otherwise).build().toString());
            }

            public LogicComponentNew condition(BooleanSupplier condition) {
                assert (this.condition == null) : "condition already set";
                this.condition = condition;
                return this;
            }

            public LogicComponentNew then(Tooltip then) {
                assert (this.then == null) : "then condition already set";
                this.then = then;
                return this;
            }

            public LogicComponentNew otherwise(Tooltip otherwise) {
                assert (this.otherwise == null) : "otherwise condition already set";
                this.otherwise = otherwise;
                return this;
            }

            @Override
            public void resolve(List<? super Component> tooltip) {
                if (this.condition.getAsBoolean()) {
                    tooltip.addAll(this.then.build());
                } else {
                    tooltip.addAll(this.otherwise.build());
                }
            }

            private void validate() {
                assert (this.condition != null) : "condition not set";
                assert (this.then != null) : "then case not set";
                assert (this.otherwise != null) : "otherwise case not set";
            }
        }

        private static class TooltipComponentNew
        extends GenericComponent {
            final Component component;
            final Supplier<?>[] replacements;

            TooltipComponentNew(Component component, Supplier<?> ... replacements) {
                if (replacements.length > 0 && !(component instanceof TranslatableComponent)) {
                    throw new IllegalArgumentException("Replacements can only be applied to translatable components");
                }
                this.component = component;
                this.replacements = replacements;
            }

            public BaseComponent m_6879_() {
                return new TextComponent(this.component.getString());
            }

            @Override
            void resolve(List<? super Component> tooltip) {
                if (this.replacements.length > 0) {
                    tooltip.add((Component)this.handleReplacements((TranslatableComponent)this.component));
                    return;
                }
                tooltip.add((Component)this.component);
            }

            private TranslatableComponent handleReplacements(TranslatableComponent translateComponent) {
                List componentSiblings = translateComponent.m_7360_();
                for (int i = 0; i < componentSiblings.size(); ++i) {
                    Component sibling = (Component)componentSiblings.get(i);
                    if (!(sibling instanceof TranslatableComponent)) continue;
                    TranslatableComponent translateSibling = (TranslatableComponent)sibling;
                    componentSiblings.set(i, this.handleReplacements(translateSibling));
                }
                TranslatableComponent newComponent = new TranslatableComponent(translateComponent.m_131328_(), Arrays.stream(this.replacements).map(Supplier::get).toArray());
                newComponent.m_7360_().addAll(componentSiblings);
                newComponent.m_130948_(translateComponent.m_7383_());
                return newComponent;
            }
        }
    }
}

