/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.recipe.type;

import com.almostreliable.lazierae2.content.processor.ProcessorType;
import com.almostreliable.lazierae2.recipe.property.IRecipeInputProvider;
import com.almostreliable.lazierae2.recipe.property.IRecipeOutputProvider;
import com.almostreliable.lazierae2.util.TextUtil;
import java.util.List;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.common.crafting.conditions.ICondition;

public abstract class ProcessorRecipe
implements Recipe<Container> {
    private final ResourceLocation recipeId;
    private final ProcessorType processorType;
    private final List<ICondition> conditions;
    private final IRecipeOutputProvider output;
    private final NonNullList<IRecipeInputProvider> inputs;
    private final int processTime;
    private final int energyCost;

    ProcessorRecipe(ResourceLocation recipeId, ProcessorType processorType, List<ICondition> conditions, IRecipeOutputProvider output, NonNullList<IRecipeInputProvider> inputs, int processTime, int energyCost) {
        this.recipeId = recipeId;
        this.processorType = processorType;
        this.conditions = conditions;
        this.output = output;
        this.inputs = inputs;
        this.processTime = processTime == 0 ? processorType.getBaseProcessTime() : processTime;
        this.energyCost = energyCost == 0 ? processorType.getBaseEnergyCost() : energyCost;
        this.validateInputs();
    }

    public ItemStack m_5874_(Container inv) {
        return this.output.stack().m_41777_();
    }

    public boolean m_8004_(int width, int height) {
        return false;
    }

    public ItemStack m_8043_() {
        return this.output.stack();
    }

    public boolean m_5598_() {
        return true;
    }

    public ResourceLocation m_6423_() {
        return this.recipeId;
    }

    public RecipeSerializer<?> m_7707_() {
        return this.processorType.getRecipeSerializer();
    }

    public RecipeType<?> m_6671_() {
        return this.processorType;
    }

    private void validateInputs() {
        if (this.inputs.isEmpty()) {
            throw new IllegalArgumentException(TextUtil.f("No inputs for recipe type '{}' with output '{}'!", this.processorType.getId(), this.output.toString()));
        }
        if (this.inputs.size() > this.processorType.getInputSlots()) {
            throw new IllegalArgumentException(TextUtil.f("Too many inputs for recipe type '{}' with output '{}'!", this.processorType.getId(), this.output.toString()));
        }
    }

    public IRecipeOutputProvider getOutput() {
        return this.output;
    }

    public List<ICondition> getConditions() {
        return this.conditions;
    }

    public int getProcessTime() {
        return this.processTime;
    }

    public int getEnergyCost() {
        return this.energyCost;
    }

    public NonNullList<IRecipeInputProvider> getInputs() {
        return this.inputs;
    }
}

