/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.network.packets;

import com.almostreliable.lazierae2.network.ServerToClientPacket;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.function.Consumer;
import net.minecraft.network.FriendlyByteBuf;

public class MenuSyncPacket
extends ServerToClientPacket<MenuSyncPacket> {
    private int menuId;
    private FriendlyByteBuf data;

    public MenuSyncPacket(int menuId, Consumer<? super FriendlyByteBuf> writer) {
        this.menuId = menuId;
        this.data = new FriendlyByteBuf(Unpooled.buffer());
        writer.accept((FriendlyByteBuf)this.data);
    }

    public MenuSyncPacket() {
    }

    @Override
    public void encode(MenuSyncPacket packet, FriendlyByteBuf buffer) {
        buffer.writeInt(packet.menuId);
        buffer.writeInt(packet.data.readableBytes());
        buffer.writeBytes((ByteBuf)packet.data, packet.data.readableBytes());
    }

    @Override
    public MenuSyncPacket decode(FriendlyByteBuf buffer) {
        MenuSyncPacket packet = new MenuSyncPacket();
        packet.menuId = buffer.readInt();
        int length = buffer.readInt();
        packet.data = new FriendlyByteBuf(buffer.readBytes(length));
        return packet;
    }

    public int getMenuId() {
        return this.menuId;
    }

    public FriendlyByteBuf getData() {
        return this.data;
    }
}

