/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.network;

import com.almostreliable.lazierae2.network.IPacket;
import com.almostreliable.lazierae2.network.packets.AutoExtractPacket;
import com.almostreliable.lazierae2.network.packets.EnergyDumpPacket;
import com.almostreliable.lazierae2.network.packets.MenuSyncPacket;
import com.almostreliable.lazierae2.network.packets.RequestBatchPacket;
import com.almostreliable.lazierae2.network.packets.RequestCountPacket;
import com.almostreliable.lazierae2.network.packets.RequestStackPacket;
import com.almostreliable.lazierae2.network.packets.RequestStatePacket;
import com.almostreliable.lazierae2.network.packets.SideConfigPacket;
import com.almostreliable.lazierae2.util.TextUtil;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public final class PacketHandler {
    private static final ResourceLocation ID = TextUtil.getRL("network");
    private static final String PROTOCOL = "1";
    public static final SimpleChannel CHANNEL = NetworkRegistry.ChannelBuilder.named((ResourceLocation)ID).networkProtocolVersion(() -> "1").clientAcceptedVersions("1"::equals).serverAcceptedVersions("1"::equals).simpleChannel();

    private PacketHandler() {
    }

    public static void init() {
        int packetId = -1;
        PacketHandler.register(++packetId, AutoExtractPacket.class, new AutoExtractPacket());
        PacketHandler.register(++packetId, EnergyDumpPacket.class, new EnergyDumpPacket());
        PacketHandler.register(++packetId, RequestBatchPacket.class, new RequestBatchPacket());
        PacketHandler.register(++packetId, RequestCountPacket.class, new RequestCountPacket());
        PacketHandler.register(++packetId, RequestStatePacket.class, new RequestStatePacket());
        PacketHandler.register(++packetId, SideConfigPacket.class, new SideConfigPacket());
        PacketHandler.register(++packetId, RequestStackPacket.class, new RequestStackPacket());
        PacketHandler.register(++packetId, MenuSyncPacket.class, new MenuSyncPacket());
    }

    private static <T> void register(int packetId, Class<T> clazz, IPacket<T> packet) {
        CHANNEL.registerMessage(packetId, clazz, packet::encode, packet::decode, packet::handle);
    }
}

