/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.gui.control;

import com.almostreliable.lazierae2.content.processor.ProcessorEntity;
import com.almostreliable.lazierae2.content.processor.ProcessorMenu;
import com.almostreliable.lazierae2.content.processor.SideConfiguration;
import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.gui.ProcessorScreen;
import com.almostreliable.lazierae2.gui.widgets.GenericButton;
import com.almostreliable.lazierae2.network.PacketHandler;
import com.almostreliable.lazierae2.network.packets.SideConfigPacket;
import com.almostreliable.lazierae2.util.GuiUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.function.Supplier;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.sounds.SoundManager;
import net.minecraft.resources.ResourceLocation;

public final class IOControl {
    private static final int BUTTON_SIZE = 6;
    private static final int INNER_SIZE = 4;
    private static final String TEXTURE_ID = "io";

    private IOControl() {
    }

    public static IOButton[] setup(ProcessorScreen screen, int x, int y) {
        ArrayList<IOButton> buttons = new ArrayList<IOButton>();
        buttons.add(new IOButton(screen, TypeEnums.BLOCK_SIDE.TOP, x + IOControl.getPosition(1), y + IOControl.getPosition(0)));
        buttons.add(new IOButton(screen, TypeEnums.BLOCK_SIDE.LEFT, x + IOControl.getPosition(0), y + IOControl.getPosition(1)));
        buttons.add(new IOButton(screen, TypeEnums.BLOCK_SIDE.FRONT, x + IOControl.getPosition(1), y + IOControl.getPosition(1)));
        buttons.add(new IOButton(screen, TypeEnums.BLOCK_SIDE.RIGHT, x + IOControl.getPosition(2), y + IOControl.getPosition(1)));
        buttons.add(new IOButton(screen, TypeEnums.BLOCK_SIDE.BOTTOM, x + IOControl.getPosition(1), y + IOControl.getPosition(2)));
        buttons.add(new IOButton(screen, TypeEnums.BLOCK_SIDE.BACK, x + IOControl.getPosition(2), y + IOControl.getPosition(2)));
        return buttons.toArray(new IOButton[0]);
    }

    private static int getPosition(int offset) {
        return offset * 6;
    }

    private static final class IOButton
    extends GenericButton {
        private final TypeEnums.BLOCK_SIDE side;
        private final ProcessorEntity entity;
        private final GuiUtil.Tooltip tooltip;

        private IOButton(ProcessorScreen screen, TypeEnums.BLOCK_SIDE side, int pX, int pY) {
            super(screen, pX, pY, 6, 6, IOControl.TEXTURE_ID);
            this.side = side;
            this.entity = (ProcessorEntity)((ProcessorMenu)screen.m_6262_()).entity;
            this.tooltip = GuiUtil.Tooltip.builder().title("io.title", new Supplier[0]).blank().keyEnum("io.side", TypeEnums.TRANSLATE_TYPE.BLOCK_SIDE, () -> side).keyEnum("io.current", TypeEnums.TRANSLATE_TYPE.IO_SETTING, () -> this.entity.sideConfig.get(side)).blank().line(Screen::m_96638_, "io.description", new Supplier[0]).blank(Screen::m_96638_).shiftForInfo().conditional(extendedInfo -> extendedInfo.condition(() -> side == TypeEnums.BLOCK_SIDE.FRONT).then(GuiUtil.Tooltip.builder().shiftClickAction("io.reset_all", new Supplier[0])).otherwise(GuiUtil.Tooltip.builder().clickAction("io.action", new Supplier[0]).shiftClickAction("io.reset", new Supplier[0])));
        }

        @Override
        public void m_6303_(PoseStack stack, int mX, int mY, float partial) {
            RenderSystem.m_157456_((int)0, (ResourceLocation)this.texture);
            IOButton.m_93133_((PoseStack)stack, (int)this.f_93620_, (int)this.f_93621_, (float)0.0f, (float)0.0f, (int)6, (int)6, (int)this.getTextureWidth(), (int)this.f_93619_);
            IOButton.m_93133_((PoseStack)stack, (int)(this.f_93620_ + 1), (int)(this.f_93621_ + 1), (float)(6.0f + 4.0f * (float)this.entity.sideConfig.get(this.side).ordinal()), (float)0.0f, (int)4, (int)4, (int)this.getTextureWidth(), (int)this.f_93619_);
        }

        @Override
        protected void clickHandler() {
            this.changeMode();
            PacketHandler.CHANNEL.sendToServer((Object)new SideConfigPacket(this.entity.sideConfig));
        }

        @Override
        protected int getTextureWidth() {
            return this.f_93618_ + 16;
        }

        @Override
        protected int getTextureHeight() {
            return this.f_93619_;
        }

        public void m_7435_(SoundManager manager) {
            if (this.side == TypeEnums.BLOCK_SIDE.FRONT && !Screen.m_96638_()) {
                return;
            }
            super.m_7435_(manager);
        }

        public void m_7428_(PoseStack stack, int mX, int mY) {
            this.screen.m_96597_(stack, this.tooltip.build(), mX, mY);
        }

        private void changeMode() {
            SideConfiguration config = this.entity.sideConfig;
            TypeEnums.IO_SETTING setting = config.get(this.side);
            if (Screen.m_96638_()) {
                if (this.side == TypeEnums.BLOCK_SIDE.FRONT) {
                    config.reset();
                    return;
                }
                setting = TypeEnums.IO_SETTING.OFF;
            } else {
                if (this.side == TypeEnums.BLOCK_SIDE.FRONT) {
                    return;
                }
                setting = switch (setting) {
                    default -> throw new IncompatibleClassChangeError();
                    case TypeEnums.IO_SETTING.INPUT -> TypeEnums.IO_SETTING.OUTPUT;
                    case TypeEnums.IO_SETTING.OUTPUT -> TypeEnums.IO_SETTING.IO;
                    case TypeEnums.IO_SETTING.IO -> TypeEnums.IO_SETTING.OFF;
                    case TypeEnums.IO_SETTING.OFF -> TypeEnums.IO_SETTING.INPUT;
                };
            }
            config.set(this.side, setting);
        }
    }
}

