/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.data.client;

import com.almostreliable.lazierae2.content.GenericBlock;
import com.almostreliable.lazierae2.core.Setup;
import com.almostreliable.lazierae2.util.GameUtil;
import com.almostreliable.lazierae2.util.TextUtil;
import java.util.function.Function;
import net.minecraft.core.Direction;
import net.minecraft.data.DataGenerator;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;

public class BlockStateData
extends BlockStateProvider {
    public BlockStateData(DataGenerator gen, ExistingFileHelper fileHelper) {
        super(gen, "lazierae2", fileHelper);
    }

    protected void registerStatesAndModels() {
        this.machineCustomModel((GenericBlock)((Object)Setup.Blocks.AGGREGATOR.get()));
        this.machineCustomModel((GenericBlock)((Object)Setup.Blocks.ETCHER.get()));
        this.machineCustomModel((GenericBlock)((Object)Setup.Blocks.GRINDER.get()));
        this.machineCustomModel((GenericBlock)((Object)Setup.Blocks.INFUSER.get()));
        this.machineCustomModel((GenericBlock)((Object)Setup.Blocks.REQUESTER.get()));
    }

    private void machineCustomModel(GenericBlock block) {
        String id = GameUtil.getIdFromBlock(block);
        ResourceLocation modelInactive = TextUtil.getRL(TextUtil.f("block/{}", id));
        ResourceLocation modelActive = TextUtil.getRL(TextUtil.f("block/{}", this.formActiveId(id)));
        this.orientedBlock(block, state -> new ModelFile.UncheckedModelFile(((Boolean)state.m_61143_((Property)GenericBlock.ACTIVE)).equals(Boolean.TRUE) ? modelActive : modelInactive));
    }

    private void orientedBlock(Block block, Function<? super BlockState, ? extends ModelFile> modelFunction) {
        this.getVariantBuilder(block).forAllStates(state -> {
            Direction facing = (Direction)state.m_61143_((Property)GenericBlock.FACING);
            return ConfiguredModel.builder().modelFile((ModelFile)modelFunction.apply((BlockState)state)).rotationX(facing.m_122434_() == Direction.Axis.Y ? facing.m_122421_().m_122540_() * -90 : 0).rotationY(facing.m_122434_() == Direction.Axis.Y ? 0 : (facing.m_122416_() + 2) % 4 * 90).build();
        });
    }

    private String formActiveId(String id) {
        return TextUtil.f("{}_active", id);
    }
}

