/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.core;

import com.almostreliable.lazierae2.LazierAE2;
import com.almostreliable.lazierae2.util.TextUtil;
import java.util.List;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import org.apache.commons.lang3.tuple.Pair;

public final class Config {
    public static final ForgeConfigSpec COMMON_SPEC;
    public static final CommonConfig COMMON;

    private Config() {
    }

    public static void onConfigReloaded(ModConfigEvent.Reloading event) {
        if (event.getConfig().getModId().equals("lazierae2")) {
            LazierAE2.LOG.debug("config reloaded");
            List.of(Config.COMMON.aggregator, Config.COMMON.etcher, Config.COMMON.grinder, Config.COMMON.infuser).forEach(config -> {
                Integer maxUpgrades = (Integer)config.upgradeSlots.get();
                int energyMultiSize = ((List)config.energyUsageMulti.get()).size();
                int processTimeMultiSize = ((List)config.processTimeMulti.get()).size();
                if (maxUpgrades != energyMultiSize) {
                    LazierAE2.LOG.error(TextUtil.f("Config issue for {} detected! Maximum upgrades are set to {} but energy usage multiplier list has {} entries.", config.id, maxUpgrades, energyMultiSize));
                }
                if (maxUpgrades != processTimeMultiSize) {
                    LazierAE2.LOG.error(TextUtil.f("Config issue for {} detected! Maximum upgrades are set to {} but process time multiplier list has {} entries.", config.id, maxUpgrades, processTimeMultiSize));
                }
            });
        }
    }

    static {
        Pair commonPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON_SPEC = (ForgeConfigSpec)commonPair.getRight();
        COMMON = (CommonConfig)commonPair.getLeft();
    }

    public static final class CommonConfig {
        public final ProcessorConfig aggregator;
        public final ProcessorConfig etcher;
        public final ProcessorConfig grinder;
        public final ProcessorConfig infuser;
        public final ForgeConfigSpec.DoubleValue requesterIdleEnergy;
        public final ForgeConfigSpec.BooleanValue requesterRequireChannel;
        public final ForgeConfigSpec.BooleanValue inWorldResonating;
        public final ForgeConfigSpec.BooleanValue pressDescription;
        public final ForgeConfigSpec.BooleanValue singularityDescription;

        private CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.push("processor");
            builder.comment(new String[]{"##################################################################################", " This section lets you configure the various values of the mod processors.       #", " If there is an option mentioning 'upgrades', AE2 Acceleration Cards are meant.  #", "##################################################################################"});
            this.aggregator = new ProcessorConfig(builder, "aggregator");
            this.grinder = new ProcessorConfig(builder, "grinder");
            this.infuser = new ProcessorConfig(builder, "infuser");
            this.etcher = new ProcessorConfig(builder, "etcher");
            builder.pop();
            builder.push("requester");
            this.requesterIdleEnergy = builder.comment(TextUtil.f(" The energy the {} drains from the ME network when idle.", "requester")).defineInRange("idle_energy", 5.0, 0.0, Double.MAX_VALUE);
            this.requesterRequireChannel = builder.comment(TextUtil.f(" Whether the {} requires an ME network channel to function.", "requester")).define("require_channel", true);
            builder.pop();
            builder.push("misc");
            this.inWorldResonating = builder.comment(" Whether the Resonating Dust should be craft-able in the world.").define("inworld_resonating", true);
            this.pressDescription = builder.comment(" Whether the Universal Press should have a custom JEI info panel which explains that it's only craftable and can't be found in meteorites.").define("press_desc", true);
            this.singularityDescription = builder.comment(" Whether the Singularity should have a custom JEI info panel which explains that it's easily obtainable by pumping water into a Matter Condenser.").define("singularity_desc", true);
            builder.pop();
        }
    }

    public static final class ProcessorConfig {
        public final ForgeConfigSpec.IntValue upgradeSlots;
        public final ForgeConfigSpec.IntValue baseEnergyBuffer;
        public final ForgeConfigSpec.IntValue energyBufferAdd;
        public final ForgeConfigSpec.IntValue baseEnergyUsage;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> energyUsageMulti;
        public final ForgeConfigSpec.IntValue baseProcessTime;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> processTimeMulti;
        private final String id;

        private ProcessorConfig(ForgeConfigSpec.Builder builder, String id) {
            this.id = id;
            builder.push(id);
            this.upgradeSlots = builder.comment(new String[]{TextUtil.f(" The maximum number of upgrades the {} can hold.", id), " By default, upgrades will speed up the processor and increase the energy buffer at the cost of a higher energy consumption."}).defineInRange("upgrade_slots", 8, 0, 64);
            this.baseEnergyBuffer = builder.comment(new String[]{TextUtil.f(" The amount of energy the {} can hold.", id), " The energy buffer is used to store energy before it is used."}).defineInRange("energy_buffer_base", 100000, 0, Integer.MAX_VALUE);
            this.energyBufferAdd = builder.comment(new String[]{TextUtil.f(" The additional amount of energy the {} can hold per upgrade.", id), " Each upgrade increases the energy buffer by this amount.", " Setting this to 0 will disable the energy buffer upgrade.", " Calculation: energyBuffer = baseEnergyBuffer + (installedUpgrades * energyBufferAdd)"}).defineInRange("energy_buffer_add", 50000, 0, Integer.MAX_VALUE);
            this.baseEnergyUsage = builder.comment(new String[]{TextUtil.f(" The base amount of energy the {} uses per tick.", id), " Each recipe can overwrite this value. This is just a fallback value if a recipe does not specify an energy usage.", " All recipes from the mod itself have an own energy usage value and this setting won't have any effect on them.", " This is only useful for custom recipes e.g. for modpack makers."}).defineInRange("energy_usage_base", 300, 0, Integer.MAX_VALUE);
            this.energyUsageMulti = builder.comment(new String[]{TextUtil.f(" The energy usage multiplier the {} uses per tick per upgrade.", id), " The list index corresponds to the amount of upgrades installed.", " The amount of elements in this list has to be equal to the maximum amount of upgrades.", " Lower values than 1 will decrease the energy consumption, higher values will increase it."}).defineList("energy_usage_multi", List.of(Double.valueOf(1.1), Double.valueOf(1.25), Double.valueOf(1.5), Double.valueOf(2.0), Double.valueOf(3.1), Double.valueOf(4.5), Double.valueOf(6.1), Double.valueOf(8.0)), Double.class::isInstance);
            this.baseProcessTime = builder.comment(new String[]{TextUtil.f(" The base processing time the {} needs for a recipe.", id), " Each recipe can overwrite this value. This is just a fallback value if a recipe does not specify a processing time.", " All recipes from the mod itself have an own processing time value and this setting won't have any effect on them.", " This is only useful for custom recipes e.g. for modpack makers."}).defineInRange("process_time_base", 200, 0, Integer.MAX_VALUE);
            this.processTimeMulti = builder.comment(new String[]{TextUtil.f(" The processing time multiplier the {} uses per upgrade.", id), " The list index corresponds to the amount of upgrades installed.", " The amount of elements in this list has to be equal to the maximum amount of upgrades.", " Lower values than 1 will increase the processing speed, higher values will decrease it."}).defineList("process_time_multi", List.of(Double.valueOf(0.94), Double.valueOf(0.8), Double.valueOf(0.64), Double.valueOf(0.5), Double.valueOf(0.33), Double.valueOf(0.16), Double.valueOf(0.09), Double.valueOf(0.05)), Double.class::isInstance);
            builder.pop();
        }
    }
}

