/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content.processor;

import com.almostreliable.lazierae2.content.GenericBlock;
import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.network.sync.IDataHandler;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.function.Consumer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.util.INBTSerializable;

public class SideConfiguration
implements INBTSerializable<CompoundTag>,
IDataHandler {
    private final BlockEntity entity;
    private final EnumMap<Direction, TypeEnums.IO_SETTING> config = new EnumMap(Direction.class);
    private boolean changed;

    SideConfiguration(BlockEntity entity) {
        this.entity = entity;
        for (Direction direction : Direction.values()) {
            this.config.put(direction, TypeEnums.IO_SETTING.OFF);
        }
    }

    public TypeEnums.IO_SETTING get(Direction direction) {
        return this.config.get(direction);
    }

    public TypeEnums.IO_SETTING get(TypeEnums.BLOCK_SIDE side) {
        return this.config.get(this.getDirectionFromSide(side));
    }

    public void set(TypeEnums.BLOCK_SIDE side, TypeEnums.IO_SETTING setting) {
        this.config.put(this.getDirectionFromSide(side), setting);
        this.entity.m_6596_();
        this.changed = true;
    }

    public void reset() {
        for (Direction direction : Direction.values()) {
            this.config.put(direction, TypeEnums.IO_SETTING.OFF);
        }
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        for (TypeEnums.BLOCK_SIDE side : TypeEnums.BLOCK_SIDE.values()) {
            tag.m_128405_(side.toString(), this.get(side).ordinal());
        }
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        for (TypeEnums.BLOCK_SIDE side : TypeEnums.BLOCK_SIDE.values()) {
            this.set(side, TypeEnums.IO_SETTING.values()[tag.m_128451_(side.toString())]);
        }
    }

    @Override
    public void encode(FriendlyByteBuf buffer) {
        for (int i = 0; i < TypeEnums.BLOCK_SIDE.values().length; ++i) {
            buffer.writeInt(this.get(TypeEnums.BLOCK_SIDE.values()[i]).ordinal());
        }
        this.changed = false;
    }

    @Override
    public void decode(FriendlyByteBuf buffer) {
        for (int i = 0; i < TypeEnums.BLOCK_SIDE.values().length; ++i) {
            this.set(TypeEnums.BLOCK_SIDE.values()[i], TypeEnums.IO_SETTING.values()[buffer.readInt()]);
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    void forEachOutput(Consumer<? super Direction> consumer) {
        for (Direction direction : Direction.values()) {
            if (this.config.get(direction) != TypeEnums.IO_SETTING.OUTPUT && this.config.get(direction) != TypeEnums.IO_SETTING.IO) continue;
            consumer.accept((Direction)direction);
        }
    }

    private Direction getDirectionFromSide(TypeEnums.BLOCK_SIDE side) {
        Direction facing = (Direction)this.entity.m_58900_().m_61143_((Property)GenericBlock.FACING);
        return switch (side) {
            case TypeEnums.BLOCK_SIDE.TOP -> Direction.UP;
            case TypeEnums.BLOCK_SIDE.BOTTOM -> Direction.DOWN;
            case TypeEnums.BLOCK_SIDE.LEFT -> facing.m_122427_();
            case TypeEnums.BLOCK_SIDE.RIGHT -> facing.m_122428_();
            case TypeEnums.BLOCK_SIDE.BACK -> facing.m_122424_();
            default -> facing;
        };
    }

    boolean isConfigured() {
        return Arrays.stream(Direction.values()).anyMatch(direction -> this.config.get(direction) != TypeEnums.IO_SETTING.OFF);
    }
}

