/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content.processor;

import com.almostreliable.lazierae2.content.GenericBlock;
import com.almostreliable.lazierae2.content.processor.ProcessorEntity;
import com.almostreliable.lazierae2.content.processor.ProcessorType;
import com.almostreliable.lazierae2.util.GuiUtil;
import com.almostreliable.lazierae2.util.TextUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public class ProcessorBlock
extends GenericBlock {
    private final ProcessorType processorType;

    public ProcessorBlock(ProcessorType processorType) {
        this.processorType = processorType;
    }

    public void m_6402_(Level level, BlockPos pos, BlockState state, @Nullable LivingEntity placer, ItemStack stack) {
        BlockEntity entity = level.m_7702_(pos);
        if (!level.f_46443_ && entity instanceof ProcessorEntity) {
            ProcessorEntity processor = (ProcessorEntity)entity;
            processor.playerPlace(stack);
        }
        super.m_6402_(level, pos, state, placer, stack);
    }

    @Override
    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        CompoundTag tag = stack.m_41783_();
        int upgrades = 0;
        int energy = 0;
        boolean sideConfig = false;
        if (tag != null) {
            if (tag.m_128441_("upgrades")) {
                upgrades = ItemStack.m_41712_((CompoundTag)tag.m_128469_("upgrades")).m_41613_();
            }
            if (tag.m_128441_("energy")) {
                energy = tag.m_128469_("energy").m_128451_("energy");
            }
            if (tag.m_128441_("side_config")) {
                sideConfig = true;
            }
        }
        if (upgrades > 0 || energy > 0 || sideConfig) {
            int finalUpgrades = upgrades;
            int finalEnergy = energy;
            boolean finalSideConfig = sideConfig;
            Supplier[] supplierArray = new Supplier[2];
            supplierArray[0] = () -> finalUpgrades;
            supplierArray[1] = this.processorType::getUpgradeSlots;
            tooltip.addAll(GuiUtil.Tooltip.builder().keyValue("item.upgrades", supplierArray).keyValue("item.energy", () -> TextUtil.formatEnergy(finalEnergy, 1, 3, Screen.m_96638_(), true)).line(() -> finalSideConfig, "item.side_config", ChatFormatting.YELLOW, new Supplier[0]).blank().build());
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new ProcessorEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        if (level.f_46443_) {
            return null;
        }
        return (entityLevel, entityState, entityType, entity) -> {
            if (entity instanceof ProcessorEntity) {
                ProcessorEntity processor = (ProcessorEntity)entity;
                processor.tick();
            }
        };
    }

    ProcessorType getProcessorType() {
        return this.processorType;
    }
}

