/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content;

import com.almostreliable.lazierae2.content.GenericEntity;
import com.almostreliable.lazierae2.network.PacketHandler;
import com.almostreliable.lazierae2.network.packets.MenuSyncPacket;
import com.almostreliable.lazierae2.network.sync.MenuSynchronizer;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.network.PacketDistributor;

public abstract class GenericMenu<E extends GenericEntity>
extends AbstractContainerMenu {
    protected static final int SLOT_SIZE = 18;
    protected static final int PLAYER_INV_SIZE = 36;
    public final E entity;
    protected final MenuSynchronizer sync = new MenuSynchronizer();
    private final IItemHandler menuInventory;
    private final Inventory playerInventory;

    protected GenericMenu(MenuType<?> type, int windowId, E entity, Inventory menuInventory) {
        super(type, windowId);
        this.entity = entity;
        this.menuInventory = new InvWrapper((Container)menuInventory);
        this.playerInventory = menuInventory;
    }

    public void m_150429_() {
        super.m_150429_();
        if (this.sync.hasDataHandlers()) {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.playerInventory.f_35978_), (Object)new MenuSyncPacket(this.f_38840_, this.sync::encodeAll));
        }
    }

    public void m_38946_() {
        if (!this.playerInventory.f_35978_.f_19853_.f_46443_ && this.sync.hasChanged()) {
            PacketHandler.CHANNEL.send(PacketDistributor.PLAYER.with(() -> (ServerPlayer)this.playerInventory.f_35978_), (Object)new MenuSyncPacket(this.f_38840_, this.sync::encode));
        }
        super.m_38946_();
    }

    public boolean m_6875_(Player player) {
        return this.entity.m_58904_() != null && AbstractContainerMenu.m_38889_((ContainerLevelAccess)ContainerLevelAccess.m_39289_((Level)this.entity.m_58904_(), (BlockPos)this.entity.m_58899_()), (Player)player, (Block)this.entity.m_58900_().m_60734_());
    }

    public void receiveServerData(FriendlyByteBuf data) {
        this.sync.decode(data);
    }

    protected void setupPlayerInventory() {
        int i;
        for (i = 0; i < 3; ++i) {
            for (int j = 0; j < 9; ++j) {
                this.m_38897_((Slot)new SlotItemHandler(this.menuInventory, j + i * 9 + 9, 8 + j * 18, this.getSlotY() + i * 18));
            }
        }
        for (i = 0; i < 9; ++i) {
            this.m_38897_((Slot)new SlotItemHandler(this.menuInventory, i, 8 + i * 18, this.getSlotY() + 58));
        }
    }

    protected abstract void setupContainerInventory();

    protected abstract int getSlotY();
}

