/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.content;

import com.almostreliable.lazierae2.content.GenericEntity;
import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.util.GuiUtil;
import com.almostreliable.lazierae2.util.TextUtil;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.network.NetworkHooks;

public abstract class GenericBlock
extends Block
implements EntityBlock {
    public static final BooleanProperty ACTIVE = BooleanProperty.m_61465_((String)"active");
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;

    protected GenericBlock() {
        super(BlockBehaviour.Properties.m_60939_((Material)Material.f_76279_).m_60978_(3.0f).m_60918_(SoundType.f_56743_));
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)Direction.NORTH));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        BlockState superState = super.m_5573_(context);
        BlockState state = superState == null ? this.m_49966_() : superState;
        return (BlockState)((BlockState)state.m_61124_((Property)ACTIVE, (Comparable)Boolean.valueOf(false))).m_61124_((Property)FACING, (Comparable)context.m_8125_().m_122424_());
    }

    public void m_5707_(Level level, BlockPos pos, BlockState state, Player player) {
        BlockEntity be = level.m_7702_(pos);
        if (!level.f_46443_ && be instanceof GenericEntity) {
            GenericEntity entity = (GenericEntity)be;
            entity.playerDestroy(player.m_7500_());
        }
        super.m_5707_(level, pos, state, player);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{ACTIVE});
        builder.m_61104_(new Property[]{FACING});
    }

    public void m_5871_(ItemStack stack, @Nullable BlockGetter level, List<Component> tooltip, TooltipFlag flag) {
        String description = TextUtil.translateAsString(TypeEnums.TRANSLATE_TYPE.TOOLTIP, TextUtil.f("{}.description", this.getId()));
        if (!description.startsWith(TextUtil.f("{}.{}", TypeEnums.TRANSLATE_TYPE.TOOLTIP.toString().toLowerCase(), "lazierae2"))) {
            tooltip.addAll(GuiUtil.Tooltip.builder().line(Screen::m_96638_, TextUtil.f("{}.description", this.getId()), ChatFormatting.AQUA, new Supplier[0]).hotkeyHoldAction(() -> !Screen.m_96638_(), "key.keyboard.left.shift", "extended_info", new Supplier[0]).build());
        }
        super.m_5871_(stack, level, tooltip, flag);
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (level.m_5776_() || player.m_6144_()) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity entity = level.m_7702_(pos);
        if (entity instanceof MenuProvider) {
            MenuProvider menuProvider = (MenuProvider)entity;
            if (player instanceof ServerPlayer) {
                ServerPlayer invoker = (ServerPlayer)player;
                NetworkHooks.openGui((ServerPlayer)invoker, (MenuProvider)menuProvider, (BlockPos)pos);
            }
        }
        return InteractionResult.CONSUME;
    }

    public String getId() {
        ResourceLocation registryName = this.getRegistryName();
        assert (registryName != null);
        return registryName.m_135815_();
    }
}

