/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.compat.jei.category;

import com.almostreliable.lazierae2.compat.jei.category.ProcessorCategory;
import com.almostreliable.lazierae2.gui.ProcessorScreen;
import com.almostreliable.lazierae2.recipe.property.IRecipeInputProvider;
import com.almostreliable.lazierae2.recipe.type.TripleInputRecipe;
import com.almostreliable.lazierae2.util.GuiUtil;
import com.almostreliable.lazierae2.util.TextUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.HashMap;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class TripleInputCategory
extends ProcessorCategory<TripleInputRecipe> {
    private final IDrawable background;
    private final IDrawable slot;

    TripleInputCategory(IGuiHelper guiHelper, String id, ItemLike iconProvider) {
        super(guiHelper, id, iconProvider);
        ResourceLocation backgroundTexture = ProcessorScreen.TEXTURE;
        this.background = guiHelper.drawableBuilder(backgroundTexture, 42, 6, 92, 62).setTextureSize(178, 154).build();
        this.slot = guiHelper.drawableBuilder(backgroundTexture, 43, 28, 18, 18).setTextureSize(178, 154).build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, TripleInputRecipe recipe, IFocusGroup focuses) {
        builder.addSlot(RecipeIngredientRole.OUTPUT, 74, 23).addItemStack(recipe.m_8043_());
        NonNullList<IRecipeInputProvider> inputs = recipe.getInputs();
        HashMap<Integer, List<ItemStack>> inputMap = new HashMap<Integer, List<ItemStack>>();
        for (int i = 0; i < inputs.size(); ++i) {
            ItemStack[] stacks;
            for (ItemStack stack : stacks = ((IRecipeInputProvider)inputs.get(i)).ingredient().m_43908_()) {
                stack.m_41764_(((IRecipeInputProvider)inputs.get(i)).count());
            }
            inputMap.put(i, List.of(stacks));
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 2).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, (List)inputMap.get(0));
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 23).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputMap.size() >= 2 ? (List)inputMap.get(1) : List.of(ItemStack.f_41583_));
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 44).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, inputMap.size() >= 3 ? (List)inputMap.get(2) : List.of(ItemStack.f_41583_));
        builder.setShapeless();
        super.setRecipe(builder, (Object)recipe, focuses);
    }

    public void draw(TripleInputRecipe recipe, IRecipeSlotsView slotsView, PoseStack stack, double mX, double mY) {
        this.slot.draw(stack, 1, 1);
        this.slot.draw(stack, 1, 43);
        this.progressEmpty.draw(stack, 36, 17);
        this.progress.draw(stack, 36, 17);
        String energy = TextUtil.formatEnergy(recipe.getEnergyCost(), 1, 3, false, true);
        GuiUtil.renderText(stack, energy, GuiUtil.ANCHOR.TOP_RIGHT, 91, 46, 0.8f, 0);
        String time = TextUtil.f("{} ticks", recipe.getProcessTime());
        GuiUtil.renderText(stack, time, GuiUtil.ANCHOR.TOP_RIGHT, 91, 54, 0.8f, 0);
    }

    public Class<? extends TripleInputRecipe> getRecipeClass() {
        return TripleInputRecipe.class;
    }
}

