/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.compat.jei.category;

import com.almostreliable.lazierae2.compat.jei.category.ProcessorCategory;
import com.almostreliable.lazierae2.gui.ProcessorScreen;
import com.almostreliable.lazierae2.recipe.property.IRecipeInputProvider;
import com.almostreliable.lazierae2.recipe.type.SingleInputRecipe;
import com.almostreliable.lazierae2.util.GuiUtil;
import com.almostreliable.lazierae2.util.TextUtil;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.minecraft.core.NonNullList;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class SingleInputCategory
extends ProcessorCategory<SingleInputRecipe> {
    private final IDrawable background;

    SingleInputCategory(IGuiHelper guiHelper, String id, ItemLike iconProvider) {
        super(guiHelper, id, iconProvider);
        ResourceLocation backgroundTexture = ProcessorScreen.TEXTURE;
        this.background = guiHelper.drawableBuilder(backgroundTexture, 42, 22, 92, 34).setTextureSize(178, 154).build();
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, SingleInputRecipe recipe, IFocusGroup focuses) {
        ItemStack[] inputStacks;
        builder.addSlot(RecipeIngredientRole.OUTPUT, 74, 7).addItemStack(recipe.m_8043_());
        NonNullList<IRecipeInputProvider> inputs = recipe.getInputs();
        for (ItemStack stack : inputStacks = ((IRecipeInputProvider)inputs.get(0)).ingredient().m_43908_()) {
            stack.m_41764_(((IRecipeInputProvider)inputs.get(0)).count());
        }
        builder.addSlot(RecipeIngredientRole.INPUT, 2, 7).addIngredients((IIngredientType)VanillaTypes.ITEM_STACK, List.of(inputStacks));
        super.setRecipe(builder, (Object)recipe, focuses);
    }

    public void draw(SingleInputRecipe recipe, IRecipeSlotsView slotsView, PoseStack stack, double mX, double mY) {
        this.progressEmpty.draw(stack, 36, 1);
        this.progress.draw(stack, 36, 1);
        String energy = TextUtil.formatEnergy(recipe.getEnergyCost(), 1, 3, false, true);
        GuiUtil.renderText(stack, energy, GuiUtil.ANCHOR.TOP_LEFT, 1, 28, 0.8f, 0);
        String time = TextUtil.f("{} ticks", recipe.getProcessTime());
        GuiUtil.renderText(stack, time, GuiUtil.ANCHOR.TOP_RIGHT, 91, 28, 0.8f, 0);
    }

    public Class<? extends SingleInputRecipe> getRecipeClass() {
        return SingleInputRecipe.class;
    }
}

