/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.compat.jei.category;

import com.almostreliable.lazierae2.core.TypeEnums;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipe;
import com.almostreliable.lazierae2.util.TextUtil;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.drawable.IDrawableStatic;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

public abstract class ProcessorCategory<R extends ProcessorRecipe>
implements IRecipeCategory<R> {
    final IDrawable progressEmpty;
    final IDrawableAnimated progress;
    private final String id;
    private final IDrawable icon;

    ProcessorCategory(IGuiHelper guiHelper, String id, ItemLike iconProvider) {
        this.id = id;
        this.icon = guiHelper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack(iconProvider));
        ResourceLocation progressTexture = TextUtil.getRL(TextUtil.f("textures/gui/progress/{}.png", id));
        this.progressEmpty = guiHelper.drawableBuilder(progressTexture, 0, 0, 20, 27).setTextureSize(40, 27).build();
        IDrawableStatic progressDrawable = guiHelper.drawableBuilder(progressTexture, 20, 0, 20, 27).setTextureSize(40, 27).build();
        this.progress = guiHelper.createAnimatedDrawable(progressDrawable, 80, IDrawableAnimated.StartDirection.LEFT, false);
    }

    public Component getTitle() {
        return TextUtil.translate(TypeEnums.TRANSLATE_TYPE.BLOCK, this.id, new ChatFormatting[0]);
    }

    public IDrawable getIcon() {
        return this.icon;
    }
}

