/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.lazierae2.compat.crafttweaker;

import com.almostreliable.lazierae2.content.processor.ProcessorType;
import com.almostreliable.lazierae2.recipe.builder.ProcessorRecipeBuilder;
import com.almostreliable.lazierae2.recipe.type.ProcessorRecipe;
import com.blamejared.crafttweaker.api.CraftTweakerAPI;
import com.blamejared.crafttweaker.api.action.base.IAction;
import com.blamejared.crafttweaker.api.action.recipe.ActionAddRecipe;
import com.blamejared.crafttweaker.api.annotation.ZenRegister;
import com.blamejared.crafttweaker.api.ingredient.IIngredient;
import com.blamejared.crafttweaker.api.ingredient.IIngredientWithAmount;
import com.blamejared.crafttweaker.api.item.IItemStack;
import com.blamejared.crafttweaker.api.recipe.manager.base.IRecipeManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.openzen.zencode.java.ZenCodeType;

@ZenRegister
@ZenCodeType.Name(value="mods.lazierae2.RecipeBuilderWrapper")
public class RecipeBuilderWrapper {
    private final IRecipeManager<? super ProcessorRecipe> manager;
    private final ResourceLocation id;
    private final ProcessorRecipeBuilder builder;

    RecipeBuilderWrapper(IRecipeManager<? super ProcessorRecipe> manager, ProcessorType type, ResourceLocation id, IItemStack output) {
        this.manager = manager;
        this.id = id;
        this.builder = switch (type) {
            default -> throw new IncompatibleClassChangeError();
            case ProcessorType.AGGREGATOR -> ProcessorRecipeBuilder.aggregator((ItemLike)output.getInternal().m_41720_(), output.getAmount());
            case ProcessorType.ETCHER -> ProcessorRecipeBuilder.etcher((ItemLike)output.getInternal().m_41720_(), output.getAmount());
            case ProcessorType.GRINDER -> ProcessorRecipeBuilder.grinder((ItemLike)output.getInternal().m_41720_(), output.getAmount());
            case ProcessorType.INFUSER -> ProcessorRecipeBuilder.infuser((ItemLike)output.getInternal().m_41720_(), output.getAmount());
        };
    }

    @ZenCodeType.Method
    public RecipeBuilderWrapper input(IIngredientWithAmount input) {
        this.builder.input(input.getIngredient().asVanillaIngredient(), input.getAmount());
        return this;
    }

    @ZenCodeType.Method
    public RecipeBuilderWrapper input(IIngredient input, int count) {
        this.builder.input(input.asVanillaIngredient(), count);
        return this;
    }

    @ZenCodeType.Method
    public RecipeBuilderWrapper processingTime(int ticks) {
        this.builder.processingTime(ticks);
        return this;
    }

    @ZenCodeType.Method
    public RecipeBuilderWrapper energyCost(int energy) {
        this.builder.energyCost(energy);
        return this;
    }

    @ZenCodeType.Method
    public void build() {
        ProcessorRecipe recipe = this.builder.build(this.id);
        CraftTweakerAPI.apply((IAction)new ActionAddRecipe(this.manager, (Recipe)recipe, ""));
    }
}

