/*
 * Decompiled with CFR 0.152.
 */
package bear.bearcore;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.PlayerSleepInBedEvent;
import net.minecraftforge.event.entity.player.PlayerWakeUpEvent;
import net.minecraftforge.event.entity.player.SleepingTimeCheckEvent;
import net.minecraftforge.event.world.SleepFinishedTimeEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.common.Mod;

@Mod(value="bearcore")
public class BearCore {
    public BearCore() {
        IEventBus bus = MinecraftForge.EVENT_BUS;
        bus.addListener(this::onBonemeal);
        bus.addListener(this::onTrySleeping);
        bus.addListener(this::onSleepTime);
        bus.addListener(this::onTimeChange);
        bus.addListener(this::onWakeUp);
    }

    public void onBonemeal(BonemealEvent event) {
        Block block = event.getBlock().m_60734_();
        if (block instanceof BonemealableBlock) {
            BonemealableBlock block2 = (BonemealableBlock)block;
            if (!event.getWorld().m_5776_() && event.getPlayer() != null) {
                event.getPlayer().m_5661_((Component)new TextComponent("Stop Cheating!"), false);
                if (block2.m_7370_((BlockGetter)event.getWorld(), event.getPos(), event.getBlock(), false) && !event.getStack().m_41619_()) {
                    event.getStack().m_41774_(1);
                }
            }
        }
        event.setCanceled(true);
    }

    public void onTrySleeping(PlayerSleepInBedEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        CompoundTag data = event.getPlayer().getPersistentData();
        if (event.getPlayer().f_19853_.m_46467_() - data.m_128454_("bear_last_slept") > 10000L) {
            return;
        }
        if (!event.getPlayer().f_19853_.m_5776_()) {
            event.getPlayer().m_5661_((Component)new TextComponent("Get Back to work!"), false);
        }
        event.setResult(Player.BedSleepingProblem.OTHER_PROBLEM);
    }

    public void onSleepTime(SleepingTimeCheckEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        CompoundTag data = event.getPlayer().getPersistentData();
        if (event.getPlayer().f_19853_.m_46467_() - data.m_128454_("bear_last_slept") > 10000L) {
            event.setResult(Event.Result.ALLOW);
        }
    }

    public void onTimeChange(SleepFinishedTimeEvent event) {
        event.setTimeAddition(event.getWorld().m_8044_() + 1000L);
    }

    public void onWakeUp(PlayerWakeUpEvent event) {
        if (event.getPlayer() == null) {
            return;
        }
        event.getPlayer().getPersistentData().m_128356_("bear_last_slept", event.getPlayer().f_19853_.m_46467_());
        if (!event.getPlayer().f_19853_.m_5776_()) {
            event.getPlayer().m_5661_((Component)new TextComponent("Get Back to work!"), false);
        }
    }
}

