/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.entity.monster;

import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.phys.Vec3;
import twilightforest.TFSounds;
import twilightforest.entity.IHostileMount;
import twilightforest.entity.ai.ThrowRiderGoal;
import twilightforest.world.registration.biomes.BiomeKeys;

public class Yeti
extends Monster
implements IHostileMount {
    private static final EntityDataAccessor<Boolean> ANGER_FLAG = SynchedEntityData.m_135353_(Yeti.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);
    private static final AttributeModifier ANGRY_MODIFIER = new AttributeModifier("Angry follow range boost", 24.0, AttributeModifier.Operation.ADDITION);

    public Yeti(EntityType<? extends Yeti> type, Level world) {
        super(type, world);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(1, (Goal)new ThrowRiderGoal((PathfinderMob)this, 1.0, false){

            @Override
            protected void m_6739_(LivingEntity victim, double p_190102_2_) {
                super.m_6739_(victim, p_190102_2_);
                if (!Yeti.this.m_20197_().isEmpty()) {
                    Yeti.this.m_5496_(TFSounds.YETI_GRAB, 1.0f, 1.25f + Yeti.this.m_21187_().nextFloat() * 0.5f);
                }
            }

            @Override
            public void m_8041_() {
                if (!Yeti.this.m_20197_().isEmpty()) {
                    Yeti.this.m_5496_(TFSounds.YETI_THROW, 1.0f, 1.25f + Yeti.this.m_21187_().nextFloat() * 0.5f);
                }
                super.m_8041_();
            }
        });
        this.f_21345_.m_25352_(2, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 8.0f));
        this.f_21345_.m_25352_(3, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21346_.m_25352_(1, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]));
        this.f_21346_.m_25352_(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, true));
    }

    public static AttributeSupplier.Builder registerAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22276_, 20.0).m_22268_(Attributes.f_22279_, 0.38).m_22268_(Attributes.f_22281_, 0.0).m_22268_(Attributes.f_22277_, 4.0);
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ANGER_FLAG, (Object)false);
    }

    public void m_8107_() {
        super.m_8107_();
        if (!this.m_20197_().isEmpty()) {
            this.m_21563_().m_24960_((Entity)this.m_20197_().get(0), 100.0f, 100.0f);
        }
    }

    public boolean m_6469_(DamageSource source, float amount) {
        if (source.m_7639_() != null && !source.m_19390_()) {
            this.setAngry(true);
        }
        return super.m_6469_(source, amount);
    }

    public boolean isAngry() {
        return (Boolean)this.f_19804_.m_135370_(ANGER_FLAG);
    }

    public void setAngry(boolean anger) {
        this.f_19804_.m_135381_(ANGER_FLAG, (Object)anger);
        if (!this.f_19853_.f_46443_) {
            if (anger) {
                if (!this.m_21051_(Attributes.f_22277_).m_22109_(ANGRY_MODIFIER)) {
                    this.m_21051_(Attributes.f_22277_).m_22118_(ANGRY_MODIFIER);
                }
            } else {
                this.m_21051_(Attributes.f_22277_).m_22130_(ANGRY_MODIFIER);
            }
        }
    }

    public void m_7380_(CompoundTag compound) {
        super.m_7380_(compound);
        compound.m_128379_("Angry", this.isAngry());
    }

    public void m_7378_(CompoundTag compound) {
        super.m_7378_(compound);
        this.setAngry(compound.m_128471_("Angry"));
    }

    public void m_7332_(Entity passenger) {
        Vec3 riderPos = this.getRiderPosition(passenger);
        passenger.m_6034_(riderPos.f_82479_, riderPos.f_82480_, riderPos.f_82481_);
    }

    public double m_6048_() {
        return 2.25;
    }

    private Vec3 getRiderPosition(@Nullable Entity passenger) {
        if (passenger != null) {
            float distance = 0.4f;
            double dx = Math.cos((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0) * (double)distance;
            double dz = Math.sin((double)(this.m_146908_() + 90.0f) * Math.PI / 180.0) * (double)distance;
            return new Vec3(this.m_20185_() + dx, this.m_20186_() + this.m_6048_() + passenger.m_6049_(), this.m_20189_() + dz);
        }
        return new Vec3(this.m_20185_(), this.m_20186_(), this.m_20189_());
    }

    public boolean canRiderInteract() {
        return true;
    }

    public static boolean yetiSnowyForestSpawnHandler(EntityType<? extends Yeti> entityType, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random random) {
        Optional key = world.m_204166_(pos).m_203543_();
        if (Objects.equals(key, Optional.of(BiomeKeys.SNOWY_FOREST))) {
            return Yeti.m_21400_(entityType, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)random);
        }
        return Yeti.normalYetiSpawnHandler(entityType, world, reason, pos, random);
    }

    public static boolean normalYetiSpawnHandler(EntityType<? extends Monster> entity, ServerLevelAccessor world, MobSpawnType reason, BlockPos pos, Random random) {
        return world.m_46791_() != Difficulty.PEACEFUL && Yeti.isValidLightLevel(world, pos, random) && Yeti.m_21400_(entity, (LevelAccessor)world, (MobSpawnType)reason, (BlockPos)pos, (Random)random);
    }

    public static boolean isValidLightLevel(ServerLevelAccessor world, BlockPos blockPos, Random random) {
        Optional key = world.m_204166_(blockPos).m_203543_();
        if (world.m_45517_(LightLayer.SKY, blockPos) > random.nextInt(32)) {
            return Objects.equals(key, Optional.of(BiomeKeys.SNOWY_FOREST));
        }
        int i = world.m_6018_().m_46470_() ? world.m_46849_(blockPos, 10) : world.m_46803_(blockPos);
        return i <= random.nextInt(8) || Objects.equals(key, Optional.of(BiomeKeys.SNOWY_FOREST));
    }

    public float m_6100_() {
        return super.m_6100_() + 0.55f;
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return TFSounds.YETI_GROWL;
    }

    protected SoundEvent m_7975_(DamageSource damageSourceIn) {
        return TFSounds.YETI_HURT;
    }

    protected SoundEvent m_5592_() {
        return TFSounds.YETI_DEATH;
    }
}

