/*
 * Decompiled with CFR 0.152.
 */
package twilightforest.block;

import com.mojang.math.Vector3f;
import java.util.Objects;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import twilightforest.TFSounds;
import twilightforest.block.TFBlocks;
import twilightforest.block.TranslucentBuiltBlock;
import twilightforest.block.entity.CarminiteBuilderBlockEntity;
import twilightforest.block.entity.TFBlockEntities;
import twilightforest.enums.TowerDeviceVariant;

public class BuilderBlock
extends BaseEntityBlock {
    public static final EnumProperty<TowerDeviceVariant> STATE = EnumProperty.m_61587_((String)"state", TowerDeviceVariant.class);

    public BuilderBlock(BlockBehaviour.Properties props) {
        super(props);
        this.m_49959_((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
    }

    public RenderShape m_7514_(BlockState p_49232_) {
        return RenderShape.MODEL;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{STATE});
    }

    @Deprecated
    public void m_6807_(BlockState state, Level world, BlockPos pos, BlockState oldState, boolean isMoving) {
        if (!world.f_46443_ && state.m_61143_(STATE) == TowerDeviceVariant.BUILDER_INACTIVE && world.m_46753_(pos)) {
            world.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_ACTIVE)));
            world.m_5594_(null, pos, TFSounds.BUILDER_ON, SoundSource.BLOCKS, 0.3f, 0.6f);
        }
    }

    @Deprecated
    public void m_6861_(BlockState state, Level world, BlockPos pos, Block blockIn, BlockPos fromPos, boolean isMoving) {
        if (world.f_46443_) {
            return;
        }
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.m_61143_(STATE));
        if (variant == TowerDeviceVariant.BUILDER_INACTIVE && world.m_46753_(pos)) {
            world.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_ACTIVE)));
            world.m_5594_(null, pos, TFSounds.BUILDER_ON, SoundSource.BLOCKS, 0.3f, 0.6f);
            world.m_186460_(pos, (Block)this, 4);
        }
        if (variant == TowerDeviceVariant.BUILDER_ACTIVE && !world.m_46753_(pos)) {
            world.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
            world.m_5594_(null, pos, TFSounds.BUILDER_OFF, SoundSource.BLOCKS, 0.3f, 0.6f);
            world.m_186460_(pos, (Block)this, 4);
        }
        if (variant == TowerDeviceVariant.BUILDER_TIMEOUT && !world.m_46753_(pos)) {
            world.m_46597_(pos, (BlockState)state.m_61124_(STATE, (Comparable)((Object)TowerDeviceVariant.BUILDER_INACTIVE)));
        }
    }

    @Deprecated
    public void m_7458_(BlockState state, ServerLevel world, BlockPos pos, Random random) {
        TowerDeviceVariant variant = (TowerDeviceVariant)((Object)state.m_61143_(STATE));
        if (variant == TowerDeviceVariant.BUILDER_ACTIVE && world.m_46753_(pos)) {
            this.letsBuild((Level)world, pos);
        }
        if (variant == TowerDeviceVariant.BUILDER_INACTIVE || variant == TowerDeviceVariant.BUILDER_TIMEOUT) {
            ((CarminiteBuilderBlockEntity)Objects.requireNonNull(world.m_7702_(pos))).resetStats();
            for (Direction e : Direction.values()) {
                BuilderBlock.activateBuiltBlocks((Level)world, pos.m_142300_(e));
            }
        }
    }

    private void letsBuild(Level world, BlockPos pos) {
        CarminiteBuilderBlockEntity tileEntity = (CarminiteBuilderBlockEntity)world.m_7702_(pos);
        if (tileEntity != null && !tileEntity.makingBlocks) {
            tileEntity.startBuilding();
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_7100_(BlockState state, Level world, BlockPos pos, Random random) {
        if (state.m_61143_(STATE) == TowerDeviceVariant.BUILDER_ACTIVE) {
            this.sparkle(world, pos);
        }
    }

    public void sparkle(Level worldIn, BlockPos pos) {
        Random random = worldIn.f_46441_;
        double d0 = 0.0625;
        for (int i = 0; i < 6; ++i) {
            double d1 = (float)pos.m_123341_() + random.nextFloat();
            double d2 = (float)pos.m_123342_() + random.nextFloat();
            double d3 = (float)pos.m_123343_() + random.nextFloat();
            if (i == 0 && !worldIn.m_8055_(pos.m_7494_()).m_60804_((BlockGetter)worldIn, pos)) {
                d2 = (double)pos.m_123342_() + d0 + 1.0;
            }
            if (i == 1 && !worldIn.m_8055_(pos.m_7495_()).m_60804_((BlockGetter)worldIn, pos)) {
                d2 = (double)pos.m_123342_() - d0;
            }
            if (i == 2 && !worldIn.m_8055_(pos.m_142128_()).m_60804_((BlockGetter)worldIn, pos)) {
                d3 = (double)pos.m_123343_() + d0 + 1.0;
            }
            if (i == 3 && !worldIn.m_8055_(pos.m_142127_()).m_60804_((BlockGetter)worldIn, pos)) {
                d3 = (double)pos.m_123343_() - d0;
            }
            if (i == 4 && !worldIn.m_8055_(pos.m_142126_()).m_60804_((BlockGetter)worldIn, pos)) {
                d1 = (double)pos.m_123341_() + d0 + 1.0;
            }
            if (i == 5 && !worldIn.m_8055_(pos.m_142125_()).m_60804_((BlockGetter)worldIn, pos)) {
                d1 = (double)pos.m_123341_() - d0;
            }
            float f1 = 1.0f;
            float f2 = Math.max(0.0f, 0.19999999f);
            float f3 = Math.max(0.0f, -0.099999964f);
            if (!(d1 < (double)pos.m_123341_() || d1 > (double)(pos.m_123341_() + 1) || d2 < 0.0 || d2 > (double)(pos.m_123342_() + 1) || d3 < (double)pos.m_123343_()) && !(d3 > (double)(pos.m_123343_() + 1))) continue;
            worldIn.m_7106_((ParticleOptions)new DustParticleOptions(new Vector3f(f1, f2, f3), 1.0f), d1, d2, d3, 0.0, 0.0, 0.0);
        }
    }

    public static void activateBuiltBlocks(Level world, BlockPos pos) {
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == TFBlocks.BUILT_BLOCK.get() && !((Boolean)state.m_61143_((Property)TranslucentBuiltBlock.ACTIVE)).booleanValue()) {
            world.m_46597_(pos, (BlockState)state.m_61124_((Property)TranslucentBuiltBlock.ACTIVE, (Comparable)Boolean.valueOf(true)));
            world.m_5594_(null, pos, TFSounds.BUILDER_REPLACE, SoundSource.BLOCKS, 0.3f, 0.6f);
            world.m_186460_(pos, state.m_60734_(), 10);
        }
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new CarminiteBuilderBlockEntity(pos, state);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(Level level, BlockState state, BlockEntityType<T> type) {
        return state.m_61143_(STATE) == TowerDeviceVariant.BUILDER_ACTIVE ? BuilderBlock.m_152132_(type, (BlockEntityType)((BlockEntityType)TFBlockEntities.TOWER_BUILDER.get()), CarminiteBuilderBlockEntity::tick) : null;
    }
}

