/*
 * Decompiled with CFR 0.152.
 */
package com.sintinium.oauth.profile;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.mojang.authlib.GameProfile;
import com.sintinium.oauth.EncryptionUtil;
import com.sintinium.oauth.profile.IProfile;
import com.sintinium.oauth.profile.MicrosoftProfile;
import com.sintinium.oauth.profile.MojangProfile;
import com.sintinium.oauth.profile.OfflineProfile;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.Util;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.LogManager;

public class ProfileManager {
    private static ProfileManager INSTANCE = null;
    private final List<IProfile> profiles = new ArrayList<IProfile>();
    private final Map<UUID, GameProfile> gameProfiles = new HashMap<UUID, GameProfile>();
    private File saveFile;
    private boolean needsOldKey = false;

    public static ProfileManager getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new ProfileManager();
            INSTANCE.migrateProfileFile();
            ProfileManager.INSTANCE.saveFile = INSTANCE.getSaveFile();
            try {
                INSTANCE.loadProfiles();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return INSTANCE;
    }

    private void migrateProfileFile() {
        File oldFile;
        if (new File(this.getSaveFilePath()).exists()) {
            return;
        }
        File clientFile = new File(FMLPaths.CONFIGDIR.get().toFile(), "oauth-client.toml");
        if (clientFile.exists()) {
            LogManager.getLogger().info("Deleting old oauth-client.toml");
            clientFile.delete();
        }
        if ((oldFile = new File(FMLPaths.CONFIGDIR.get().toFile(), "oauth/profiles.json")).exists()) {
            LogManager.getLogger().info("Migrating profile file location");
            File newFile = this.getSaveFile();
            try {
                FileUtils.copyFile((File)oldFile, (File)newFile);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            oldFile.delete();
            oldFile.getParentFile().delete();
            this.needsOldKey = true;
        }
    }

    private String getSaveFilePath() {
        Object filePath = System.getProperty("user.home");
        filePath = Util.m_137581_() == Util.OS.WINDOWS ? (String)filePath + "\\AppData\\Roaming\\.minecraft\\oauthprofiles.json" : (Util.m_137581_() == Util.OS.OSX ? (String)filePath + "/Library/Application Support/.minecraft/oauthprofiles.json" : (String)filePath + "/.minecraft/oauthprofiles.json");
        return filePath;
    }

    private File getSaveFile() {
        File file = new File(this.getSaveFilePath());
        if (!file.exists()) {
            try {
                file.getParentFile().mkdirs();
                file.createNewFile();
                FileOutputStream stream = new FileOutputStream(file);
                IOUtils.write((String)"[]", (OutputStream)stream, (Charset)Charset.defaultCharset());
                ((OutputStream)stream).close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return file;
    }

    public String getEncryptionKey() {
        return EncryptionUtil.key;
    }

    public String getDecryptionKey() {
        if (this.needsOldKey) {
            return EncryptionUtil.oldKey;
        }
        return EncryptionUtil.key;
    }

    public void loadProfiles() throws IOException {
        JsonArray array;
        try (FileInputStream stream = new FileInputStream(this.saveFile);){
            array = new JsonParser().parse(IOUtils.toString((InputStream)stream, (Charset)Charset.defaultCharset())).getAsJsonArray();
        }
        catch (Exception e) {
            e.printStackTrace();
            array = new JsonArray();
        }
        for (int i = 0; i < array.size(); ++i) {
            IProfile profile;
            String type = array.get(i).getAsJsonObject().get("type").getAsString();
            try {
                switch (type) {
                    case "mojang": {
                        profile = MojangProfile.deserialize(array.get(i).getAsJsonObject());
                        break;
                    }
                    case "microsoft": {
                        profile = MicrosoftProfile.deserialize(array.get(i).getAsJsonObject());
                        break;
                    }
                    case "offline": {
                        profile = OfflineProfile.deserialize(array.get(i).getAsJsonObject());
                        break;
                    }
                    default: {
                        profile = null;
                        break;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                continue;
            }
            if (profile == null) continue;
            this.addProfile(profile, false);
        }
    }

    public void save() throws IOException {
        JsonArray array = new JsonArray();
        for (IProfile profile : this.profiles) {
            array.add((JsonElement)profile.serialize());
        }
        FileOutputStream stream = new FileOutputStream(this.saveFile);
        IOUtils.write((String)array.toString(), (OutputStream)stream, (Charset)Charset.defaultCharset());
        ((OutputStream)stream).close();
        this.needsOldKey = false;
    }

    public List<IProfile> getProfiles() {
        return this.profiles;
    }

    public void addProfile(IProfile profile) {
        this.addProfile(profile, true);
    }

    private void addProfile(IProfile profile, boolean shouldSave) {
        this.profiles.removeIf(p -> p.getUUID().equals(profile.getUUID()));
        this.profiles.add(profile);
        if (!this.gameProfiles.containsKey(profile.getUUID())) {
            this.gameProfiles.put(profile.getUUID(), new GameProfile(profile.getUUID(), profile.getName()));
        }
        if (!shouldSave) {
            return;
        }
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void removeProfile(UUID uuid) {
        this.profiles.removeIf(profile -> profile.getUUID().equals(uuid));
        try {
            this.save();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public IProfile getProfile(UUID uuid) {
        for (IProfile profile : this.profiles) {
            if (!profile.getUUID().equals(uuid)) continue;
            return profile;
        }
        return null;
    }

    public GameProfile getGameProfileOrNull(UUID uuid) {
        return this.gameProfiles.getOrDefault(uuid, null);
    }
}

